#include "mbed.h"
#include "Synchro.h"

Synchro::Synchro(PinName sync, PinName pout): _irq(sync), _pout(pout)
{
    timer.start();//initialization
    trig=0;
    phase=1;//if 0 IRQ's are overlapping, do not work fine
    duration=0;//sync mode
    delay=0;//no delay
    polarity=1;//
    pulse=1;
    _pout=!polarity;//setting output according to polarity
    _duration=0;//resetting counter
    _delay=0;//resetting counter
    _irq.fall(this, &Synchro::_sync);//attach function to IRQ
}

void Synchro::_sync(void)//repeated at every falling edge of the sync input
{
    period=timer.read();
    timer.reset();
    _phase.detach();
    _pulse.detach();    
    
    if (duration==0 and trig==1)//sync mode : 2 timeouts, last until explicitly stopped
    {   
        _phase.attach(this,&Synchro::_up,period*phase/360);
        _pulse.attach(this,&Synchro::_down,period*phase/360+period*pulse/360);
    }
    
    if (duration>0 and trig==1)//trigger mode
    {   
        if (_delay++>delay)//check delay is passed
        {
            if (_duration==0)
            {_phase.attach(this,&Synchro::_up,period*phase/360);}
            //_duration++;
            
            if (_duration++>duration)//check duration is over
            {
                _duration=0;
                trig=0;//reset output single shot mode
                _pulse.attach(this,&Synchro::_down,period*phase/360);            
            }
        }
    }    
}

void Synchro::_up(void)
{
    _pout=polarity;
}

void Synchro::_down(void)
{
    _pout=!polarity;
}

void Synchro::trigger(bool value)
{
    trig=value;
    _delay=0;
}