//
////////////////////////////////////////////////////////////////////////////////
//
//
//               Inclusion de fichiers externes
//
//
////////////////////////////////////////////////////////////////////////////////
//
#include "mbed.h"                  //Définition Mbde
#include "C12832.h"                //Librairie du LCD
//
////////////////////////////////////////////////////////////////////////////////
//
//
//               Déclaration de constantes
//
//
////////////////////////////////////////////////////////////////////////////////
//
/*pour le pilotage des LEDs RVB*/
#define LED_ON 0                   //Définition du label led_ON
#define LED_OFF 1                  //Définition du Label led_OFF
#define SPEED 40                   // Puissance des moteurs
//
////////////////////////////////////////////////////////////////////////////////
//
//
//               Déclaration des entrées/sorties
//
//
////////////////////////////////////////////////////////////////////////////////
//
Serial pc(USBTX, USBRX);       //liaison série pc ou wifi
DigitalOut LED_rouge(D5);    //Led rouge 
DigitalOut LED_bleue(D8);    //Led Bleue
DigitalOut LED_verte(D9);    //Led Verte
//
DigitalIn up(A2);            //Joystick up
DigitalIn down(A3);          //Joystick down
DigitalIn left(A4);          //Joystick left
DigitalIn right(A5);         //Joystick Right
DigitalIn fire(D4);          //Joystick fire
DigitalOut enbMot(PB_12);    //Broche enable carte commande moteurs
//
    //Moteur droit
    PwmOut sens1M1(PA_11);   //PWM sens 1 moteur 1
    PwmOut sens2M1(PB_15);   //PWM sens 2 moteur 1
//
    //moteur gauche
    PwmOut sens1M2(PB_14);   //PWM sens 1 moteur 2
    PwmOut sens2M2(PB_13);   //PWM sens 2 moteur 2
//
BusIn capteursLigne(PC_9,PC_10,PC_11,PC_12,PA_12,PA_14);   //6 Lignes d'entrées de liaison carte capteur
//
DigitalIn   jack(PD_2);     //Jack
//
DigitalIn bumpers(PB_7);    //Bumpers
//
DigitalOut  LED(PA_13);     //LED rouge carte mère D1
//
/*****Réservée pour ER2 ****
**  NE PAS SUPPRIMER      */
//
//
AnalogIn IR_G(PB_1);         //Capteur analogique gauche
AnalogIn IR_D(PC_2);         //Capteur analogique droite
//
DigitalOut ir1(PC_3);        //Led infra rouge 1
DigitalOut ir2(PC_4);        //Led infra rouge 2
DigitalOut ir3(PC_5);        //Led infra rouge 3
DigitalOut ir4(PC_6);        //Led infra rouge 4
DigitalOut ir5(PC_8);        //Led infra rouge 5
//
C12832 lcd(D11, D13, D12, D7, D10); //Broches pour LCD définies par la librairie C12832 
//
AnalogIn pot1 (A0);           //Potentiomètre 1
AnalogIn pot2 (A1);           //Potentiomètre 2
//
////////////////////////////////////////////////////////////////////////////////
//
//             Définition des prototypes des fonctions
//
////////////////////////////////////////////////////////////////////////////////
//
Ticker sampling;    //interruption pour échantillonnage
//
void gestionMAE(void);      //gestion Machine à états primaire
void echantillonnage(void); //fonction appelée par le ticker sampling
void initVariateurs(void);  //initialisation du variateur choisi dans main.h
void commandeMoteurs(int moteurG, int moteurD); //les commandes sont passées en % -100 à +100
void  lecture_cpld(void);          //Lecture des signaux de la carte CPLD
//////////////////////
void capter_ligne(void);
void impulsion_moteur(void); // Appelé par le ticker
void afficherEcran(void); // Affiche le menu
void selection_timer(void); // Incremente la selection de la tempo quand fire est sur rising edge
void changer_etat(void);

typedef enum 
{
  RIEN = 0,
  TOUT = 8,
  PARTIEL = 4,
}etat_capteur;

// ==== VARIABLES ====
int moteurG = 0; // Puissance moteur gauche
int moteurD = 0; // Puissance moteur droit
int etat = 0; // Etat de la machine
int selection = 0; // Selection de la tempo pour la modifier sur l'affichage

bool run = true; // Sors de la boucle principale quand à false.

//Temporisation, index : 0 -> Apres ligne blanche, 1 -> Rotation, 2 -> ligne droite entre 2 plots
float timer[3] = { 1, 1, 1};

// ==== INTERRUPTIONS ====
InterruptIn fire_intpt(D4); // Detection interruptif sur bouton centre shield lcd
InterruptIn jack_intpt(PD_2); // Detection du retirage du jack

Timeout timeout; // Execute une fonction après un temps données
Ticker motor_tk; // Envoi une pulsation au moteur de manière interruptif 
Ticker lcd_tk; // Met à jour l'affichage en dehors de la boucle principale car trop rapide pour l'affichage. 
