#include "mbed.h"                  //Définition Mbde
#include "C12832.h"                //Librairie du LCD

#define RED 0b100
#define GREEN 0b010
#define BLUE 0b001
#define BLACK 0b000

DigitalIn fire(D4);          //Joystick fire
DigitalOut LED_rouge(D5);    //Led rouge
DigitalOut LED_bleue(D8);    //Led Bleue
DigitalOut LED_verte(D9);    //Led Verte
Timer timer;
Ticker ticker;
C12832 lcd(D11, D13, D12, D7, D10); //Broches pour LCD définies par la librairie C12832

int last_state;
int begin; // Temps

int etat_ledVerte = 0, etat = 1;

int getFireState();
bool isElapsedTime(int time);
void setColor(int rgb);

void func_ticker()
{
    etat_ledVerte = !etat_ledVerte;
}


int main()
{
    lcd.cls();
    timer.start();

    setColor(BLACK);

    while(true) {

        lcd.locate(20, 20);
        lcd.printf("Etat %d", etat);

        switch(etat) {
            case 1:

                if(getFireState() == 2) {
                    setColor(RED);
                    etat = 2;
                    begin = timer.read_ms();
                }

                break;
            case 2:

                if(isElapsedTime(5000)) {
                    etat = 1;
                    setColor(BLACK);
                } else if(getFireState() == 2) {
                    begin = timer.read_ms();
                    setColor(BLACK);
                    etat = 3;
                    ticker.attach(&func_ticker, 0.5);
                }

                break;
            case 3:
               
                if(etat_ledVerte)
                    setColor(RED);
                else
                    setColor(BLACK);

                if(isElapsedTime(5000)) {
                    etat = 1;
                    setColor(BLACK);
                    ticker.detach();
                } else if(getFireState() == 2) {
                    begin = timer.read_ms();
                    etat = 2;
                    ticker.detach();
                    setColor(RED);
                }
                break;
        }
        wait(0.1);
        lcd.cls();
    }
}

void setColor(int rgb) // RGB
{
    LED_rouge =  !(0b100 & rgb);
    LED_verte =  !(0b010 & rgb);
    LED_bleue =  !(0b001 & rgb);
}

bool isElapsedTime(int time) // retourne vrai si x temps c'est écoulé, update begin time
{
    int t = timer.read_ms();
    if(t - begin >= 5000) {
        begin = t;
        return 1;
    } else
        return 0;
}

int getFireState()   // Retourne si front montant ou descendant ou rien.
{
    int etat_fire = fire.read();
    int etat = 0;
    if(!last_state &&  etat_fire) { // Front montant
        etat = 1;
    } else if(last_state && !etat_fire) { // Front descendant
        etat = 2;
    } else {
        etat = 0;
    }
    last_state = etat_fire;
    return etat;
}