#include "mbed.h"
#include "HIDScope.h"
#include "BiQuad.h"
#include "math.h"
#include "MODSERIAL.h"

//Define EMG input 
AnalogIn        emg0( A0 );
AnalogIn        emg1( A1 );
AnalogIn        emg2( A2 );
MODSERIAL pc    (USBTX, USBRX);
InterruptIn     knopje1 (SW2);

Ticker          sample_timer;
HIDScope        scope( 3 );     // 3-channel HIDScope object

double signaal;
double maximum;
double Spier1Max;
double Spier2Max;
double Spier3Max;

// Filter coordinates of lowpass/highpass filter before rectifier and lowpassfilter for the envelope
const double b0_low = 0.2929, b1_low = 0.5858, b2_low = 0.2929, a1_low = 0, a2_low = 0.1716;
const double b0_high = 0.9978, b1_high = -1.9956, b2_high = 0.9978, a1_high = -1.9956, a2_high = 0.9956;
const double b0_envelope = 2.2059E-5, b1_envelope = 4.4119E-4, b2_envelope = 2.2059E-5, a1_envelope = -1.9867, a2_envelope = 0.9868;

double Spier1, Spier2, Spier3;          // Gefilterde output

// Biquad filters (lowpass and highpass become a chain in the int main)
BiQuad lowpass1(b0_low, b1_low , b2_low, a1_low, a2_low);
BiQuad lowpass2(b0_low, b1_low , b2_low, a1_low, a2_low);
BiQuad lowpass3(b0_low, b1_low , b2_low, a1_low, a2_low);
BiQuad highpass1(b0_high, b1_high , b2_high, a1_high, a2_high);
BiQuad highpass2(b0_high, b1_high , b2_high, a1_high, a2_high);
BiQuad highpass3(b0_high, b1_high , b2_high, a1_high, a2_high);
BiQuad envelope1(b0_envelope, b1_envelope , b2_envelope, a1_envelope, a2_envelope);
BiQuad envelope2(b0_envelope, b1_envelope , b2_envelope, a1_envelope, a2_envelope);
BiQuad envelope3(b0_envelope, b1_envelope , b2_envelope, a1_envelope, a2_envelope);
BiQuadChain bandpass1;
BiQuadChain bandpass2;
BiQuadChain bandpass3;

// Sample function, this function samples the emg and sends it to HIDScope
void filtering()
{
   Spier1 = bandpass1.step(emg0);
   Spier2 = bandpass2.step(emg1);
   Spier3 = bandpass3.step(emg2);
   Spier1 = fabs(Spier1);
   Spier2 = fabs(Spier2);
   Spier3 = fabs(Spier3);
   Spier1 = envelope1.step(Spier1); 
   Spier2 = envelope2.step(Spier2); 
   Spier3 = envelope3.step(Spier3); 
    
    // Set the sampled and filtered emg values in channel 0/1/2 in the 'HIDScope' instance named 'scope' 
    scope.set(0, Spier1 );
    scope.set(1, Spier2 );
    scope.set(2, Spier3 );
    
    scope.send();                               // Sends all channels to the PC at once
}

float GetMaximum1()
{
    maximum = Spier1;
    for(int i = 0; i<250000;i++)
    {
        signaal = Spier1;
        if(signaal>maximum)
        {
            maximum = signaal;
        }
        else
        {
            maximum = maximum;  
        }            
    }
    return maximum;    
}

float GetMaximum2()
{
    maximum = Spier2;
    for(int i = 0; i<250000;i++)
    {
        signaal = Spier2;
        if(signaal>maximum)
        {
            maximum = signaal;
        }
        else
        {
            maximum = maximum;  
        }            
    }
    return maximum;    
}

float GetMaximum3()
{
    maximum = Spier3;
    for(int i = 0; i<250000;i++)
    {
        signaal = Spier3;
        if(signaal>maximum)
        {
            maximum = signaal;
        }
        else
        {
            maximum = maximum;  
        }            
    }
    return maximum;    
}

void StartMeting()
{
    pc.printf("Span de eerste spier aan\n\r");
    wait(5);
        
    Spier1Max = GetMaximum1();
    pc.printf("Spier1Max = %f\n\r",Spier1Max);
    pc.printf("Span de tweede spier aan\n\r");
    wait(5);
    
    Spier2Max = GetMaximum2();
    pc.printf("Spier2Max = %f\n\r",Spier2Max);
    pc.printf("Span de derde spier aan\n\r");
    wait(5);
    
    Spier3Max = GetMaximum3();
    pc.printf("Spier2Max = %f\n\r",Spier2Max);
    pc.printf("Span de derde spier aan\n\r");
    wait(5);
}    

int main()
{   
    bandpass1.add(&lowpass1).add(&highpass1);
    bandpass2.add(&lowpass2).add(&highpass2);
    bandpass3.add(&lowpass3).add(&highpass3);
    sample_timer.attach(&filtering, 0.001);     // Attach the 'sample' function to the timer 'sample_timer'. This ensures that 'sample' is executed every 0.001 seconds = 1000 Hz
    
    pc.baud(115200);
    pc.printf("START\n\r");
    StartMeting();
    pc.printf("Spiermax1 = %f\n\rSpiermax2 = %f\n\rSpier3max = %f\n\r\n\n",Spier1Max,Spier2Max,Spier3Max);
    
    while(1) {}                                 // Empty loop, sample() is executed periodically
}