#include "mbed.h"
#include "HIDScope.h"
#include "BiQuad.h"

//Define EMG input 
AnalogIn    emg0( A0 );
AnalogIn    emg1( A1 );
AnalogIn    emg2( A2 );

Ticker      sample_timer;
HIDScope    scope( 3 );     // 3-channel HIDScope object

// Filter coordinates of lowpass/highpass filter before rectifier and lowpassfilter for the envelope
const double b0_low = 0.2929, b1_low = 0.5858, b2_low = 0.2929, a1_low = 0, a2_low = 0.1716;
const double b0_high = 0.9978, b1_high = -1.9956, b2_high = 0.9978, a1_high = -1.9956, a2_high = 0.9956;
const double b0_envelope = 2.2059E-5, b1_envelope = 4.4119E-4, b2_envelope = 2.2059E-5, a1_envelope = -1.9867, a2_envelope = 0.9868;

double y1, y2, y3;          // Gefilterde output

// Biquad filters (lowpass and highpass become a chain in the int main)
BiQuad lowpass1(b0_low, b1_low , b2_low, a1_low, a2_low);
BiQuad lowpass2(b0_low, b1_low , b2_low, a1_low, a2_low);
BiQuad lowpass3(b0_low, b1_low , b2_low, a1_low, a2_low);
BiQuad highpass1(b0_high, b1_high , b2_high, a1_high, a2_high);
BiQuad highpass2(b0_high, b1_high , b2_high, a1_high, a2_high);
BiQuad highpass3(b0_high, b1_high , b2_high, a1_high, a2_high);
BiQuad envelope1(b0_envelope, b1_envelope , b2_envelope, a1_envelope, a2_envelope);
BiQuad envelope2(b0_envelope, b1_envelope , b2_envelope, a1_envelope, a2_envelope);
BiQuad envelope3(b0_envelope, b1_envelope , b2_envelope, a1_envelope, a2_envelope);
BiQuadChain bandpass1;
BiQuadChain bandpass2;
BiQuadChain bandpass3;

// Sample function, this function samples the emg and sends it to HIDScope
void filtering()
{
   y1 = bandpass1.step(emg0);
   y2 = bandpass2.step(emg1);
   y3 = bandpass3.step(emg2);
   y1 = fabs(y1);
   y2 = fabs(y2);
   y3 = fabs(y3);
   y1 = envelope1.step(y1); 
   y2 = envelope2.step(y2); 
   y3 = envelope3.step(y3); 
    
    // Set the sampled and filtered emg values in channel 0/1/2 in the 'HIDScope' instance named 'scope' 
    scope.set(0, y1 );
    scope.set(1, y2 );
    scope.set(2, y3 );
    
    scope.send();                           // Sends all channels to the PC at once
}

int main()
{   
    bandpass1.add(&lowpass1).add(&highpass1);
    bandpass2.add(&lowpass2).add(&highpass2);
    bandpass3.add(&lowpass3).add(&highpass3);
    sample_timer.attach(&filtering, 0.001);    // Attach the 'sample' function to the timer 'sample_timer'. This ensures that 'sample' is executed every 0.001 seconds = 1000 Hz
    
    while(1) {}                             // Empty loop, sample() is executed periodically
}