#include "mbed.h"
#include "FastPWM.h"
#include "MODSERIAL.h"

FastPWM motor1_pwm(D5);
DigitalOut motor1_richting(D4);
FastPWM motor2_pwm(D6);
DigitalOut motor2_richting(D7);

AnalogIn pot1(A1);
AnalogIn pot2(A0);
MODSERIAL pc(USBTX, USBRX);



int main()
{
    int frequency_pwm = 16700; //16.7 kHz PWM
        
       
    motor1_pwm.period(1.0/frequency_pwm); // T = 1/f
    
    while(true){
        
        pc.baud(115200);
        
        float AnalogVoltage1 = pot1.read()*2 - 1;
        float AnalogVoltage2 = pot2.read()*2 - 1;
        pc.printf("pot1 = %f \t pot2 = %f \r\n", AnalogVoltage1, AnalogVoltage2);
        
        //Motor1
        
        if (AnalogVoltage1 <= 0) {
            motor1_richting = 0;
            motor1_pwm.write(-AnalogVoltage1); //write Duty cycle 
            }
        if (AnalogVoltage1 >= 0) {
            motor1_richting = 1;
            motor1_pwm.write(AnalogVoltage1); //write Duty cycle 
            }
            
        //Motor 2
            
        if (AnalogVoltage2 <= 0) {
            motor2_richting = 0;
            motor2_pwm.write(-AnalogVoltage2); //write Duty cycle 
            }
        if (AnalogVoltage2 >= 0) {
            motor2_richting = 1;
            motor2_pwm.write(AnalogVoltage2); //write Duty cycle 
            }
            
                    
             
        }
}