#include "mbed.h"
#include "HIDScope.h"
#include "arm_math.h"
#include "MODSERIAL.h"
#include "TextLCD.h"

#define EMG_treshhold 0,05

//MODSERIAL pc(USBTX,USBRX);
AnalogIn    emg(PTB1); //Analog input
HIDScope scope(2); // Twee kanalen op de HIDScope
DigitalIn knop(PTD4); /*Digital input pin (knop) definieren*/
TextLCD lcd(PTD2, PTA12, PTB2, PTB3, PTC2, PTA13, TextLCD::LCD16x2);

arm_biquad_casd_df1_inst_f32 lowpass_1; //2e orde lowpass biquad butterworthfilter 99Hz
arm_biquad_casd_df1_inst_f32 lowpass_2; //2e orde lowpass biquad butterworthfilter 3Hz
arm_biquad_casd_df1_inst_f32 highpass; //2e orde highpass biquad butterworthfilter 20Hz
arm_biquad_casd_df1_inst_f32 notch; //2e orde lowpass biquad butterworthfilter 50Hz
float lowpass_1_const[] = {0.978030479206560 , 1.956060958413119 , 0.978030479206560 , -1.955578240315036 , -0.956543676511203};
float lowpass_1_states[4];
float lowpass_2_const[] = {0.002080567135492 , 0.004161134270985 , 0.002080567135492 , 1.866892279711715 , -0.875214548253684}; //3Hz
    //{0.0009446914586925257 , 0.0018893829173850514 , 0.0009446914586925257 , 1.911196288237583 , -0.914975054072353};//2Hz
    //{0.00024135899874854145 , 0.0004827179974970829 , 0.00024135899874854145 , 1.9555778328194147 , -0.9565432688144089}; 1Hz
float lowpass_2_states[4];
float highpass_const[] = {0.638945525159022 , -1.277891050318045 ,  0.638945525159022 , 1.142980502539901 , -0.412801598096189};
float highpass_states[4];
float notch_const[] = {0.978048948305681 , 0.000000000000000 , 0.978048948305681 , 0.000000000000000 , -0.956097896611362};
float notch_states[4];
float filtered_emg;
float EMG_max=0.15;
float EMG_treshhold_laag = 0.3*EMG_max;
float EMG_treshhold_hoog = 0.7*EMG_max;

bool aanspan;
int aantal_pieken;
int doel;

void looper();
void pieken_tellen();
void EMG_max_meting();
//char *lcd_r1 = new char[16];
//char *lcd_r2 = new char[16];

void looper()
{
    uint16_t emg_value;
    float emg_value_f32;
    emg_value = emg.read_u16(); // read direct ADC result, converted to 16 bit integer (0..2^16 = 0..65536 = 0..3.3V)
    emg_value_f32 = emg.read();
    
    arm_biquad_cascade_df1_f32(&highpass, &emg_value_f32, &filtered_emg, 1 );
    arm_biquad_cascade_df1_f32(&lowpass_1, &filtered_emg, &filtered_emg, 1 );
    arm_biquad_cascade_df1_f32(&notch, &filtered_emg, &filtered_emg, 1);
    filtered_emg = fabs(filtered_emg);
    //emg_value_f32 = fabs(emg_value_f32);
    arm_biquad_cascade_df1_f32(&lowpass_2, &filtered_emg, &filtered_emg, 1 );
    
    //EMG_max_meting();
    pieken_tellen();  
    doel = aantal_pieken-((aantal_pieken/3)*3)+1;
    
    scope.set(0,emg_value);     //uint value
    scope.set(1,filtered_emg);  //processed float
    scope.send();
}

void EMG_max_meting()
{
    //int i=0; // tijdspad
    //lcd.cls();
    //lcd.printf("Maximale\nEMGmeting");
    //for(i=0; i<300; i++)
    //{
    //    wait(0.1);
        if (filtered_emg>=EMG_max)
        {
            EMG_max=filtered_emg;
        }
    //}
    //lcd.cls();
    //lcd.printf("Maximale EMG\nbepaald");
    //wait(3);
    EMG_treshhold_laag = 0.3*EMG_max;
    EMG_treshhold_hoog = 0.7*EMG_max;
}

void pieken_tellen()
{
    if (filtered_emg>=EMG_treshhold_hoog) 
    {
        aanspan=true; //maak een variabele waarin je opslaat dat het signaal hoog is.
    }
    if (aanspan==true && filtered_emg<=EMG_treshhold_laag)//== ipv =, anders wordt aanspan true gemaakt
    {
        aanspan=false;
        aantal_pieken++;
    }
}

int main()
{
    Ticker log_timer;
    
    arm_biquad_cascade_df1_init_f32(&lowpass_1,1 , lowpass_1_const, lowpass_1_states);
    arm_biquad_cascade_df1_init_f32(&highpass,1 , highpass_const, highpass_states);
    arm_biquad_cascade_df1_init_f32(&notch,1 , notch_const, notch_states);
    arm_biquad_cascade_df1_init_f32(&lowpass_2,1 , lowpass_2_const, lowpass_2_states);
    
    log_timer.attach(looper, 0.005);
    
    while(1) //Loop
    {
        lcd.cls();
        lcd.printf("Te raken doel =\n%d", doel);
        wait(0.02);
      /*Empty!*/
      /*Everything is handled by the interrupt routine now!*/
      //pc.baud(9600);
    }
}