#include "mbed.h"
#include <Pulse1.h>

PulseInOut irda(PTD5);
Serial pc(USBTX, USBRX);
DigitalOut l0(LED1);
DigitalOut l1(LED2);
DigitalOut l2(LED3);

int header =0;
const int head_H = 2964; //+20% medida con osciloscopio en microsegundos
const int head_L = 1976;//-20%  medida con osciloscopio
int i=0;
const int T_alto=1200;//ponga su tiempo de la prueba
const int T_bajo=600;//ponga su tiempo de la prueba
const int num_bits = 21;//ponga su numero de bits
int num[num_bits];//cadena para almacenar todos los tiempos que conforman los bits de datos
int dato; // tiempo de cada dato que se lee
  
int main(){
    l0=l1=l2=1;
    while(1){
        ini1: header=0;
        l1=l0=l2=1;
        header = irda.read_low_us();    //funcion para leer un pulso de caida o bajo
        if (header > head_L && header < head_H) goto seguir;//verificar que este en la tolerancia +-20%
        else goto ini1;
      
        seguir:
        wait_us(300);
        l0=0;
        l1=0;
        l2=0;
        
        for(i=0;i<(num_bits-1);++i){ // POR OSCILOSCOPIO se determina que llegan (num_bits),datos
            dato = irda.read_low_us(); //leer un bit de datos que es pulso arriba en este control
            num[i]=dato;
            wait_us(300);   
        }
        
        wait(0.5); //espero un poquito antes de leer todo el arreglo y ponerlo en pantalla 
        pc.printf(",%d",header);
        
        for(i=0;i<(num_bits-1);++i){  
            pc.printf(",%d",num[i]);
        }
        
        wait(0.1);  //espero e imprimo en binario 
        pc.printf("\n\n");
        for(i=0;i<(num_bits-1);++i){  
            if(num[i] > ((T_alto+T_bajo)/2)) pc.printf("1");
            else pc.printf("0");
        }
      }
}