#include "mbed.h"
#include "max32630fthr.h"
#include "USBMSD_BD.h"
#include "SDBlockDevice.h"
#include "HeapBlockDevice.h"
#include "FATFileSystem.h"

#include "StringInOut.h"
#include "Streaming.h"
#include "Peripherals.h"
#include "MAX30001.h"
#include "RpcServer.h"
#include "DataLoggingService.h"

#include "Test_MAX30001.h"
#include "Test_Utilities.h"

#define BLOCK_SIZE   512


MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);

DigitalOut rLED(LED1);
DigitalOut gLED(LED2);
DigitalOut bLED(LED3);

DigitalOut outLED(P3_4);
DigitalIn Button(P3_5);

// Physical block device, can be any device that supports the BlockDevice API
// HeapBlockDevice bd(512*BLOCK_SIZE, BLOCK_SIZE);
//SDBlockDevice bd(P0_5, P0_6, P0_4, P0_7);

// File system declaration
//FATFileSystem fs("fs");

//Another define the FAT File system and SD Card
SDBlockDevice sd(P0_5, P0_6, P0_4, P0_7);
FATFileSystem fs("sd", &sd);



// USB MSD 
//USBMSD_BD msd(&bd);  


/// DigitalOut for CS
DigitalOut cs(P5_6);
/// SPI Master 2 with SPI0_SS for use with MAX30001
SPI spi(SPI2_MOSI, SPI2_MISO, SPI2_SCK); // used by MAX30001

/// ECG device
MAX30001 max30001(&spi, &cs);
InterruptIn max30001_InterruptB(P5_5);
InterruptIn max30001_Interrupt2B(P5_4);

// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)

uint32_t    ECG_Data[5120];
uint32_t    BIOZ_Data[1280];
uint32_t    PACE_Data[1280];
uint32_t    RTOR_Data[1280];

uint32_t    ECG_Data_Size = 0;
uint32_t    BIOZ_Data_Size = 0;
uint32_t    PACE_Data_Size = 0;
uint32_t    RTOR_Data_Size = 0;

uint32_t    global_key_judge = 0;
int         current_log_number = 0;
char        BIOZ_file_name[20] = "/sd/BIOZ";
int         event_tag = 0;


int main()
{
    uint32_t     i, id;
    uint32_t    reg;
    int partVersion; // 0 = 30004
    
    int totalPass = 1;
    int pass;
    uint32_t foundEcg = 0;
    uint32_t foundBioz = 0;
    uint32_t foundPace = 0;
    uint32_t foundRtoR = 0;
    
    // local input state of the RPC
    int inputState;
    // RPC request buffer
    char request[128];
    // RPC reply buffer
    char reply[128];
    int  err;
    
    //int32_t i;
    printf("SD Card Example\n");
    gLED = LED_ON;
    rLED = LED_ON;

    FILE *fp = fopen("/sd/myfile12345678.txt", "a");
    for(i=0 ; i< 3000 ;  i++)
        fprintf(fp, "%s %d %s","Hello World!!!!", i, "\n");
    fclose(fp);

    rLED = LED_OFF;
    printf("SD Card Writing Over\n");
    
    // Open the index file
    printf("Opening \"/sd/index.txt\"... ");
    fflush(stdout);
    FILE *f_index = fopen("/sd/index.txt", "r+");
    //FILE *f_index;
    printf("%s\n", (!f_index ? "Fail :(" : "OK"));
    int index_number;

    if(!f_index)
    {
        printf("No index file found, creating a new index file...\n");
        fflush(stdout);
        f_index = fopen("/sd/index.txt", "w+");
        printf("Creat index file %s\n", (!f_index ? "Fail :(" : "OK"));
        index_number = current_log_number;
        fprintf(f_index, "%d", index_number);
        
        fclose(f_index);
    }
    
    int index_number2 = 0;
    printf("Index file found...\n");
    fflush(stdout);
    f_index = fopen("/sd/index.txt", "r+");
    
    printf("Open index.txt \n");
    printf("Openning %s\n", (!f_index ? "Fail :(" : "OK"));
        
    //Get current stream position
    long pos = ftell(f_index);
        
    // rewind(f_index);

    err = fscanf(f_index, "%d", &index_number2);
    printf("Scanning %s\n", (err < 0 ? "Fail :(" : "OK"));
    printf("err = %d\n", err);
        
    //index_number2 = fgetc(f_index);
    printf("index_number1 = %d \n", index_number2);
    index_number2 += 1;
        
    fseek(f_index, pos, SEEK_SET);
    printf("index_number2 = %d \n", index_number2);
    err = fprintf(f_index, "%d\n", index_number2);
    printf("Saving %s\n", (err < 0 ? "Fail :(" : "OK"));
        
    fflush(stdout);
    err = fclose(f_index);       
    printf("Closing %s\n", (err < 0 ? "Fail :(" : "OK"));
    current_log_number = index_number2;
    
    int j = 0;
    /*
    while (true) {
        gLED = !gLED;
        fp = fopen("/sd/myfile222.txt", "a");
        for(i=0 ; i< 300 ;  i++)
            fprintf(fp, "%s %d %d %s","Hello World!!!!", j, i, "\n");
        fclose(fp);
        j++;
        printf("write j %d\n", j);
        // ThisThread::sleep_for(500ms);
    }
    */

    printf("--- Mbed OS filesystem example 1 ---\n");
    rLED = LED_ON;
    gLED = LED_OFF;
    bLED = LED_OFF;
    
    // set NVIC priorities for GPIO to prevent priority inversion
    printf("Init NVIC Priorities...\n");
    fflush(stdout);
    NVIC_SetPriority(GPIO_P0_IRQn, 5);
    NVIC_SetPriority(GPIO_P1_IRQn, 5);
    NVIC_SetPriority(GPIO_P2_IRQn, 5);
    NVIC_SetPriority(GPIO_P3_IRQn, 5);
    NVIC_SetPriority(GPIO_P4_IRQn, 5);
    NVIC_SetPriority(GPIO_P5_IRQn, 5);
    NVIC_SetPriority(GPIO_P6_IRQn, 5);

    printf("Init MAX30001 callbacks, interrupts...\n");
    fflush(stdout);
    max30001_InterruptB.disable_irq();
    max30001_Interrupt2B.disable_irq();
    max30001_InterruptB.mode(PullUp);
    max30001_InterruptB.fall(&MAX30001Mid_IntB_Handler);
    max30001_Interrupt2B.mode(PullUp);
    max30001_Interrupt2B.fall(&MAX30001Mid_Int2B_Handler);
    max30001_InterruptB.enable_irq();
    max30001_Interrupt2B.enable_irq();
    MAX30001_AllowInterrupts(1);
    max30001.max30001_sw_rst(); // Do a software reset of the MAX30001

    PushButton pushButton(SW1);
    Timer timer;
    
    max30001.max30001_INT_assignment(MAX30001::MAX30001_INT_B,    MAX30001::MAX30001_NO_INT,   MAX30001::MAX30001_NO_INT,  //  en_enint_loc,      en_eovf_loc,   en_fstint_loc,
                                    MAX30001::MAX30001_INT_2B,   MAX30001::MAX30001_INT_2B,   MAX30001::MAX30001_NO_INT,  //  en_dcloffint_loc,  en_bint_loc,   en_bovf_loc,
                                    MAX30001::MAX30001_INT_2B,   MAX30001::MAX30001_INT_2B,   MAX30001::MAX30001_NO_INT,  //  en_bover_loc,      en_bundr_loc,  en_bcgmon_loc,
                                    MAX30001::MAX30001_INT_B,    MAX30001::MAX30001_NO_INT,   MAX30001::MAX30001_NO_INT,  //  en_pint_loc,       en_povf_loc,   en_pedge_loc,
                                    MAX30001::MAX30001_INT_2B,   MAX30001::MAX30001_INT_B,    MAX30001::MAX30001_NO_INT,  //  en_lonint_loc,     en_rrint_loc,  en_samp_loc,
                                    MAX30001::MAX30001_INT_ODNR, MAX30001::MAX30001_INT_ODNR);                            //  intb_Type,         int2b_Type)
    
    max30001.onDataAvailable(&StreamPacketUint32);

    Thread::wait(100);
    Peripherals::setMAX30001(&max30001);

    max30001.max30001_reg_read(max30001.INFO, &id);
    // read id twice because it needs to be read twice
    max30001.max30001_reg_read(max30001.INFO, &id);
    printf("INFO_01 = %x \n", id);
    
    partVersion = id >> 12;
    partVersion = partVersion & 0x3;
    
    partVersion = 1;
    // display header
    if (partVersion == 0)
        printf("Testing MAX30004|\n");
    if (partVersion == 1) {
        printf("Testing MAX30001|\n");
        printf("Testing ECG, RtoR, BioZ, PACE|\n");
    }
    
    // initialize the RPC server
    printf("Init RPC Server...\n");
    fflush(stdout);
    RPC_init();
    // initialize the logging service
    printf("Init LoggingService...\n");
    fflush(stdout);
    
    // start main loop
    printf("Start main loop...\n");
    fflush(stdout);
    
    printf("partVersion = %d \n", partVersion);
    // clear testing flags
    testing_ecg_flags[TESTING_ECG_FLAG] = 0;
    testing_ecg_flags[TESTING_BIOZ_FLAG] = 0;
    testing_ecg_flags[TESTING_PACE_FLAG] = 0;
    testing_ecg_flags[TESTING_RTOR_FLAG] = 0;
    
    // start streams
    // testing_max30001 = 1;
    if (partVersion == 1)
    printf("Start Streaming ECG, RtoR, PACE, BIOZ, CAL enabled, "
                 "verifying streams...|\n");

    if (partVersion == 3)
        printf(
        "Start Streaming ECG, RtoR, CAL enabled, verifying streams...|\n");
    // max30001_CAL_InitStart(0b1, 0b1, 0b1, 0b011, 0x7FF, 0b0);
    // max30001.max30001_CAL_InitStart(0b1, 0b1, 0b1, 0b011, 0x7FF, 0b0);
    // max30001.max30001_reg_read(max30001.CNFG_CAL, &reg);
    // printf("CNFG_CAL = %x \n", reg);
    
    //max30001.max30001_ECG_InitStart(0b1, 0b1, 0b1, 0b0, 0b10, 0b11, 0x1F, 0b00,
    //                               0b00, 0b0, 0b01);
    //max30001.max30001_reg_read(max30001.CNFG_GEN, &reg);
    //printf("CNFG_GEN_1 = %x \n", reg);
    
    //if (partVersion == 1)
    //    max30001.max30001_PACE_InitStart(0b1, 0b0, 0b0, 0b1, 0x0, 0b0, 0b00, 0b0,
    //                                  0b0);
    //max30001.max30001_reg_read(max30001.CNFG_GEN, &reg);
    //printf("CNFG_GEN_2 = %x \n", reg);

    if (partVersion == 1)
        max30001.max30001_BIOZ_InitStart(0b1, 0b0, 0b0, 0b00, 
                                        0b00, 0b00, 7, 0b0,
                                        0b010, 0b0, 0b11, 0b00, 0b00, 
                                        2, 0b0, 0b011, 0b0000, 0b0000);
    /*
    int MAX30001::max30001_BIOZ_InitStart(
    uint8_t En_bioz, uint8_t Openp, uint8_t Openn, uint8_t Calp_sel,
    uint8_t Caln_sel, uint8_t CG_mode, uint8_t B_fit, uint8_t Rate,
    uint8_t Ahpf, uint8_t Ext_rbias, uint8_t Gain, uint8_t Dhpf, uint8_t Dlpf,
    uint8_t Fcgen, uint8_t Cgmon, uint8_t Cgmag, uint8_t Phoff, uint8_t Inapow_mode) {
    ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++    
    En_bioz: CNFG_GEN D[18], 1; 0 = Bioz disable, 1 = Bioz enable;
    Openp: CNFG_BMUX D[21], 0; 0 = BIP is internally connected to BioZ channel, 1 = BIP is isolate from Bioz Channel
    Openn: CNFG_BMUX D[20], 0; 0 = BIN is internally connected to BioZ channel, 1 = BIN is isolate from Bioz Channel
    Calp_sel: CNFG_BMUX D[19:18]: 00; 00 = No calibration signal applied; 01 = input connected to VMID, 10 = connected to VCALP, 11= VCALN
    ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++        
    Caln_sel: CNFG_BMUX D[17:16]: 00; 00 = No calibration signal applied; 01 = input connected to VMID, 10 = connected to VCALP, 11= VCALN
    CG_mode: CNFG_BMUX D[13:12]: 00; 00 = Unchopped sources with low pass filter
    B_fit: MNGR_INT D[18:16]: 0x111; 000 to 111 = 1 to 8 Bioz FIFO interrupt Threshold
    Rate: CNFG_BioZ D[23]: 0; BioZ Data Rate; when FMSTR = 00, 0=64sps, 1=32; FMSTR=01, 0=62.5, 1=31.25; FMSTR=10, 0=50,1=25; FMSTR=11, 0=49.95, 1=24.98
    ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++        
    Ahpf: CNFG_BioZ D[22:20]: BioZ/PACE Channel Analog High-Pass Filter Cutoff Frequency and Bypass
                                0b010; 000=125Hz, 001=300, 010=800, 011=2000, 100=3700, 101=7200 11x=Bypass AHPF
    Ext_rbias: CNFG_BioZ D[19]: 0; 0 = Internal Bias Generator used; 1 = External Bias Generator used;
    Gain: CNFG_BioZ D[17:16]:00; BioZ Channel Gain Setting, 00=10V/V; 01=20V/V; 10=40V/V; 11=80V/V
    Dhpf: CNFG_BioZ D[15:14]:00; BioZ Channel Digital High-Pass Filter Cutoff Frequency 00=Bypass(DC); 01=0.05Hz; 1x=0.50Hz
    Dlpf: CNFG_BioZ D[13:12]:00; BioZ Channel Digital Low-Pass Filter Cutoff Frequency: 00=Bypass, 01=4Hz, 10=8Hz, 11=16Hz
    ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++        
    Fcgen: CNFG_BioZ D[11:8]:2; BioZ Current Generator Modulation Frequency: 0000=4*fMSTR, 0001=2*fMSTR, 0010=fMSTR(40000Hz)
    Cgmon: CNFG_BioZ D[7]:0; BioZ Current Generator Monitor： 0 = Current Generator Monistor disable; 1 = enable
    Cgmag: CNFG_BioZ D[6:4]:0b001; BioZ Current Generator Magnitude: 
                            000=Off, 001 = 8uA, 010=16uA, 011=32uA, 100=48uA, 101=64uA; 110=80uA, 111=96uA
    Phoff: CNFG_BioZ D[3:0]:0000; BioZ Current Generator Modulation Phase Offset: 
                            BIOZ_FCGEN[3:0] = 0000: Phase Offset = BIOZ_PHOFF[3:2]*45.00° (0 to 135.00)
    Inapow_mode: CNFG_BioZ D[18]:0; BioZ Channel Instrumentation Amplifier (INA) Power Mode, 0=BioZ INA is in low power mode, 1=in low noise mode
    */

    max30001.max30001_reg_read(max30001.CNFG_GEN, &reg);
    printf("CNFG_GEN = %x \n", reg);   
    
    //max30001.max30001_RtoR_InitStart(0b1, 0b0011, 0b1111, 0b00, 0b0011, 0b000001,
    //                                    0b00, 0b000, 0b01);
    //max30001.max30001_reg_read(max30001.CNFG_GEN, &reg);
    printf("CNFG_GEN_4 = %x \n", reg);
    
    
    max30001.max30001_Rbias_FMSTR_Init(0b01, 0b10, 0b1, 0b1, 0b00);
    
    max30001.max30001_reg_read(max30001.CNFG_ECG, &reg);
    printf("CNFG_ECG = %x \n", reg);
    max30001.max30001_reg_read(max30001.CNFG_GEN, &reg);
    printf("CNFG_GEN_5 = %x \n", reg);
    max30001.max30001_reg_read(max30001.MNGR_INT, &reg);
    printf("MNGR_INT = %x \n", reg);
    max30001.max30001_reg_read(max30001.CNFG_EMUX, &reg);
    printf("CNFG_EMUX = %x \n", reg);
    max30001.max30001_reg_read(max30001.CNFG_BIOZ, &reg);
    printf("CNFG_BIOZ = %x \n", reg);    
    
    max30001.max30001_synch();
    
    timer.start();

    wait_us(20);
    
    timer.stop();
    
    rLED = LED_OFF;
    bLED = LED_OFF;
    gLED = LED_OFF;
    
    sprintf(BIOZ_file_name, "%s_%d", BIOZ_file_name, current_log_number);
    strcat(BIOZ_file_name, ".txt");
    printf("%s\n", BIOZ_file_name);
    
    while (true) {
        //wait_ms(50);
        //printf("%% \n");        
        rLED = LED_OFF;
        gLED = LED_ON;
        
        if ( Button == 0 )
            event_tag = 1;
        else
            event_tag = 0;
        
        //printf("ECG_Data_Size = %d \n", ECG_Data_Size);
        fp = fopen("/sd/ECG.txt", "a");
        // fp = fopen(ECG_file_name, "a");
        if( ECG_Data_Size > 60 )
        {
            
            for(i=0 ; i<ECG_Data_Size ; i++)
            {
                fprintf(fp, "%d %d %x %s",ECG_Data_Size, i, ECG_Data[i], "\n");

                // printf("%s %x %s","ECG", ECG_Data[i], "\n");
            }
            ECG_Data_Size = 0;
            // printf("Save ECG \n");
            rLED = !rLED;

        }
        fclose(fp);

        fp = fopen(BIOZ_file_name, "a");
        // fp = fopen("/sd/BIOZ.txt", "a");
        if( BIOZ_Data_Size > 30 )
        {
            for(i=0 ; i<BIOZ_Data_Size ; i++)
            {
                fprintf(fp, "%d %d %x %d %s",BIOZ_Data_Size, i, BIOZ_Data[i], event_tag, "\n");

            }
            BIOZ_Data_Size = 0;
            printf("Save BIOZ \n");
            rLED = !rLED;
            outLED = !outLED;
        }
        fclose(fp);

    }
}

