/*******************************************************************************
 * Copyright (C) 2016 Maxim Integrated Products, Inc., All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Maxim Integrated
 * Products, Inc. shall not be used except as stated in the Maxim Integrated
 * Products, Inc. Branding Policy.
 *
 * The mere transfer of this software does not imply any licenses
 * of trade secrets, proprietary technology, copyrights, patents,
 * trademarks, maskwork rights, or any other form of intellectual
 * property whatsoever. Maxim Integrated Products, Inc. retains all
 * ownership rights.
 *******************************************************************************
 */

#include "PushButton.h"
#include "Peripherals.h"

extern MAX30001 max30001;
extern uint32_t global_key_judge;
extern int current_log_number;

PushButton::PushButton(PinName pin) : interruptButton(pin) {
  this->pin = pin;

  interruptButton.mode(PullUp);
  debouncingState = false;
  // Delay for initial pullup to take effect
  wait(0.01f);
  // Attach the address of the interrupt handler routine for pushbutton
  interruptButton.fall(callback(this, &PushButton::pb_hit_interrupt_fall));
}

bool PushButton::GetButtonFallState(void) { 
 return buttonFallState; 
}

void PushButton::SetButtonFallState(bool state) { 
 buttonFallState = state; 
}

void PushButton::clearButtonFallState(void) { 
 buttonFallState = false; 
}

int PushButton::Read(void) { 
 return interruptButton.read(); 
}

void PushButton::pb_hit_interrupt_fall(void) {
    /* switch debouncing */
    if (!debouncingState)
    {
        timeout.attach(callback(this, &PushButton::pb_debounce_timeout), debounceTime);
    }
    
    if ( global_key_judge&0x01 == 1 )
    {
        max30001.max30001_BIOZ_InitStart(0b1, 0b0, 0b0, 0b00, 
                                        0b00, 0b00, 7, 0b0,
                                        0b010, 0b0, 0b00, 0b00, 0b00, 
                                        2, 0b0, 0b011, 0b0000, 0b0000);
        max30001.max30001_synch();
        
        /*
        printf("global_key_judge = %d\n", global_key_judge);
        FILE *fp_index = fopen("/sd/index.txt", "r+");
        int index_number = 0;
        int err = fscanf(fp_index, "%d", &index_number);
        printf("Scan err = %d\n", err);
        index_number += 1;
        err = fprintf(fp_index, "%d\n", index_number);
        printf("err = %d\n", err);
        printf("index_number = %d\n", index_number);
        printf("Start Sampling \n");
        printf("index_number = %d \n", index_number);
        fclose(fp_index);
        */
        printf("Save to Bioz_%d.txt", current_log_number);
        current_log_number += 1;
        wait_ms(200);
    }
    else
    {
        max30001.max30001_Stop_ECG();
        max30001.max30001_Stop_PACE();
        max30001.max30001_Stop_BIOZ();
        max30001.max30001_Stop_RtoR();
        printf("Stop Sampling \n");
        wait_ms(200);
    }
    
    global_key_judge += 1;

    
    //max30001.max30001_ECG_InitStart(0b1, 0b1, 0b1, 0b0, 0b10, 0b11, 0x1F, 0b00,
    //                               0b00, 0b0, 0b01);
}

void PushButton::pb_debounce_timeout(void) {
    if (!interruptButton.read())
    {
        if (Peripherals::pushButton() != NULL){
            Peripherals::pushButton()->SetButtonFallState(true);
        }
    }
    debouncingState = false;
}

