#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "ExperimentServer.h"
#include "HX711.h"

#define NUM_INPUTS 5
#define NUM_OUTPUTS 4

Serial pc(USBTX, USBRX);    // USB Serial Terminal
ExperimentServer server;    // Object that lets us communicate with MATLAB
Timer t;                    // Timer to measure elapsed time of experiment
AnalogIn pot(A0); // Linear Potentiometer
HX711 scale(A1, A2);
DigitalOut led(LED_BLUE); 
Ticker randloop;




// Timing parameters
float pwm_period_us;
float current_control_period_us;
float impedance_control_period_us;
float exp_period;
float calibration_factor;

void randomloop()
{
int random = rand()%100;
        if (random > 85) {
               led.write(0);
                }
        else {
                led.write(1);
                }

} // end randomloop
int main (void) {
    scale.tare(); // tare scale 
  
  // Link the terminal with our server and start it up
  server.attachTerminal(pc);
  server.init();
  // Continually get input from MATLAB and run experiments
  float input_params[NUM_INPUTS];
  while(1) {
    if (server.getParams(input_params,NUM_INPUTS)) {
      pwm_period_us               = input_params[0]; // PWM_Period in mirco seconds
      current_control_period_us   = input_params[1]; // Current control period in micro seconds
      impedance_control_period_us = input_params[2]; // Impedance control period in microseconds seconds
      exp_period                  = input_params[3]; // Experiment time in seconds 
      calibration_factor          = input_params[4]; // calibration factor for load cell

      randloop.attach_us(randomloop,current_control_period_us);
      pc.printf("This is working: %4f/n", pwm_period_us); 
      scale.setScale(calibration_factor); //Adjust to this calibration factor
      
    
      // Setup experiment
      t.reset();
      t.start();
     
      // Run experiment, keep this line
      while ( t.read() < exp_period ) { 
        // Perform control loop logic
        
        // take measurement from load cell
        float F = scale.getGram();//+ 0.116f*t.read();     // value from load cell that uses calibration factor
        float Length = pot.read()*105.0f;           // value from linear potentiometer * 1.05 calibration factor (105mm stroke length
        float light = led.read();        
       
                     
        // Form output to send to MATLAB     
        float output_data[NUM_OUTPUTS];
        output_data[0] = t.read();
        output_data[1] = Length;
        output_data[2] = F;  
        output_data[3] = light;
        //output_data[4] = current_des1;
        //output_data[5] = duty_factor1;
        //pc.printf("Output data",output_data); 
                          
        // Send data to MATLAB
        server.sendData(output_data,NUM_OUTPUTS);
        wait_us(impedance_control_period_us);   
      }     
      // Cleanup after experiment
      server.setExperimentComplete();
      // control.detach();
      randloop.detach();

    } // end if
    } // end while
} // end main