#include "mbed.h"

AnalogOut base(A3);
Serial pc(USBTX, USBRX,9600); 
// main() runs in its own thread in the OS
float min_loop_time = 1e6;
Timer t;
int main() {
    pc.printf("starting main program\r\n");
    while (1) {
        float delay_time = 2e6;
        t.start();
        while(delay_time > 1.0) {
            base = 1;
            wait_us(delay_time);
            base = 0;
            wait_us(delay_time);
            if(t.read_us() > min_loop_time) {
                delay_time = delay_time/2;
                t.reset();
                pc.printf("%.0f\r\n",delay_time);
            }
        }
    }
}

