#ifndef __MAX31725_H__
#define __MAX31725_H__

#include "mbed.h"

#define MAX31725_ADDR 0x92 //this is the 8-bit address
#define MAX31725_CONVERSION_TIME_MS 44

class MAX31725
{
    public:
        void writeRegister(uint8_t, uint8_t, uint8_t);
        void writeBlock(uint8_t, uint8_t, uint8_t *, uint8_t);
        void readRegisters(uint8_t, uint8_t, char *, int);
        uint16_t LSB_MSB_2uint16(char *);
        uint16_t MSB_LSB_2uint16(char *);
        void regDump(uint8_t, uint8_t, uint8_t);
        bool bitRead(uint16_t, uint8_t);   
        float getTemp(void); 
};
    

#endif