#include "MAX31725.h"
#include "mbed.h"


extern Serial pc;
extern I2C i2c;


void MAX31725::writeRegister(uint8_t addr, uint8_t reg, uint8_t val)
{
    /*writes 1 byte to a single register*/
    char writeData[2];
    writeData[0] = reg ;
    writeData[1] = val;
    i2c.write(addr,writeData, 2);
}

void MAX31725::writeBlock(uint8_t addr, uint8_t startReg, uint8_t *data, uint8_t numBytes)
{
    /*writes data from an array beginning at the startReg*/
    char writeData[numBytes+1];
    writeData[0]=startReg;
    for(int n=1; n<numBytes; n++) 
    {
        writeData[n]=data[n-1];
    }
    i2c.write(addr,writeData,numBytes+1);
}

void MAX31725::readRegisters(uint8_t addr, uint8_t startReg, char *regData, int numBytes)
{
    char writeData = startReg;
    i2c.write(addr,&writeData,1,true); //true is for repeated start
    i2c.read(addr,regData,numBytes);
}

uint16_t MAX31725::LSB_MSB_2uint16(char *data) 
{
/*returns an unsinged 16 bit integer from a 2 data bytes, where the second byte is the MSB*/
    return ((uint16_t)data[1] << 8) + (uint16_t)data[0];
}

uint16_t MAX31725::MSB_LSB_2uint16(char *data) 
{
/*returns an unsinged 16 bit integer from a 2 data bytes, where the second byte is the MSB*/
    return ((uint16_t)data[0] << 8) + (uint16_t)data[1];
}

void MAX31725::regDump(uint8_t Addr, uint8_t startByte, uint8_t endByte)
{
    /*print the values of up to 20 registers*/
    char regData[20];
    int numBytes;
    if (endByte>=startByte) 
    {
        numBytes =  (endByte-startByte+1) < 20 ? (endByte-startByte+1) : 20;
    } 
    else 
    {
        numBytes=1;
    }

    regData[0] = startByte;
    i2c.write(Addr,regData,1,true);
    i2c.read(Addr, regData, numBytes);
    for(int n=0; n<numBytes; n++) 
    {
        pc.printf("%X, %X \r\n", startByte+n, regData[n]);
    }
}


bool MAX31725::bitRead(uint16_t data, uint8_t bitNum)
{
    uint16_t mask = 1<<bitNum;
    uint16_t masked_bit = data & mask;
    return masked_bit >> bitNum;
}

float MAX31725::getTemp(void) 
{
    char tempData[2];
    uint16_t tempBits; 
    const float LSB =0.00390625;

  // read temperature
    readRegisters(MAX31725_ADDR,0x00,tempData,2);
    tempBits = MSB_LSB_2uint16(tempData);
    if(bitRead(tempBits,15) == 1 )
    {
        return( (32768-tempBits)*LSB ); //negative temp
    }
    else 
    {
        return ( tempBits*LSB ); //positive temp
    }
} 
