#include "MAX11410.h"
#include "mbed.h"

extern Serial pc;

//write functions
MAX11410::MAX11410(SPI *spi_itf, DigitalOut *cs_pin)
{
    spi = spi_itf;
    cs = cs_pin;
    *cs = 1;        // Assert CS high
    wait_us(5);
    //POR, wake it up, turn on buffer, etc.
};


void MAX11410::reset()
{
    write8bitReg(REG_PD, MODE_RESET);    
}


bool MAX11410::interrupt()
{

    *cs = 0;
    bool result = spi->write(_READ(0));
    *cs =1;
    return !result; //low = interrupt
}


void MAX11410::write8bitReg(char regAddr, char bits2write)
{

    *cs = 0;
    spi->write( _WRITE(regAddr) );
    spi->write( bits2write );
    *cs = 1;
}


void MAX11410::write24bitReg(char regAddr, uint32_t bits2write)
{

    char write_buffer[8];
    write_buffer[0] = _WRITE(regAddr) ;
    write_buffer[1] = (bits2write & 0x00FF0000) >> 16;
    write_buffer[2] = (bits2write & 0x00FF0000) >> 8;
    write_buffer[3] = (bits2write & 0x000000FF);
    *cs = 0;
    for (int n=0;n<4;n++)
    {
        spi->write(write_buffer[n]);
    }
    *cs = 1;
}

char MAX11410::read8bits(char regAddr, bool *int_status)
{
    //the interrupt status (INTB) is the MISO value during the register write, 0 = interrupt is assert
    *cs=0;
    *int_status = spi->write(_READ(regAddr));
    char data = spi->write(0x00);
    *cs=1;
    return data;
}


uint32_t MAX11410::read24bits(char regAddr, bool *int_status)
{
    //the interrupt status is the MISO value during the register write
    char read_buffer[3];
    *cs = 0;
    *int_status = spi->write(_READ(regAddr));
    for (int n=0;n<3;n++)
    {
        read_buffer[n]=spi->write(0x00);
    }
    *cs = 1;
    return (read_buffer[0]<<16) | (read_buffer[1] <<8) | read_buffer[2];
}

int32_t MAX11410::read24bitsSigned(char regAddr, bool *int_status)
{
    //the interrupt status is the MISO value during the register write
    char read_buffer[3];
    *cs = 0;
    *int_status = spi->write(_READ(regAddr));
    for (int n=0;n<3;n++)
    {
        read_buffer[n]=spi->write(0x00);
    }
    *cs = 1;
    int32_t signal = (read_buffer[0]<<16) | (read_buffer[1] <<8) | read_buffer[2];
    
    if( signal & 0x00800000 ) //is the MSB set-->then negative
    {
        signal |= 0xFF000000; //fill in the other MSBs
    }
    return signal;
}


void MAX11410::calOffset()
{
    
}


void MAX11410::calGain()
{
    
}


uint32_t MAX11410::readStatus(bool *int_status)
{
    return read24bits(REG_STATUS,int_status);
}
