#ifndef __MAX11410_H__
#define __MAX11410_H__

#include "mbed.h"

//#define DEBUG //if you want to print stuff

//HW definition


#define CONV_DELAY_MS  1

// SPI interface configuration
#define MAX11410_SPI_MODE 0

//8 bit registers
#define SPI_READ 1<<7
#define SPI_WRITE 0<<7
#define REG_PD 0x0
#define REG_CONV_START 0x01
#define REG_SEQ_START 0x02
#define REG_CAL_START 0x03
#define REG_GP0_CTRL 0x04
#define REG_GP1_CTRL 0x05
#define REG_GP_CONV 0x06
#define REG_GP_SEQ 0x07
#define REG_FILTER 0x08
#define REG_CTRL 0x09
#define REG_SOURCE 0x0A
#define REG_MUX_CTRL0 0x0B
#define REG_MUX_CTRL1 0x0C
#define REG_MUX_CTRL2 0x0D
#define REG_PGA 0x0E
#define REG_WAIT_EXT 0x0F
#define REG_WAIT_START 0x10

//24 big registers
#define REG_PART_ID 0x11
#define REG_SYSC_SEL 0x12
#define REG_SYS_OFF_A 0x13
#define REG_SYS_OFF_B 0x14
#define REG_SYS_GAIN_A 0x15
#define REG_SYS_GAIN_B 0x16
#define REG_SELF_OFF 0x17
#define REG_SELF_GAIN_1 0x18
#define REG_SELF_GAIN_2 0x19
#define REG_SELF_GAIN_4 0x1A
#define REG_SELF_GAIN_8 0x1B
#define REG_SELF_GAIN_16 0x1C
#define REG_SELF_GAIN_32 0x1D
#define REG_SELF_GAIN_64 0x1E
#define REG_SELF_GAIN_128 0x1F
#define REG_LTHRESH0 0x20
#define REG_LTHRESH1 0x21
#define REG_LTHRESH2 0x22
#define REG_LTHRESH3 0x23
#define REG_LTHRESH4 0x24
#define REG_LTHRESH5 0x25
#define REG_LTHRESH6 0x26
#define REG_LTHRESH7 0x27
#define REG_UTHRESH0 0x28
#define REG_UTHRESH1 0x29
#define REG_UTHRESH2 0x2A
#define REG_UTHRESH3 0x2B
#define REG_UTHRESH4 0x2C
#define REG_UTHRESH5 0x2D
#define REG_UTHRESH6 0x2E
#define REG_UTHRESH7 0x2F
#define REG_DATA0 0x30
#define REG_DATA1 0x31
#define REG_DATA2 0x32
#define REG_DATA3 0x33
#define REG_DATA4 0x34
#define REG_DATA5 0x35
#define REG_DATA6 0x36
#define REG_DATA7 0x37
#define REG_STATUS 0x38
#define REG_STATUS_IE 0x39

//16 bit registers for sequencer
#define REG_UC0 0x3A
#define REG_UCADDR 0x6F

// Read/Write
#define _WRITE(x)  (SPI_WRITE | x)  
#define _READ(x)   (SPI_READ | x)

//PD bits
#define MODE_NORMAL 0
#define MODE_STANDBY 1 //shut down analog, except LDO
#define MODE_SLEEP 2 //shut down analog including LDO(default)
#define MODE_RESET 3 //POR

//CONV_START bits
#define _DEST(x) x<<4 //where x = 0:7 is the destination data register
#define SINGLE_CONV 0 //single conversion
#define CONT_CONV 1 //continuous conversions
#define DUTY_CONV 2 //25% duty cycle for lower power consumption
 
//CAL_START bits
#define SELF_CAL 0
#define PGA_CAL 1
#define SYS_OFF_A_CAL 4
#define SYS_GAIN_A_CAL 5
#define SYS_OFF_B_CAL 6
#define SYS_GAIN_B_CAL 7

//GP0_CTRL bits
//GP1_CTRL bits
//GP_CONV bits
//GP_SEQ_ADDR bit

//FILTER bits
#define FIR_FIFTYSIXTY 0<<4 //default
#define FIR_FIFTY 1<<4
#define FIR_SIXTY 2<<4
#define SINC4 3<<4

#define _RATE(x) x //where x is 0 to 7

//CTRL bits
#define EXT_CLOCK 1<<7
#define INT_CLOCK 0<<7 //default

#define UNIPOLAR 1<<6
#define BIPOLAR 0<<6 //default

#define TWOS_COMP 0<<5 //default
#define OFFSET_BIN 1<<5

#define _PBUF_EN(x) x<<4
#define _NBUF_EN(x) x<<3

#define REF_AIN01 0
#define REF1 1
#define REF2 2
#define REF_AVDD 3
#define REF_UNI_AIN 4
#define REF_UNI_REF1 5
#define REF_UNI_REF2 6

//SOURCE bits
#define VBIAS_ACTIVE 0<<6 //default
#define VBIAS_HIGH 1<<6
#define VBIAS_LOW 2<<6

#define BRN_OFF 0<<4 //default
#define BRN_0P5UA 1<<4
#define BRN_1UA 2<<4
#define BRN_10UA 3<<4

#define _IDAC(x) x //0 defaul, where x is 0x00 to 0x0F 10-1600uA

//MUX_CTRL0 bits
#define _AINP(x) x<<4 //where x is x0,1,2,3,4,5,6,7,8,9 for ecah of the ten inputs or xA for VDD, xF for disconnnected (default)
#define _AINN(x) x //where x is x0,1,2,3,4,5,6,7,8,9 for ecah of the ten inputs or xA for GND, xF for disconnected (default)

//MUX_CTRL1 bits
#define _IDAC1(x) x<<4 //where IDAC1 is connect ed to x = x0,1,2,3,4,5,6,7,8,9 for ecah of the ten inputs or xA for VDD, xF for disconnnected (default)
#define _IDAC0(x) x //where IDAC0 is connect ed to x = x0,1,2,3,4,5,6,7,8,9 for ecah of the ten inputs or xA for VDD, xF for disconnnected (default)

//MUX_CTRL2 bits
#define _VDD_2_INPUT(x) 1<<x
#define _VDD_OFF_INPUT(x) 0<<x

//PGA bits
#define BUFFER_ON 0<<4 //default
#define BYPASS 1<<4 //no buffer (saves a tiny amount of power)
#define PGA 2<<4 //use progammable gain

#define _GAIN_EXP(x) x //gain is 2^x (exponent)

//Status interrupt enbable (REG_STATUS_IE) bits
#define DATA_RDY_INT 0x00000010
#define CAL_RDY_INT  0x00000004
#define CONV_RDY_INT 0x00000001 //default

//WAIT_EXT
//WAIT_START


class MAX11410
{
    SPI *spi;
    DigitalOut *cs;
    
    public:
        MAX11410(SPI *, DigitalOut *);
        void reset();
        void write8bitReg(char, char);
        void write24bitReg(char, uint32_t);
        char read8bits(char regAddr, bool *);
        uint32_t read24bits(char regAddr, bool *);
        int32_t read24bitsSigned(char regAddr, bool *);
        int32_t readInterrupts(bool *);
        bool interrupt();
        void calOffset();
        void calGain();
        uint32_t readStatus(bool *); 

};

#endif /*__MAX11410_H__*/

