#include "mbed.h"
#include "LCD_DISCO_F746NG.h"
#include "TS_DISCO_F746NG.h"

LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG boutton;

DigitalOut led1(LED1);
DigitalIn detecteur(D1); // sortie du capteur PIR

int x,y;

int main()
{
    while(1) {
        int idx = 0;
        bool fini = true;
        //uint8_t init;
        //init = boutton.Init(lcd.GetXSize(),lcd.GetYSize());//initialisation du bouton
        TS_StateTypeDef TS_State;//etat du tacticle
        lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"ALARME", CENTER_MODE);

        while(fini) {
            if (detecteur.read()== 0) {
                lcd.Clear(LCD_COLOR_BLACK);//effacer l'ecran
                lcd.SetTextColor(LCD_COLOR_RED);
                lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"Aucun Mouvement Detecte", CENTER_MODE);
                wait(1);
                lcd.SetTextColor(LCD_COLOR_GREEN); //affichage rond vert
                lcd.FillCircle(50, 50, 40);
                wait(1);
                lcd.Clear(LCD_COLOR_BLACK);

            } else {
                lcd.Clear(LCD_COLOR_BLACK);
                lcd.SetTextColor(LCD_COLOR_RED);
                lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"Mouvement Detecte", CENTER_MODE);
                wait(1);

                lcd.SetTextColor(LCD_COLOR_RED);//affichage rond rouge
                lcd.FillCircle(50, 50, 40);
                wait(1);


                lcd.Clear(LCD_COLOR_BLACK);
                lcd.SetBackColor(LCD_COLOR_BLACK);
                lcd.SetTextColor(LCD_COLOR_WHITE);
                lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"Arret alarme", CENTER_MODE);//demande d'arret alarme

                lcd.SetTextColor(LCD_COLOR_WHITE);
                lcd.DrawRect(150,150,180,50);
                lcd.DisplayStringAt(3, LINE(7), (uint8_t *)"Stop", CENTER_MODE);//bouton stop
                wait(1);

                boutton.GetState(&TS_State);
                 if (TS_State.touchDetected) {
                    x = TS_State.touchX[idx];//position du touché tactile
                    y = TS_State.touchY[idx];
                    lcd.SetTextColor(LCD_COLOR_GREEN);//affichage rond vert si arret alarme
                    lcd.FillCircle(50,50, 40);
                    wait(1);
                    lcd.Clear(LCD_COLOR_BLACK);
                    fini = false;
                }
            }
            fini = true;

        }

    }

}

