#include "mbed.h"
#include "MODSERIAL.h"
#include "HIDScope.h"


PwmOut Motor2PWR(D5);
DigitalOut Motor2DIR(D4);
PwmOut Motor1PWR(D6);
DigitalOut Motor1DIR(D7);
AnalogIn emg0(A0);
AnalogIn emg1(A1);
AnalogIn emg2(A2);
AnalogIn Pot1(A4);
AnalogIn Pot2(A5);
MODSERIAL pc(USBTX, USBRX);



float x = 0;
float y = 0;
int main()
{
    Motor1PWR.period_us(60);
    while(1) {
        if(Pot1<0.45f) {
            x = Pot1-1;
        } else if(Pot1>0.55f) {
            x = Pot1;
        } else {
            x = 0;
        }

        if(Pot2<0.45f) {
            y = Pot2-1;
        } else if(Pot2>0.55f) {
            y = Pot2;
        } else {
            y = 0;
        }
        pc.printf("x = %f, y = %f\r\n",x,y);
        Motor1PWR = fabs(y);
        Motor1DIR = y > 0.0f;
        Motor2PWR = fabs(x);
        Motor2DIR = x > 0.0f;
        wait(0.1f);
    }
    
    
    return(0);
}

HIDScope scope(3); 
Ticker scopeTimer;

float biceps_ra = 0.0;
float biceps_la = 0.0;
float triceps_ra = 0.0;

void EMG_Read()
{
    biceps_ra = emg0.read();
    pc.printf("%f ", biceps_ra);
}

void sample()
{ 
    scope.set(0, emg0.read() );
    scope.set(1, emg1.read() );
    scope.set(2, emg2.read() );
  
    scope.send();
}