#include "mbed.h"
#include "MODSERIAL.h"
#include "math.h"
#include "BiQuad.h"
#include "QEI.h"

//Inputs outputs e.t.c.

//Serial
MODSERIAL pc(USBTX, USBRX);

//Leds
DigitalOut led1(LED_GREEN);
DigitalOut led2(LED_BLUE);
DigitalOut led3(LED_RED);

//Timing
Ticker LedTimer;

Ticker ScopeTimer;
Timeout SignalTimeout;

Ticker ControlTicker;
Ticker ControlTicker1;

//Buttons
DigitalIn button(SW2);

//Emg
AnalogIn emg1(A0);
AnalogIn emg2(A1);
AnalogIn emg3(A2);


//Control
PwmOut Motor2PWR(D5);
DigitalOut Motor2DIR(D4);
PwmOut Motor1PWR(D6);
DigitalOut Motor1DIR(D7);
QEI Encoder1(D12,D13,NC,32);
QEI Encoder2(D10,D11,NC,32);

//Filter
BiQuadChain bqc;



//Declare variables
double fsample = 500; //Hz
double fcontrol = 1000; //Hz
int max_n;  // length of measured arrays
double pi = 3.14159265;

// variables that depend on fsample
double Ts = 1/500; // Sample time in seconds
double emg1_log[500*6];
double emg2_log[500*6];
double emg3_log[500*6];
    
double RadPerCount = 131.25*2*pi/4200;

//Encoders
int counts1;
int counts2;

//PID
double Kp = 10;
double Ki = 1.02;
double Kd = 15.2;

//Movavg
int avgn;
double avgh;
double ms = 100; // number of datapoints used in moving average filter
double highnum;

//Bools
bool MeasureBool = true;
bool MoveBool;
bool Calibrated = false;
volatile bool pause_loop = false;

//States
bool statechanged = false;
enum Colors {Green, Blue, Red, Off};
enum states {CalibrateM, CalibrateE, MandM, Done};
enum Directions {Up, Down, Left, Right};
Directions CurrentDir = Down;
Colors LedState = Off;
states ProgramState = CalibrateM;

//Systeem eigenschappen
double L0 = 40; //cm
double L1 = 45; //dm

//Speeds and Positions
double setpoint;
double MaxV = 6.3; //rad/s
double qv[2]; //setpoint velocity
double qr[2]; //setpoint pos
double q1;
double q2;

//Maak filters
BiQuad bq1(0.9475454809720195,-1.895090961944039,0.9475454809720195,-1.8932193507849706,0.8969625731031077); //highpass 5Hz
BiQuad bq2(0.843582000346111,-1.3649443488576334,0.843582000346111,-1.3649443488576334,0.6871640006922219); //notch 50Hz
BiQuad bq3(0.9824,-0.6071,0.9824,-0.6071,0.9647); //notch 100Hz
BiQuad bq4(0.9738  ,  0.6018 ,   0.9738,0.6018  ,  0.9475); //notch 150Hz
BiQuad bq5(0.9653  ,  1.5619  ,  0.9653,1.5619  ,  0.9307); //notch 200Hz

//Programma

void CancelPause(){
    pause_loop = false;
}

void ClearEmg(){
    int n;
    for(n = 0; n <= max_n; n++){
        emg1_log[n] = 0;
    }
    avgh = 0;
    avgn = 0;
    max_n = 0;
}

void MeasurePos(){
    counts1 = Encoder1.getPulses();
    counts2 = Encoder2.getPulses();
    q1 = RadPerCount*counts1;
    q2 = RadPerCount*counts2;
}

void ReferencePos(){
    qr[0] += qv[0]*1/fcontrol;
    qr[1] += qv[1]*1/fcontrol;
}

void fmovavg(){
    double avgm;
    avgh += emg1_log[max_n];
    if(max_n >= ms){
        avgm = emg1_log[avgn];
        emg1_log[avgn] = avgh/ms;
        avgh -= avgm;
        avgn++;
    }
}

void EmgMeasure(){    //meet de EMG waarden en stop ze in een array wel filters maar geen moving average
    double n = max_n;
    if(MeasureBool && Calibrated){
    emg1_log[max_n] =  fabs(bqc.step(emg1.read()))/highnum;
    fmovavg();
    max_n ++;
    }
    else if(MeasureBool){
    emg1_log[max_n] =  fabs(bqc.step(emg1.read()));
    fmovavg();
    max_n++;
    }
}

void MakeEmg(){
    int n;
    for(n =0 ;n<=max_n;n++){
        if((n >= 500) && (n <= 600)){
        emg1_log[n] = 0.3;
        }
        else{
            emg1_log[n] = 0;
        }
    }
}

void LedBlink(){
    switch(LedState){
        case Green:
            led1.write(!led1.read());
            led2.write(1);
            led3.write(1);
            break;
        case Blue:
            led2.write(!led2.read());
            led1.write(1);
            led3.write(1);
            break;
        case Red:
            led3.write(!led3.read());
            led1.write(1);
            led2.write(1);
            break;
        default:
            led1.write(1);
            led2.write(1);
            led3.write(1);
            break;
    }
}

void ChangeDIR(){
    switch(CurrentDir){
        case Up:
            CurrentDir = Down;
            break;
        case Down:
            CurrentDir = Left;
            break;
        case Left:
            CurrentDir = Right;
            break;
        case Right:
            CurrentDir = Up;
            break;
        default:
            break;
        }
}

void CheckValue(){
    setpoint = 0;
    int n;
    for(n = 0;n<=max_n;n++){
        if(emg1_log[n] >= setpoint){
            setpoint = emg1_log[n];
        }
        emg1_log[n] = 0;
        if(setpoint>1){     //Saturaion
            setpoint = 1;
        }
        if(setpoint<0.2){   //Rest
            setpoint = 0;
        }
    }
}

void InvKin(){
    double Inverse_J[2][2] = {{(-cos(q1) + sin(q2))/((cos(q1)*(L1 + L0*cos(q2)) - L1*sin(q1)*sin(q2)))     ,       (L1 + L0*cos(q2) - L1*sin(q1))/(L0*(cos(q1)*(L1 + L0*cos(q2)) - L1*sin(q1)*sin(q2)))}     ,       {sin(q2)/(-cos(q1)*(L1 + L0*cos(q2)) + L1*sin(q1)*sin(q2))     ,       -((L1 + L0*cos(q2))/(L0*(cos(q1)*(L1 + L0*cos(q2)) - L1*sin(q1)*sin(q2))))}};
    if(button.read() == 0){
        ChangeDIR();
    }
    switch(CurrentDir){
        case Up:
            qv[0] = Inverse_J[0][1]*setpoint;
            qv[1] = Inverse_J[1][1]*setpoint;
            break;
        case Down:
            qv[0] = Inverse_J[0][1]*(-setpoint);
            qv[1] = Inverse_J[1][1]*(-setpoint);
            break;
        case Left:
            qv[0] = Inverse_J[0][0]*(-setpoint);
            qv[1] = Inverse_J[1][0]*(-setpoint);
            break;
        case Right:
            qv[0] = Inverse_J[0][0]*setpoint;
            qv[1] = Inverse_J[1][0]*setpoint;
            break;
        default:
            break;
        }
    qv[0] = qv[0]*MaxV;
    qv[1] = qv[1]*MaxV;
}

void CalibrateEmg(){
    MeasureBool = false;
    LedState = Off;
    int n;
    for(n = 0;n<=max_n;n++){
        if(emg1_log[n] >= highnum){
            highnum = emg1_log[n];
        }
        emg1_log[n] = 0;
    }
    if(highnum>1){
        highnum = 1;
    }
    max_n = 0;
    if(highnum <= 0.2){
        pc.printf("Done calibrating \r\n%.2f Oei! Dat is jammer \r\n",highnum);
    }
    else if(highnum <= 0.4){
        pc.printf("Done calibrating \r\n%.2f Kan beter he \r\n",highnum);
    }
    else if(highnum <= 0.6){
        pc.printf("Done calibrating \r\n%.2f Komt in de buurt \r\n",highnum);
    }
    else if(highnum <= 0.8){
        pc.printf("Done calibrating \r\n%.2f Prima! \r\n",highnum);
    }
    else if(highnum <= 1){
        pc.printf("Done calibrating \r\n%.2f Lekker Bezig man!\r\n",highnum);
    }
    Calibrated = true;
    MeasureBool = true;
    wait(0.1f);
    pause_loop = false;
}

void CalibrateMotors(){
    Motor1DIR = 0;
    Motor2DIR = 0;
    Motor1PWR = 0.52;
    Motor2PWR = 0.52;
    ProgramState = CalibrateE;
}

double PID_Controller(double error){
    static double error_integral = 0;
    static double error_prev = error; // initialization with this value only done once!
    static BiQuad LowPassFilter(0.0640, 0.1279, 0.0640, -1.1683, 0.4241);  
    
    // Proportional part:
    double u_k = Kp * error;

    // Integral part
    error_integral = error_integral + error * Ts;
    double u_i = Ki * error_integral;

    // Derivative part
    double error_derivative = (error - error_prev)/Ts;
    double filtered_error_derivative = LowPassFilter.step(error_derivative);
    double u_d = Kd * filtered_error_derivative;
    error_prev = error;
    
    // Sum all parts and return it
    return u_k + u_i + u_d;  
}

void LogSignals(){     //stuur het signaal naar de pc via serial
    MeasureBool = false;
    int n;
    for(n = 0;n<=max_n;n++){
        emg1_log[n] = emg1_log[n]/highnum;
        //pc.printf("%f, ",emg1_log[n]);
        //wait(0.01f);
    }
    pc.printf("\r\n\r\n%i", max_n);
    ClearEmg();
    pause_loop = false;
    wait(0.1f);
}

void SetPointJoint(){
    if(MoveBool){
        MeasureBool = false;
        wait(0.01f);
        pc.printf("\r\nHO");
        CheckValue();
        ClearEmg();
        MeasureBool = true;
    }
}


void MeasureAndControl(){
    InvKin();
    ReferencePos();
    MeasurePos();
    double motorinput1 = PID_Controller(qr[0] - q1);
    double motorinput2 = PID_Controller(qr[1] - q2);
}

void Movemotors(double input1, double input2){
    if(input1>0){
        Motor1DIR = 1;
    }
    else{
        Motor1DIR = 0;
    }
    if(fabs(input1)>1){
        Motor1PWR = 1;
    }
    else{
        Motor1PWR = fabs(input1);
    }
    if(input2>0){
        Motor2DIR = 1;
    }
    else{
        Motor2DIR = 0;
    }
    if(fabs(input2)>1){
        Motor2PWR = 1;
    }
    else{
        Motor2PWR = fabs(input2);
    }
}


void ProcessStateMachine(){
    switch(ProgramState){
    case CalibrateM:
        CalibrateMotors();
        break;
    case CalibrateE:
        LedState = Green;
        pause_loop = true;
        LedTimer.attach(&LedBlink,0.2);
        ScopeTimer.attach(&EmgMeasure,1/fsample);
        //MakeEmg();
        SignalTimeout.attach(&CalibrateEmg,5);
        while(pause_loop){}
        ProgramState = MandM; 
        break;
    case MandM:
        LedState = Blue;
        pause_loop = true;
        MoveBool = true;
        ScopeTimer.attach(&EmgMeasure,1/fsample);
        //SignalTimeout.attach(CancelPause,0.5);
        //SignalTimeout.attach(&LogSignals,5);
        ControlTicker.attach(&SetPointJoint,0.5);
        ControlTicker1.attach(&MeasureAndControl,1/fcontrol);
        while(pause_loop){}
        ProgramState = Done;
        break;
    default:
        LedState = Off;
        if(statechanged){
        pc.printf("\r\nyeeee\r\n");
        statechanged = false;
        }
        break;
    }
}
    
int main(){
    led1.write(1);
    led2.write(1);
    led3.write(1);
    
    pc.baud(115200);
    Motor1PWR.period_us(60);
    Motor2PWR.period_us(60);
    bqc.add( &bq1).add( &bq2 ).add( &bq3 ).add( &bq4 ).add( &bq5 );
    
    while(1){
        ProcessStateMachine();
     }
}