#include "mbed.h"
#include "LPC17xx.h"


int main() {
    UART3_init();
    
    UART3_putc('C');
}

void UART3_init()
{
    const uint32_t baudrate = 9600;
    
    //On "power on" le module UART3
    LPC_SC->PCONP |= (1<<25);
    
    //On met le device clock a CPU CLOCK/1
    LPC_SC->PCLKSEL1 &= ~(3<<18);
    LPC_SC->PCLKSEL1 |= (1<<18);
    
    //Formule: registreValue = Clock du chip / (16*baudrate)
    uint8_t dllRegValue = 96000000 / (16 * baudrate);
    
    //On set le bit DLAB a 1
    LPC_UART3->LCR = (1 << 7);
    //On donne la valeur au registre DLL pour que le baudrate soit 9600
    LPC_UART3->DLL = dllRegValue;
    
    //8 bit de message, 1 bit de stop, pas de bit de parite
    LPC_UART3->LCR = 3;
    
    //On allume le FIFO
    LPC_UART3->FCR = 1;
    
    //Selection des pins pour UART3
    LPC_PINCON->PINSEL0 |= 0x00000002;
    
    
}

void UART3_putc(char c)
{
    //Il faut attendre que le transfert soit fini pour envoyer un deuxieme caractere
    LPC_UART3->THR = c;
    
    //Tant que le registre de transmiter n'est pas vide
    while (true)
    {
        if (LPC_UART3->LSR & (1 << 5))
        {
            break;    
        }
    }
}