#include "UART.h"
#include "LPC17xx.h"

UART::UART()
{
    PCOMP =  (int *)0x400FC0C4;
    PCLKSEL0 = (int *)0x400FC1A8;
    U0LCR = (int *)0x4000C00C;
    U0DLL = (int *)0x4000C000;
    U0DLM = (int *)0x4000C004;
    U0FCR = (int *)0x4000C008;
    PINSEL0 = (int *)0x4002C000;
    
    
    //Donne acces aux registres DLL et DLM pour set le baud rate
    *U0LCR |= 0x00000080;
    
    //On met le registre de PCLK_UART0 à 01
    *PCLKSEL0 |= 0x00000080;
    
    //On active les pins pour TXD0
    *PINSEL0 &= ~0x00000020;
    *PINSEL0 |= 0x00000010;
    
    //On active le FIFO
    *U0FCR |= 0x00000001;
    
    //8 bits de data
    *U0LCR |= 0x00000003;
    //1 Seul stop bit, pas de parite
    *U0LCR &= ~0x0000000C;
}