#include "mbed.h"
#include "rtos.h"

/*
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalIn sw1(p15);
DigitalIn sw2(p16);

Mutex mute;
Queue<string, 5> mb;


void producer_Thread(void const *args)
{
    while (true) {
            mute.lock();
            mb.alloc
            mute.unlock();
    }
}
void consumer_Thread(void const *args)
{
    while (true) {
            mute.lock();
            led1 = 0;
            led2 = 0;
            wait(0.5);
            mute.unlock();
    }
}

int main()
{
    Thread thread1(producer_Thread);
    Thread thread2(consumer_Thread);
    while (true) {
    }
} */

//Pins
DigitalIn en_1(p15);
DigitalIn en_2(p16);
AnalogIn ea_1(p19);
AnalogIn ea_2(p20);

//Constantes
#define FREQ_NUM_MS  100
#define FREQ_ANAL_MS 250
#define FREQ_NUM_STAB_MS 50
        
#define SIGNAL_NUM 0x1
#define SIGNAL_ANAL 0x2

#define NIVEAU_DC_ANAL 3.3
#define SEUIL_ANAL 1.125

void lecture_analog(void const *args) {
    bool premiereLectureDispo = false;
    int echantillonsAnal[5] = {0, 0, 0, 0, 0};
    int compteur = 0;
    float moyenneCourante = 0;
    
    while (true) 
    {        
        // lecture des échantillons analogiques
            //TODO soit inclure ea_2, soit rendre la méthode réutilisable (plus nice)
        echantillonsAnal[compteur] = ea_1;
        // calcul de la nouvelle moyenne courante
        if(premiereLectureDispo == true)
        {
            moyenneCourante = 0;
            for(int i = 0; i < 5; i++)
            {
                moyenneCourante += echantillonsAnal[i];
            }
            moyenneCourante = moyenneCourante / 5;
        }
        
        compteur++;
        if(compteur >= 5)
        {
            compteur = 0;
            premiereLectureDispo = true;
        }
        // génération éventuelle d'un événement
        if(moyenneCourante > SEUIL_ANAL * NIVEAU_DC_ANAL)
        {
            //Générer un évènement
            time_t seconds = time(NULL);
            char buffer[32];
            strftime(buffer, 32, "%I:%M %p\n", localtime(&seconds));
        }
    }
}


void lecture_num(void const *args) {
    bool lecture, lecturePrecedente, lectureDebut;
    while (true) 
    {
        // lecture des échantillons numériques
        //TODO, généralisé la fonction
        lectureDebut = en_1.read();
        wait_ms(FREQ_NUM_STAB_MS);
        if(lectureDebut != en_1.read())
        {
            time_t seconds = time(NULL);
            char buffer[32];
            strftime(buffer, 32, "%I:%M %p\n", localtime(&seconds));
        }
        
    // prise en charge du phénomène de rebond
    // génération éventuelle d'un événement
    }
}

void collection(void const *args) {
while (true) 
    {
    // attente et lecture d'un événement
    // écriture de l'événement en sortie (port série)
    }
}



void signaler() {
    RtosTimer anal_timer(lecture_num, osTimerPeriodic, NULL);
    RtosTimer num_timer(lecture_analog, osTimerPeriodic, NULL);
    
    anal_timer.start(FREQ_ANAL_MS);
    num_timer.start(FREQ_NUM_MS);
    
    //Thread thread_Anal(lecture_analog);
    //Thread thread_Num(lecture_num);
    //Transitionner vers RTOS_TImer
    //while (true)
    //{           
    //    thread_Anal.signal_set(SIGNAL_ANAL);
    //    thread_Num.signal_set(SIGNAL_NUM);        
    //}
}

int main() {
    // initialisation du RTC
    set_time(1453667014);
    
    // démarrage des tâches
    RtosTimer anal_timer(lecture_num, osTimerPeriodic, NULL);
    RtosTimer num_timer(lecture_analog, osTimerPeriodic, NULL);
    
    anal_timer.start(FREQ_ANAL_MS);
    num_timer.start(FREQ_NUM_MS);
    
    while(1);
}