#include "mbed.h"
#include "x_nucleo_iks01a1.h"
#include "SpwfInterface.h"
#include "TCPSocket.h"

DigitalOut led1(LED1);

// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)
int main() {
    Serial pc(USBTX, USBRX);
    DevI2C i2c(D14, D15);
    HTS221 htsensor(i2c);
    LPS25H barosensor(i2c);
    
    uint8_t sensor_id;
    int status = htsensor.ReadID(&sensor_id);
    if (status || sensor_id != I_AM_HTS221) {
        pc.printf("No HT sensor (status = %d id = %02x?\n", status, sensor_id);
    }
    HUM_TEMP_InitTypeDef htInitState = {
        .OutputDataRate = HTS221_ODR_7Hz, // This is the only one used by the init
    };
    status = htsensor.Init(&htInitState);
    if (status) {
        pc.printf("HT init fails!\n");
    }
    
    status = barosensor.ReadID(&sensor_id);
    if (status || sensor_id != I_AM_LPS25H) {
        pc.printf("No Barosensor (status = %d id = %02x?\n", status, sensor_id);
    }
    
    PRESSURE_InitTypeDef baroInitState = {
        // These are used in the initialization
        .OutputDataRate = LPS25H_ODR_7Hz,
        .DiffEnable = LPS25H_DIFF_DISABLE,
        .BlockDataUpdate = LPS25H_BDU_CONT,
        .SPIMode = LPS25H_SPI_SIM_4W
    };
    status = barosensor.Init(&baroInitState);
    if (status) {
        pc.printf("Baro init fails!\n");
    }
    
    SpwfSAInterface wifiIf(D8, D2, /*debug*/true);
    Thread::wait(5000);
    pc.printf("Connecting...\n");
    int wifiStatus = wifiIf.connect("ssid", "Pa55w0rd", NSAPI_SECURITY_WPA2, 3);
    
    while (true) {
        led1 = !led1;
        float temperature = 0.0;
        status = htsensor.GetTemperature(&temperature);
        float humidity = 0.0;
        status |= htsensor.GetHumidity(&humidity);
        float pressure = 0.0;
        status |= barosensor.GetPressure(&pressure);
        float temperatureB = 0.0;
        status |= barosensor.GetTemperature(&temperatureB);
        pc.printf("Status = %d T = %.1f C RH = %.1f%% | T = %.1f C P = %.1f mbar\n", 
            status, temperature, humidity, temperatureB, pressure);
        Thread::wait(15000);
        // pc.printf("IP address %s\n", wifiIf.get_ip_address());
    }
}

