#include "PCA9685.h"
#include "mbed.h"
PCA9685::PCA9685(PinName sda, PinName scl) : i2c(sda, scl) {}
//定义引脚与地址
void PCA9685::begin(void)//初始化
{
    reset(0x80);
    reset(0x82);
}

void PCA9685::frequencyI2C(int freq)//初始化
{
    i2c.frequency(freq);
}
void PCA9685::write8(uint8_t address, uint8_t data)//写函数
{
    char cmd[2];
    cmd[0] = address;
    cmd[1] = data;
    i2c.write(_i2caddr, cmd, 2);
}

char PCA9685::read8(char address)//读函数
{
    i2c.write(_i2caddr, &address, 1);
    char rtn;
    i2c.read(_i2caddr, &rtn, 1);
    return rtn;
}

void PCA9685::reset(int addr4)//复位
{
     _i2caddr=addr4;
    write8(PCA9685_MODE1, 0x0);
}
void PCA9685::setPrescale(uint8_t prescale,int addr2) {    
    _i2caddr=addr2;
    uint8_t oldmode = read8(PCA9685_MODE1);
    uint8_t newmode = (oldmode&0x7F) | 0x10; // sleep
    write8(PCA9685_MODE1, newmode); // go to sleep
    wait_ms(5);
    write8(PCA9685_PRESCALE, prescale); // 设置预缩放
    write8(PCA9685_MODE1, oldmode);
    wait_ms(5);
    write8(PCA9685_MODE1, oldmode | 0xa1);
}
void PCA9685::setPWMFreq(float freq,int addr3) //设置频率
{
    _i2caddr=addr3;
    float prescaleval = 25000000;
    prescaleval /= 4096;
    prescaleval /= freq;
    uint8_t prescale = floor(prescaleval  + 0.5) - 1;
    setPrescale(prescale,addr3);
}

void PCA9685::setPWM(uint8_t num, uint16_t on, uint16_t off,int addr)
{
    _i2caddr=addr;
    char cmd[5];
    cmd[0] = LED0_ON_L + 4 * num;
    cmd[1] = on;
    cmd[2] = on >> 8;
    cmd[3] = off;
    cmd[4] = off >> 8;
    i2c.write(_i2caddr, cmd, 5);
}
