/*  A quick example program to show
how to use the Mbed LPC1768 with the
4D systems 4.3 inch capacitive touch
screen.

The display has four vitual winButton objects
which when touched change the state of four
virtual led (userLed) objects.  The led objects on
change of state send a serial message out to
the Mbed serial port on pins 9 and 10.

This message tells the Mbed to drive 
actual corresponding LEDS
1 to 4 appropriately

*/

#include "mbed.h"
#include "mbed_genie.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

bool winButton0Status = false; //holds the "status" of winButton0 object.
bool userLed0Status = false;   //hold the "status" of userLed0 object.

bool winButton1Status = false; //holds the "status" of winButton1 object.
bool userLed1Status = false;   //hold the "status" of userLed1 object.

bool winButton2Status = false; //holds the "status" of winButton2 object.
bool userLed2Status = false;   //hold the "status" of userLed2 object.

bool winButton3Status = false; //holds the "status" of winButton3 object.
bool userLed3Status = false;   //hold the "status" of userLed3 object.


//Event handler for the 4d Systems display
void myGenieEventHandler(void)
{
    genieFrame Event;
    genieDequeueEvent(&Event);

    if(Event.reportObject.cmd == GENIE_REPORT_EVENT) {

        // If the Reported Message was from winbutton0 and userLed0 is off

        if (Event.reportObject.object == GENIE_OBJ_WINBUTTON) {
            if ((Event.reportObject.index == 0) && (userLed0Status==false)) {
                printf("LED1 High \r\n");
                wait(0.1);
                winButton0Status=true;
            }
        }

        // If the Reported Message was from winbutton0 and userLed0 is on

        if (Event.reportObject.object == GENIE_OBJ_WINBUTTON) {
            if ((Event.reportObject.index == 0) && (userLed0Status == true)) {
                printf("LED1 Low \r\n");
                wait(0.1);
                winButton0Status=false;
            }
        }

        // If the Reported Message was from winbutton1 and userLed1 is off

        if (Event.reportObject.object == GENIE_OBJ_WINBUTTON) {
            if ((Event.reportObject.index == 1) && (userLed1Status==false)) {
                printf("LED2 High \r\n");
                wait(0.1);
                winButton1Status=true;
            }
        }

        // If the Reported Message was from winbutton1 and userLed1 is on

        if (Event.reportObject.object == GENIE_OBJ_WINBUTTON) {
            if ((Event.reportObject.index == 1) && (userLed1Status == true)) {
                printf("LED2 Low \r\n");
                wait(0.1);
                winButton1Status=false;
            }
        }

        // If the Reported Message was from winbutton2 and userLed2 is off

        if (Event.reportObject.object == GENIE_OBJ_WINBUTTON) {              
            if ((Event.reportObject.index == 2) && (userLed2Status==false)) {
                printf("LED High \r\n");
                wait(0.1);
                winButton2Status=true;
            }
        }

        // If the Reported Message was from winbutton2 and userLed2 is on

        if (Event.reportObject.object == GENIE_OBJ_WINBUTTON) {              
            if ((Event.reportObject.index == 2) && (userLed2Status == true)) {
                printf("LED Low \r\n");
                wait(0.1);
                winButton2Status=false;
            }
        }
        
        // If the Reported Message was from winbutton3 and userLed3 is off

        if (Event.reportObject.object == GENIE_OBJ_WINBUTTON) {              
            if ((Event.reportObject.index == 3) && (userLed3Status==false)) {
                printf("LED High \r\n");
                wait(0.1);
                winButton3Status=true;
            }
        }

        // If the Reported Message was from winbutton3 and userLed3 is on

        if (Event.reportObject.object == GENIE_OBJ_WINBUTTON) {              
            if ((Event.reportObject.index == 3) && (userLed3Status == true)) {
                printf("LED Low \r\n");
                wait(0.1);
                winButton3Status=false;
            }
        }
    }
}


int main()
{

    SetupGenie();

    genieAttachEventHandler(&myGenieEventHandler);

    printf("Langsters's mbed Visi-Genie LED demo \r\n");

    genieWriteContrast(15); //set screen contrast to full brightness

    while(1) {

        //check if winButton0 is High & set LED0 High 

        if (winButton0Status == true) {
            printf("Button 0 in On State! \r\n");     //send button status message
            genieWriteObject(GENIE_OBJ_USER_LED, 0x00, 1); // set virtual LED0 High     
            wait(0.1); // wait 100uS
            led1 = 1; // set actual LED1 High
            userLed0Status = true; // set userLed0Status High

        }

        //check if winButton0 is low & set LED low 

        else if (winButton0Status == false) {
            printf("Button 0 in Off state! \r\n");    //send button status message
            genieWriteObject(GENIE_OBJ_USER_LED, 0x00, 0); // set virtual LED0 Low      
            wait(0.1); // wait 100uS
            led1 = 0; // set actual LED1 Low
            userLed0Status = false; //set userLed0Status Low

        }
        
        //check if winButton1 is High & set LED High 
        
        if (winButton1Status == true) {
            printf("Button 1 in On State! \r\n");     //send button status message
            genieWriteObject(GENIE_OBJ_USER_LED, 0x01, 1); // set virtual LED0 High     
            wait(0.1); // wait 100uS
            led2 = 1; // set actual LED2 High
            userLed1Status = true; // set userLed1Status High

        }

        //check if winButton1 is low & set LED low 

        else if (winButton1Status == false) {
            printf("Button 1 in Off state! \r\n");    //send button status message
            genieWriteObject(GENIE_OBJ_USER_LED, 0x01, 0); // set virtual LED0 Low      
            wait(0.1); // wait 100uS
            led2 = 0; // set actual LED1 Low
            userLed1Status = false; //set userLed1Status Low

        }
        
        //check if winButton2 is High & set LED High 
        
        if (winButton2Status == true) {
            printf("Button 2 in On State! \r\n");     //send button status message
            genieWriteObject(GENIE_OBJ_USER_LED, 0x02, 1); // set virtual LED0 High     
            wait(0.1); // wait 100uS
            led3 = 1; // set actual LED2 High
            userLed2Status = true; // set userLed1Status High

        }

        //check if winButton2 is low & set LED low 

        else if (winButton2Status == false) {
            printf("Button 2 in Off state! \r\n");    //send button status message
            genieWriteObject(GENIE_OBJ_USER_LED, 0x02, 0); // set virtual LED0 Low      
            wait(0.1); // wait 100uS
            led3 = 0; // set actual LED1 Low
            userLed2Status = false; //set userLed1Status Low

        }
        
        //check if winButton3 is High & set LED High 
        
        if (winButton3Status == true) {
            printf("Button 3 in On State! \r\n");     //send button status message
            genieWriteObject(GENIE_OBJ_USER_LED, 0x03, 1); // set virtual LED0 High     
            wait(0.1); // wait 100uS
            led4 = 1; // set actual LED2 High
            userLed3Status = true; // set userLed1Status High

        }

        //check if winButton2 is low & set LED low 

        else if (winButton3Status == false) {
            printf("Button 3 in Off state! \r\n");    //send button status message
            genieWriteObject(GENIE_OBJ_USER_LED, 0x03, 0); // set virtual LED0 Low      
            wait(0.1); // wait 100uS
            led4 = 0; // set actual LED1 Low
            userLed3Status = false; //set userLed1Status Low

        }        
        

    }

}