/* An mbed tutorial example using the
4.3' PCT 4d systems touch screen display.

uses the mbed_genie library ported from the arduino
visie-genie library by Christian B

The display serial TX and RX pins are connected to pin 9
and pin 10 of the mbed, the reset pin is connected to pin 11

For setting up the display in Visie-Genie

The display has a rocker switch object, an LED object,
and a slider object.

The program reads the status of the rocker switch
and was supposed to turn on the LED.

The slider adjusts the flash rate of the LED

The baud rate of the display is set to 115200 baud

The Mbed4dGenie class requires 3 parameters
    1 - Tx pin
    2 - Rx pin
    3 - Reset pin
*/

#include "mbed.h"
#include "mbed_genie.h"

Mbed4dGenie lcd4d(p9,p10,p11);

DigitalOut whiteLED(p26);     //LED 1 for indication
int rockersw_val = 0;         //holds the status of the 4Dbutton0 Object

int sliderRead = 0;
float flashRate = 1;        //variable to store LED flash rate
int flag = 0;               //flag variable to store rockerswitch state

//Event handler for the 4d Systems display
void myGenieEventHandler(void)
{
    genieFrame Event;
    lcd4d.genieDequeueEvent(&Event);

    //event report from an object
    if(Event.reportObject.cmd == GENIE_REPORT_EVENT) {
        if (Event.reportObject.object == GENIE_OBJ_ROCKERSW) { // If the Reported Message was from a rocker switch
            if (Event.reportObject.index == 0) {
                printf("Rocker switch 0 pressed!\n\r");
                rockersw_val = lcd4d.genieGetEventData(&Event);  //extract the MSB and LSB values and pass them to rockersw_val

                if (rockersw_val == 0) {                   //if Rockerswitch0 is off
                    flag = 0;                              //"turn off" the LED
                    printf("Rocker switch switch in off state\n\r"); //print a serial message for debugging
                }

                else if (rockersw_val == 1) {              //if Rockerswitch0 is on
                    flag = 1;                              //"turn on" the LED
                    printf("Rocker switch switch in ON state\n\r"); //print a serial message for debugging
                }
            }
        }

        if (Event.reportObject.object == GENIE_OBJ_SLIDER) {    // If the Reported Message was from a slider object
            if (Event.reportObject.index == 0) {                // If the slider object was slider0
                printf("Slider object changed!\n\r");           // Display a serial message for debugging
                sliderRead = lcd4d.genieGetEventData(&Event);   // Read the current silder0 value
                printf("SliderRead = %d \n\r", sliderRead);     // Display the Slider0 value
                flashRate = 0.01;                               // Set flash rate initially to 10 ms On / Off
                flashRate = 1 - (flashRate * sliderRead);       // Apply the value of slider0 object to flashRate


            }

            //Cmd from a reported object (happens when an object read is requested)
            if(Event.reportObject.cmd == GENIE_REPORT_OBJ) {

            }
        }
    }
}

int main()

{
    lcd4d.genieAttachEventHandler(&myGenieEventHandler);    // Call the event handler for the 4D display

    lcd4d.genieWriteContrast(0);                            // Set the display contrast to 0 initially

    lcd4d.genieWriteContrast(15);                           // Set the display contrast to 15 (full brightness)

    printf("Langsters's mbed Visi-Genie LED Flash demo \n\r");  // Display a welcome message on the serial monitor

    while(1) {                                                  // initialise an infinite while loop

        if(flag == 1) {                                          // Check if rockerSW object has been activated
            whiteLED = 1;                                        // turn real LED ON
            wait(flashRate);                                     // keep LED on for a short period of time
            whiteLED = 0;                                        // turn real LED ON
            wait(flashRate);                                     // turn LED off for a short period of time

        }

        if(flag == 0) {                                          // Check if rockerSW object has been deactivated
            whiteLED = 0;                                        // turn real LED OFF
        }
    }
}


