#include "mbed.h"
#include "mbed_genie.h"

#define beta 3977 // from the thermistor datasheet
#define resistance 10 //10k Resistor used in measurement bridge

float tempReading = 0;       // the analog reading from the sensor
float tempCalc = 0;         // the calculated temperature
int rockersw_val = 0;         //holds the status of the 4Dbutton0 Object
int flag = 0;               //flag variable to store rockerswitch state

AnalogIn tempIn(p15);       // thermistor temperature sensor attached to pin 15
/*
    The Mbed4dGenie class requires 3 parameters
    1 - Tx pin
    2 - Rx pin
    3 - Reset pin
*/
Mbed4dGenie lcd4d(p9,p10,p11 );

void getSensorReading(void)
{
    tempReading = (tempIn);    // Read the sensor data from analogue pin 26
    tempCalc = beta / (log(((resistance / tempReading) - 10.0) / 10.0) + (beta / 298.0)) - 273.0;  // Calcuate the actual temperature
    if (tempCalc >= 130)
        tempCalc = 130;
}

void MyGenieEventHandler(void)
{
    genieFrame TheEven;
    while(lcd4d.PendingFrames()) {
        if(lcd4d.genieDequeueEvent(&TheEven)) {
            if( TheEven.reportObject.cmd == GENIE_REPORT_EVENT) {
                if (TheEven.reportObject.object == GENIE_OBJ_ROCKERSW) { // If the Reported Message was from a rocker switch
                    if (TheEven.reportObject.index == 0) {
                        //printf("Rocker switch 0 pressed!\n\r");
                        rockersw_val = lcd4d.genieGetEventData(&TheEven);  //extract the MSB and LSB values and pass them to rockersw_val

                        if (rockersw_val == 0) {                   //if Rockerswitch0 is off
                            flag = 0;
                            //printf("Rocker switch switch in off state\n\r"); //print a serial message for debugging
                        }

                        else if (rockersw_val == 1) {              //if Rockerswitch0 is on
                            flag = 1;
                            //printf("Rocker switch switch in ON state\n\r"); //print a serial message for debugging
                        }
                    }
                }
            }
        }
    }
}

int main()
{
    //int temp = 0;
    printf("Mbed Genie demo with 10k thermistor \n\r");
    lcd4d.Start();
    
    lcd4d.genieAttachEventHandler(&MyGenieEventHandler);

    while(1) {

        getSensorReading();

        if (flag == 1) {
            lcd4d.genieWriteObject(GENIE_OBJ_THERMOMETER,0x00,tempCalc);

            tempCalc = tempCalc * 100;
            lcd4d.genieWriteObject(GENIE_OBJ_LED_DIGITS,0x00,tempCalc);
        }

        else if(flag == 0)

        {
            lcd4d.genieWriteObject(GENIE_OBJ_THERMOMETER,0x00, 0);
            lcd4d.genieWriteObject(GENIE_OBJ_LED_DIGITS,0x00, 0);
        }


    }
}