#include "mbed.h"
#include "stm32f4xx.h"

#define Ts 0.01f
#define Fs 100.0f

/** Ticker **/
Ticker timer0;
Ticker timer1;

/** Serial **/
Serial pc(SERIAL_TX, SERIAL_RX);

/** PWM **/
// servo motor
PwmOut servo_cmd(A0);
// DC motor
PwmOut pwm1(D7);
PwmOut pwm1n(D11);
PwmOut pwm2(D8);
PwmOut pwm2n(A3);

/** IT **/
// Motor1 sensor
InterruptIn HallA_1(A1);
InterruptIn HallB_1(A2);
// Motor2 sensor
InterruptIn HallA_2(D13);
InterruptIn HallB_2(D12);

/** GPIO **/
// onBoard
//DigitalOut LD2(PA_5);
// extBoard
DigitalOut LD1e(A4);
DigitalOut LD2e(A5);

/** the Callback function **/
void timer0_ISR();
void timer1_ISR();

//void HALL_CN_ISR();

//void HALL_CN1_ISR();
//void HALL_CN2_ISR();

void HALLBR_CN1_ISR();
void HALLAR_CN1_ISR();
void HALLBF_CN1_ISR();
void HALLAF_CN1_ISR();

void HALLBR_CN2_ISR();
void HALLAR_CN2_ISR();
void HALLBF_CN2_ISR();
void HALLAF_CN2_ISR();

void Rx_IT_ISR();

/** Functions **/
void init_TIMER();
void init_CN();
void init_PWM();

// servo motor
float angle = 0;
float servo_duty = 0.069 +(0.088/180)*angle;  // 0.069 +(0.088/180)*angle, -90<angle<90
// 90度->duty=0.025; 0度->duty=0.069; -90度->duty=0.113

// Hall1 sensor
int HallA_1_state = 0;
int HallA_1_state_old = 0;
int HallB_1_state = 0;
int HallB_1_state_old = 0;
int HallR_1_state = 0; //Rotation state 0 for CW 1 for CCW
//
int HallState_1 = 0;
int HallState_1_old = 0;

// Hall2 sensor
int HallA_2_state = 0;
int HallA_2_state_old = 0;
int HallB_2_state = 0;
int HallB_2_state_old = 0;
int HallR_2_state = 0; //Rotation state 0 for CW ; 1 for CCW
//
int HallState_2 = 0;
int HallState_2_old = 0;

// PID1
float Kp1 = 0.007;
float Ki1 = 0.01;
float Kd1 = 0.0;
// PID2
float Kp2 = 0.007;
float Ki2 = 0.01;
float Kd2 = 0.0;

// DC motor rotation speed control
volatile float speed_count_1 = 0;
float rotation_speed_1 = 0.0;
float rotation_speed_ref_1 = 0.0;
float pwm1_duty = 0.5;
float PI_out_1 = 0.0;
float a1 = Kp1 + 0.5*Ki1*Ts + Kd1*Fs;
float b1 = -Kp1 + 0.5*Ki1*Ts - 2*Kd1*Fs;
float c1 = Kd1*Fs;
float err1_0 = 0.0;
float err1_1 = 0.0;
float err1_2 = 0.0;
// DC motor rotation speed control
volatile float speed_count_2 = 0;
float rotation_speed_2 = 0.0;
float rotation_speed_ref_2 = 0.0;
float pwm2_duty = 0.5;
float PI_out_2 = 0.0;
float a2 = Kp2 + 0.5*Ki2*Ts + Kd2*Fs;
float b2 = -Kp2 + 0.5*Ki2*Ts - 2*Kd2*Fs;
float c2 = Kd2*Fs;
float err2_0 = 0.0;
float err2_1 = 0.0;
float err2_2 = 0.0;
// PID tune
uint8_t PID_TUNE = 0;

int main(){
    init_TIMER();
    init_PWM();
    init_CN();
}

void init_TIMER(){
       
    // Set the Ticker timer0 to 1Hz
    timer0.attach(&timer0_ISR, 1);
    // Set the Ticker timer1 to 100Hz
    timer1.attach_us(&timer1_ISR, 50000);
    
    // Serial
//    pc.attach(&Rx_IT_ISR, Serial::RxIrq);
    pc.baud(57600);
}

void init_PWM()
{
    servo_cmd.period_ms(20);
    servo_cmd.write(servo_duty);
 
    pwm1.period_us(50);
    pwm1.write(0.5);
    TIM1->CCER |= 0x4;
 
    pwm2.period_us(50);
    pwm2.write(0.5);
    TIM1->CCER |= 0x40;
}

void init_CN()
{
    // 四倍速
    HallA_1.rise(&HALLAR_CN1_ISR);
    HallA_1.fall(&HALLAF_CN1_ISR);
    HallB_1.rise(&HALLBR_CN1_ISR);
    HallB_1.fall(&HALLBF_CN1_ISR);
 
    HallA_2.rise(&HALLAR_CN2_ISR);
    HallA_2.fall(&HALLAF_CN2_ISR);
    HallB_2.rise(&HALLBR_CN2_ISR);
    HallB_2.fall(&HALLBF_CN2_ISR);
}

void HALLBR_CN1_ISR(){
    speed_count_1 += (1 - 2*HallA_1.read());
}
void HALLAR_CN1_ISR(){
    speed_count_1 += (2*HallB_1.read() - 1);
}
void HALLBF_CN1_ISR(){
    speed_count_1 += (2*HallA_1.read() - 1);
}
void HALLAF_CN1_ISR(){
    speed_count_1 += (1 - 2*HallB_1.read());
}

void HALLBR_CN2_ISR(){
    speed_count_2 += (1 - 2*HallA_2.read());
}
void HALLAR_CN2_ISR(){
    speed_count_2 += (2*HallB_2.read() - 1);
}
void HALLBF_CN2_ISR(){
    speed_count_2 += (2*HallA_2.read() - 1);
}
void HALLAF_CN2_ISR(){
    speed_count_2 += (1 - 2*HallB_2.read());
}

//void HALL_CN1_ISR(){
//    HallR_1_state++;
//}
//void HALLBR_CN1_ISR(){
//    HallR_1_state++;
//    
//    HallA_1_state = HallA_1.read();
//          
//    speed_count_1 -= ( (2*HallA_1_state - 1)*HallR_1_state );
//    HallR_1_state = 0;
//}
//void HALL_CN2_ISR(){
//    HallR_2_state++;
//}
//void HALLBR_CN2_ISR(){
//    HallR_2_state++;
//    
//    HallA_2_state = HallA_2.read();
// 
//    speed_count_2 -= ( (2*HallA_2_state - 1)*HallR_2_state );
//    HallR_2_state = 0;
//}

void HALL_CN1_ISR(){
    HallA_1_state = HallA_1.read();
    HallB_1_state = HallB_1.read();
    
    if(HallB_1_state == 1 && HallB_1_state_old == 0){
        HallR_1_state = 2*HallA_1_state - 1;
    }
    speed_count_1 -= HallR_1_state;
    HallA_1_state_old = HallA_1_state;
    HallB_1_state_old = HallB_1_state;
    
    /*****/
    /*HallA_1_state = HallA_1.read();
    HallB_1_state = HallB_1.read();
    
    if(HallA_1_state == 0 && HallB_1_state == 0)HallState_1 = 1;
    else if(HallA_1_state == 1 && HallB_1_state == 0)HallState_1 = 2;
    else if(HallA_1_state == 1 && HallB_1_state == 1)HallState_1 = 3;
    else if(HallA_1_state == 0 && HallB_1_state == 1)HallState_1 = 4;
    
    if(HallState_1-HallState_1_old == 1 || HallState_1-HallState_1_old == -3)speed_count_1--;
    else if(HallState_1-HallState_1_old ==-1 || HallState_1-HallState_1_old == 3)speed_count_1++;
    
    HallState_1_old = HallState_1;*/
}
void HALL_CN2_ISR(){
    HallA_2_state = HallA_2.read();
    HallB_2_state = HallB_2.read();
 
    if(HallB_2_state == 1 && HallB_2_state_old == 0){
        HallR_2_state = 2*HallA_2_state - 1;
    }
    speed_count_2 -= HallR_2_state;
    HallA_2_state_old = HallA_2_state;
    HallB_2_state_old = HallB_2_state;
    
    /*****/
    /*HallA_2_state = HallA_2.read();
    HallB_2_state = HallB_2.read();
    
    if(HallA_2_state == 0 && HallB_2_state == 0)HallState_2 = 1;
    else if(HallA_2_state == 1 && HallB_2_state == 0)HallState_2 = 2;
    else if(HallA_2_state == 1 && HallB_2_state == 1)HallState_2 = 3;
    else if(HallA_2_state == 0 && HallB_2_state == 1)HallState_2 = 4;
    
    if(HallState_2-HallState_2_old == 1 || HallState_2-HallState_2_old == -3)speed_count_2--;
    else if(HallState_2-HallState_2_old ==-1 || HallState_2-HallState_2_old == 3)speed_count_2++;
    
    HallState_2_old = HallState_2;*/
}

/*void HALL_CN_ISR(){
//    pc.printf("CN\n");
    // Motor 1
    HallA_1_state = HallA_1.read();
    HallB_1_state = HallB_1.read();
    
    if(HallA_1_state == 0 && HallB_1_state == 0)HallState_1 = 1;
    else if(HallA_1_state == 1 && HallB_1_state == 0)HallState_1 = 2;
    else if(HallA_1_state == 1 && HallB_1_state == 1)HallState_1 = 3;
    else if(HallA_1_state == 0 && HallB_1_state == 1)HallState_1 = 4;
    
    if(HallState_1-HallState_1_old == 1 || HallState_1-HallState_1_old == -3)speed_count_1--;
    else if(HallState_1-HallState_1_old ==-1 || HallState_1-HallState_1_old == 3)speed_count_1++;
    
    HallState_1_old = HallState_1;
    
    // Motor 2
    HallA_2_state = HallA_2.read();
    HallB_2_state = HallB_2.read();
    
    if(HallA_2_state == 0 && HallB_2_state == 0)HallState_2 = 1;
    else if(HallA_2_state == 1 && HallB_2_state == 0)HallState_2 = 2;
    else if(HallA_2_state == 1 && HallB_2_state == 1)HallState_2 = 3;
    else if(HallA_2_state == 0 && HallB_2_state == 1)HallState_2 = 4;
    
    if(HallState_2-HallState_2_old == 1 || HallState_2-HallState_2_old == -3)speed_count_2--;
    else if(HallState_2-HallState_2_old ==-1 || HallState_2-HallState_2_old == 3)speed_count_2++;
    
    HallState_2_old = HallState_2;
    // motor1
    HallA_1_state = HallA_1.read();
    HallB_1_state = HallB_1.read();
    
    if((HallA_1_state != HallA_1_state_old) || (HallB_1_state != HallB_1_state_old)){//have changed
        ///code for state determination///
        if(HallB_1_state == 1 && HallB_1_state_old == 0){
            HallR_1_state = 2*HallA_1_state - 1;
        }
        speed_count_1 -= HallR_1_state;
        HallA_1_state_old = HallA_1_state;
        HallB_1_state_old = HallB_1_state;
    }
    
    
    // motor2
    HallA_2_state = HallA_2.read();
    HallB_2_state = HallB_2.read();
 
    if((HallA_2_state != HallA_2_state_old) || (HallB_2_state != HallB_2_state_old)){//have changed
        ///code for state determination///
        if(HallB_2_state == 1 && HallB_2_state_old == 0){
            HallR_2_state = 2*HallA_2_state - 1;
        }
        speed_count_2 -= HallR_2_state;
        HallA_2_state_old = HallA_2_state;
        HallB_2_state_old = HallB_2_state;
    }
}*/

void Rx_IT_ISR(){
// Stop if buffer full
    static char tune = 0;
        
    while(pc.readable()){
    
        tune = pc.getc();
        
        switch(tune){
        case 'n':
            PID_TUNE = 0;
            rotation_speed_ref_1 = 0;
            rotation_speed_ref_2 = 0;
            break;
        case 'y':
            PID_TUNE = 1;
            rotation_speed_ref_1 += (rotation_speed_ref_1 >= 300 ? 0 : 100);
            rotation_speed_ref_2 = 0;
            break;
        case 't':        
            PID_TUNE = 2;
            rotation_speed_ref_1 = 0;
            rotation_speed_ref_2 += (rotation_speed_ref_2 >= 300 ? 0 : 100);        
            break;
        case 'p':
            Kp1 += 0.00002;
            a1 = Kp1 + 0.5*Ki1*Ts + Kd1*Fs;
            b1 = -Kp1 + 0.5*Ki1*Ts - 2*Kd1*Fs;
            c1 = Kd1*Fs;
            err1_1 = 0;
            err1_2 = 0;
            break;
        case 'o':
            Kp1 -= 0.00002;
            a1 = Kp1 + 0.5*Ki1*Ts + Kd1*Fs;
            b1 = -Kp1 + 0.5*Ki1*Ts - 2*Kd1*Fs;
            c1 = Kd1*Fs;
            err1_1 = 0;
            err1_2 = 0;
            break;
        case 'i':
            Ki1 += 0.00002;
            a1 = Kp1 + 0.5*Ki1*Ts + Kd1*Fs;
            b1 = -Kp1 + 0.5*Ki1*Ts - 2*Kd1*Fs;
            c1 = Kd1*Fs;
            err1_1 = 0;
            err1_2 = 0;
            break;
        case 'u':
            Ki1 -= 0.00002;
            a1 = Kp1 + 0.5*Ki1*Ts + Kd1*Fs;
            b1 = -Kp1 + 0.5*Ki1*Ts - 2*Kd1*Fs;
            c1 = Kd1*Fs;
            err1_1 = 0;
            err1_2 = 0;
            break;
        case 'r':
            Kp2 += 0.00002;
            a2 = Kp2 + 0.5*Ki2*Ts + Kd2*Fs;
            b2 = -Kp2 + 0.5*Ki2*Ts - 2*Kd2*Fs;
            c2 = Kd2*Fs;
            err2_1 = 0;
            err2_2 = 0;
            break;
        case 'e':
            Kp2 -= 0.00002;
            a2 = Kp2 + 0.5*Ki2*Ts + Kd2*Fs;
            b2 = -Kp2 + 0.5*Ki2*Ts - 2*Kd2*Fs;
            c2 = Kd2*Fs;
            err2_1 = 0;
            err2_2 = 0;
            break;
        case 'w':
            Ki2 += 0.00002;
            a2 = Kp2 + 0.5*Ki2*Ts + Kd2*Fs;
            b2 = -Kp2 + 0.5*Ki2*Ts - 2*Kd2*Fs;
            c2 = Kd2*Fs;
            err2_1 = 0;
            err2_2 = 0;
            break;
        case 'q':
            Ki2 -= 0.00002;
            a2 = Kp2 + 0.5*Ki2*Ts + Kd2*Fs;
            b2 = -Kp2 + 0.5*Ki2*Ts - 2*Kd2*Fs;
            c2 = Kd2*Fs;
            err2_1 = 0;
            err2_2 = 0;
            break;
        }
    }
    return;
}

void timer0_ISR(){
// LED
    // D1 & D2 Blink Alternately
    LD1e = LD2e;
    LD2e = !LD2e;
    angle = angle + (angle < 90 ? 15 : 0);
    servo_duty = 0.069 +(0.088/180)*angle; 
    /////////////////////////    
    if(servo_duty > 0.113f)servo_duty = 0.113;
    else if(servo_duty < 0.025f)servo_duty = 0.025;    
    servo_cmd.write(servo_duty);
// Serial
    pc.printf("%.2f %.2f\n",err1_0 ,err2_0);
/*    if(PID_TUNE == 1){
        pc.printf("1 %.5f %.5f %.2f %f\n", Kp1, Ki1, err1_0, PI_out_1);
//        pc.printf("%.2f %.2f\n", rotation_speed_1, PI_out_1);
    }else if(PID_TUNE == 2){
        pc.printf("2 %.5f %.5f %.2f %f\n", Kp2, Ki2, err2_0, PI_out_2);
//        pc.printf("%.2f %.2f\n", rotation_speed_2, PI_out_2);
    }*/
}

void timer1_ISR(){
// Control Input
//    angle = 0;
    rotation_speed_ref_1 = 150;
    rotation_speed_ref_2 = -80;

// servo motor
    ///code for sevo motor///    
    /*angle = angle + (angle < 90 ? 0.15 : 0);
    servo_duty = 0.069 +(0.088/180)*angle; 
    /////////////////////////    
    if(servo_duty > 0.113f)servo_duty = 0.113;
    else if(servo_duty < 0.025f)servo_duty = 0.025;    
    servo_cmd.write(servo_duty);*/
// motor1
    rotation_speed_1 = speed_count_1 * 3.4482758;//17.2413793;   //unit: rpm 100.0f / 12.0f * 60.0f / 29.0f
    speed_count_1 = 0;
 
    ///PI controller for motor1///
    err1_0 = rotation_speed_ref_1 - rotation_speed_1;
    if(err1_0 > 0){
        PI_out_1 = PI_out_1 + 0.001;
    }
    else if(err1_0 < 0){
        PI_out_1 = PI_out_1 - 0.001;
    }
//    PI_out_1 += (a1*err1_0 + b1*err1_1 + c1*err1_2);
//    err1_1 = err1_0;
//    err1_2 = err1_1;
    
    //////////////////////////////
    
    if(PI_out_1 > 0.5){
        PI_out_1 = 0.5;
    }else if(PI_out_1 < -0.5){
        PI_out_1 = -0.5;
    }
    pwm1_duty = PI_out_1 + 0.5;
    pwm1.write(pwm1_duty);
    TIM1->CCER |= 0x4;
 
//motor2
    rotation_speed_2 = speed_count_2 * 3.4482758;//17.2413793;   //unit: rpm
    speed_count_2 = 0;
 
    ///PI controller for motor2///
    err2_0 = rotation_speed_ref_2 - rotation_speed_2;
    if(err2_0 > 0){
        PI_out_2 = PI_out_2 + 0.001;   
    }
    else if(err2_0 < 0){
        PI_out_2 = PI_out_2 - 0.001;   
    }
//    PI_out_2 += (a2*err2_0 + b2*err2_1 + c2*err2_2);
//    err2_1 = err2_0;
//    err2_2 = err2_1;    
    
    //////////////////////////////
    
    if(PI_out_2 > 0.5){
        PI_out_2 = 0.5;
    }else if(PI_out_2 < -0.5){
        PI_out_2 = -0.5;
    }
    pwm2_duty = PI_out_2 + 0.5;
    pwm2.write(pwm2_duty);
    TIM1->CCER |= 0x40;
}


