#include "mbed.h"
#include "EPD_GDE021A1.h"
#include "dht22.h"

#define EPD_CS       PA_15
#define EPD_DC       PB_11
#define EPD_RESET    PB_2
#define EPD_BUSY     PA_8
#define EPD_POWER    PB_10
#define EPD_SPI_MOSI PB_5
#define EPD_SPI_MISO PB_4
#define EPD_SPI_SCK  PB_3
#define PTB18        PC_15

EPD_GDE021A1 epd(EPD_CS, EPD_DC, EPD_RESET, EPD_BUSY, EPD_POWER, EPD_SPI_MOSI, EPD_SPI_MISO, EPD_SPI_SCK);

DigitalOut led1(LED1);
DigitalOut led2(LED2);

Serial host(USBTX, USBRX);
DHT22 dht22(PTB18);

//width 48
//height 26
static uint8_t Battery_img[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0xfe, 0xff, 0xff, 0xff, 0xff, 0x0f, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x0c, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x18, 
0xfe, 0xff, 0xff, 0x3f, 0x10, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0x10, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0x10, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0xff, 0x39, 
0xfe, 0xff, 0xff, 0x3f, 0x10, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0x10, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0x10, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x18, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x0c, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x0c, 
0xfe, 0xff, 0xff, 0xff, 0xff, 0x0f, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

int main()
{
    led1 = 1;
    DHT22_data_t dht22_data;
    
    epd.Clear(EPD_COLOR_WHITE);  
    epd.DisplayStringAtLine(5, (uint8_t*)"MBED", CENTER_MODE);
    epd.DisplayStringAtLine(3, (uint8_t*)"Epaper display", LEFT_MODE);
    epd.DisplayStringAtLine(2, (uint8_t*)"demo", LEFT_MODE);
    epd.DrawImage(130, 0, 48, 26, Battery_img);
    epd.DrawRect(50, 4, 60, 4);
    epd.RefreshDisplay();
    wait(1);
  
    while(1) {
        led1 = 1;
        wait_ms(500);
        
        dht22.read(&dht22_data);
        
        float temperature = dht22_data.temp / 10.0f;
        float humidity = dht22_data.humidity / 10.0f;
        
        host.printf("Temperature: %2.2f    Humidity: %2.2f%%\r\n", temperature, humidity);
        wait_ms(500);
        
        char str1[5], str2[5];
        sprintf(str1, "%.1f", temperature);
        sprintf(str2, "%.1f", humidity);
        
        led1 = 0;
        led2 = 1;
        
        epd.Clear(EPD_COLOR_WHITE);  
        epd.DisplayStringAtLine(5, (uint8_t*)"Adrien", CENTER_MODE);
        epd.DisplayStringAtLine(3, (uint8_t*)"Temperature: ", LEFT_MODE);
        epd.DisplayStringAtLine(3, (uint8_t*)str1, RIGHT_MODE);
        epd.DisplayStringAtLine(2, (uint8_t*)"Humidity: ", LEFT_MODE);
        epd.DisplayStringAtLine(2, (uint8_t*)str2, RIGHT_MODE);
        epd.RefreshDisplay();
        
        led2 = 0;
        wait_ms(500);
    }
}
