#ifndef REPEATER_H
#define REPEATER_H

struct Repeater {
    double time, lastTime, step;
    
    Repeater (double s) {
        lastTime = time = 1.0 * clock() / CLOCKS_PER_SEC;
        step = s;
    }
    
    bool check () {
        update();
        if (time >= lastTime + step) {
            lastTime = time;
            return true;    
        } else {
            return false;
        }
    }
    void update () {
        time = 1.0 * clock() / CLOCKS_PER_SEC;
    }
};

#endif