#include "mbed.h"                           // Incluide the main Mbed library   
#include "C12832_lcd.h"                     // Include the LCD library
#include <EthernetInterface.h>              // Include the Ethernet Library 
#include "mbed_debug.h"                     // Include the Mbed debug library

DigitalOut      RedLed (p23);           
DigitalOut      BlueLed (p25);              // Declare digital outs for the RGB located on the application board
DigitalOut      GreenLed (p24);

C12832_LCD lcd;                             // Declare object called LCD from the C12832_LCD Class

Ticker StrobeRoutine;                       // Declare ticker object called StrobeRoutine

DigitalOut SecurityLightFront (LED1);       // Declare object and define pin as a digital output
DigitalOut SecurityLightBack (LED2);        // Declare object and define pin as a digital output
DigitalOut IndoorStrobe (LED4);             // Declare object and define pin as a digital output

InterruptIn Button (p13);                   // Declare button to send data
InterruptIn Reset (p14);                    // Declare object and define pin as an input with interrupt functionality
InterruptIn FrontDoorPIR(p21);              // Declare object and define pin as an input with interrupt functionality
InterruptIn BackDoorPIR(p22);               // Declare object and define pin as an input with interrupt functionality

#define Success 0
#define Failure -1                          // Defining terms to logical values in order to
#define On Success                          // make programming more intuitive later on
#define Off 1                               


int FrontDoorCounter = 0;                   // Creating counter variables to store the 
int BackDoorCounter = 0;                    // number of times the sensor has been activated

bool StartProcessing = 0;               
bool Setup = 1;                             
bool FrontDoorStatus =0;                    //  Declaring various varibales and setting their starting values
bool BackDoorStatus = 0;
bool ResetButtonStatus = 0;


void Flash()                                //  Declare function called flash
{
    IndoorStrobe=!IndoorStrobe;             //  Alternate the indoor strobe state
}

void ISR_BackDoorPIR()                      //  Interrupt service routine (ISR) to 
{                                           //  run when back door PIR is activated
    BackDoorStatus = 1;                     //  ISR creates and sets variable to logic 1
}

void ISR_FrontDoorPIR()                     //  ISR to run when front door PIR is activated
{
    FrontDoorStatus = 1;                    //  ISR creates and sets variable to logic 1
}

void ISR_Reset()                            //  ISR to run when reset button is activated
{
    ResetButtonStatus = 1;                  // ISR creates and sets variable to logic 1
}

void ISR_Data (void)                        // ISR to run when data transfer is required
{
    StartProcessing = 1;                    // ISR creates and sets variable to logic 1
}   



int main()
{    
    RedLed = BlueLed = GreenLed = 1;                            // Using inverse logic on RBG LED sets to off
    lcd.cls ();
    lcd.locate (0,0);                                           // Print text
    lcd.printf("Starting");
  
    int ConnectionStatus = 0;                                   //  Creating variable to hold connection status values when returned
    
    EthernetInterface       myEthernetInterface;                //  Creating objects from the ethernet and TCP classes
    TCPSocketConnection     myTCPSocketConnection;
        
    ConnectionStatus = myEthernetInterface.init();              //  Initialise the interface and stores return value in ConnectionStatus   
    ConnectionStatus = myEthernetInterface.connect(10000);      //  Bring up the interface and store return value in ConnectionStatus
 
    lcd.cls ();
    lcd.locate (0,10);
    
    if (ConnectionStatus == Failure){                           
        lcd.printf("Connection Error");                         //  Displaying the connection status of the ethernetInterface
        wait(2);                                                //  if a failure value is returned for the ".init" or ".connect" functions
    }                                                           //  then connecton error is displayed on the LCD else Connected is displayed.
    else {
         lcd.printf("Connected");                               //  If Connection is successful connected is displayed
         wait(2);                                               //  Wait to make message visible to user
    }
    
    int TramissionStatus;                                       // Variable created to store socket connection status

    const char*    GroupName = "Group 7";
    const char*    ClientIPAddress = myEthernetInterface.getIPAddress ();           // Data required for trasnsmission is defined
    const char*    ClientMacAddress = myEthernetInterface.getMACAddress ();     
    const char*    ServerIPAddress = "192.168.0.21";
    const int      PortNumber = 29;
    

    TramissionStatus = myTCPSocketConnection.connect (ServerIPAddress,PortNumber);  //  Connect the TCP socket to the server and store result in variable
    lcd.locate (0,10);
    lcd.printf("Transmission: %d",TramissionStatus);                                // Result of socket conection printed to LCD
    
    if (TramissionStatus == Success)                                                //  Green LED activated if connection is successful
    {
        GreenLed = On;
    }    
       
    Button.rise (&ISR_Data);                         // Interrupt for data transfe to server
    Button.enable_irq ();
    FrontDoorPIR.rise(&ISR_FrontDoorPIR);            // Interrupt for Front Door PIR detection on the rise of the signal and calls the ISR
    BackDoorPIR.rise(&ISR_BackDoorPIR);              // Interrupt for Back Door PIR detection on the rise of the signal and calls the ISR
    Reset.rise(&ISR_Reset);                          // Interrupt for Reset button activation on the rise of the signal and calls the ISR
    
    
       while(1)
       {
            if (Setup == 1)                                     //  Statement activated only on start up or reset
            {
                IndoorStrobe = 0;                                 
                SecurityLightFront = 0;                         //  Set lights initial state to off 
                SecurityLightBack = 0;
                lcd.cls();                                      //  Clear LCD
                lcd.locate(0,0);                                //  Set text position
                lcd.printf ("System Active");                   //  Print text to LCD
                Setup = 0;                                      //  Clear Setup variable so statement does not run again
                goto Start;                                     //  Exits the if statement
            }
            
            Start:
            
            if (FrontDoorStatus ==1)                            //  If statement acitvated by Front Door PIR activation
            {
                FrontDoorCounter ++;                            //  Incease counter value by 1 to keep record of total activations
                lcd.locate (0,0);
                lcd.printf("                              ");   //  Clear the the screen except for the status of the other PIR activation
                lcd.locate (0,20);
                lcd.printf("                              ");
                lcd.locate(0,20);                               //  Set text position
                lcd.printf("Intruder at front door!!");         //  Print text to LCD
                StrobeRoutine.attach(&Flash,1);                 //  Attach the StrobeRoutine object to the flash function to flash the LED at a set frequency
                SecurityLightBack = 1;                          //  Turn on security light
                SecurityLightFront = 1;                         //  Turn on security light
                FrontDoorStatus = 0;                            //  Reset variable so the if statement doesnt run repeatedly
            }
            
            if (BackDoorStatus == 1)                            //  If statement acitvated by Front Door PIR activation
            {
                BackDoorCounter ++;                             //  Incease counter value by 1 to keep record of total activations
                lcd.locate (0,0);
                lcd.printf("                              ");   //  Clear the the screen except for the status of the other PIR activation
                lcd.locate(0,10);
                lcd.printf("                          ");
                lcd.locate(0,10);                               //  Set text position
                lcd.printf("Intruder at Back door!! ");         //  Print text to LCD
                StrobeRoutine.attach(&Flash,1);                 //  Attach the stroberoutine object to the flash function to flash the LED at a set frequency
                SecurityLightBack = 1;                          //  Turn on security light
                SecurityLightFront = 1;                         //  Turn on security light
                BackDoorStatus = 0;
            }    
            
            if (ResetButtonStatus ==1)
            {
                StrobeRoutine.detach();                         //  Turn off the indoor StrobeRoutine
                IndoorStrobe = 0;                               //  Set the Indoor LED to off(Inverse logic)
                SecurityLightBack = 0;                          //  Set the Outdoor security lights to off
                SecurityLightFront = 0;                         //  Set the Outdoor security lights to off
                lcd.cls();                                      //  Clear LCD display
                lcd.locate(0,0);                                //  Set text position
                lcd.printf("System Reset");                     //  Print text to LCD
                wait (3);                                       //  Wait to allow system stability
                ResetButtonStatus = 0;                            
                Setup = 1;                                      //  Run the setup function and return system to active status
                                                    
            } 
            
            if (StartProcessing) 
            {  
                BlueLed = On;
                wait (0.5);
                char    *ReceiveBuffer = new char [256];
                char    *SendBuffer = new char [256];
                int     FD = FrontDoorCounter;
                int     BD = BackDoorCounter;                   //  variables declared including type and size
                int     WrittenByteCount = 0;
                int     ReadByteCount = 0;
                char    ResultBuffer [10];
                char    *Information = new char [100];

                strcat (Information, "Front Door: ");
                sprintf(ResultBuffer, "%d ", FD);
                strcat (Information, ResultBuffer);             // Values to be sent to the database are converted to string format
                strcat (Information, "Back Door: ");
                sprintf(ResultBuffer, "%d", BD);
                strcat (Information, ResultBuffer);

                strcat (SendBuffer, GroupName);
                strcat (SendBuffer, "|");
                strcat (SendBuffer, ClientMacAddress);
                strcat (SendBuffer, "|");                       //  Format and sequence of information to be sent
                strcat (SendBuffer, ClientIPAddress);
                strcat (SendBuffer, "|");
                strcat (SendBuffer, Information);
                strcat (SendBuffer, "\r\n"); 

                debug (SendBuffer);
                
                WrittenByteCount = myTCPSocketConnection.send_all (SendBuffer, strlen (SendBuffer));    //  Send data
                
                lcd.cls();
                lcd.locate (10,10);                             //  Print byte value of data sent to LCD
                lcd.printf("Write: %d",WrittenByteCount);
                
                if (WrittenByteCount == Failure)
                {                                               //  LED to red if data sending failure
                     RedLed = On;                               //  doesnt reset StartProcessing so the loop repeats.
                }                                               //  ie it attempts to transfer the data again
                                        
                else 
                {                
                    ReadByteCount = myTCPSocketConnection.receive_all (ReceiveBuffer, strlen (ReceiveBuffer));
                    
                    lcd.locate (20,0);
                    lcd.printf("Read: %d",ReadByteCount);       //  Print the read return byte value from the server
                    if (ReadByteCount == Failure)
                    {
                        RedLed = On;
                    }
                    else 
                    {
                        StartProcessing = false;                //  If data transfer is successful reset variable to false
                    }                                           //  so data isnt sent again
                } 
                BlueLed = Off;     

                delete[] ReceiveBuffer;
                delete[] SendBuffer;
                wait(2);
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf ("System Active");                   //  Print text to LCD
            }                                                   //  End of If (StartProcessing)     
        }                                                       //  End of While
    }                                                           //  End of Main

