//                                                                               
//    This script modifies a font file which was generated with a tool by        
//    MikroElektronika - GLD Font Creator.                                       
//                                                                               
//    That tool creates the font data set for an embedded system from a Windows  
//    True Type font. The user is encouraged to ensure that the font used is     
//    properly licenses, or drawn from a source that does not have a license     
//    restriction.                                                               
//                                                                               
//    This script will read and then modify the file for a few specific purposes:
//      * <space>   character is redefined to set the width to 1/4 the height.   
//      * '0' - '9' characters are redefined to set the width equal to width('0')
//                  or to the user override value.                               
//                                                                               
//    And just because it can, it then improves upon the documentation in the    
//    resulting data structure.                                                  
//                                                                               
//    This script was created by Smartware Computing, and is provided 'as is'    
//    with no warranty or suitability of fitness for any purpose. Anyone may use 
//    or modify it subject to the agreement that:                                
//      * The Smartware copyright statement remains intact.                      
//      * Modifications for derivative use are clearly stated in this header.    
//                                                                               
//    Modifications from the original:                                           
//      * none.                                                                  
//                                                                               
// Script Activation:
//   ParseMikroeFont BPG_Arial20x20.h New_BPG_Arial20x20.h

//Font Generated by MikroElektronika GLCD Font Creator 1.2.0.0
//MikroElektrnika 2011 
//http://www.mikroe.com 

//GLCD FontName : BPG_Arial20x20
//GLCD FontSize : 20 x 20

const unsigned char BPG_Arial20x20[] = {
    // Font Info
    0x00,                   // Unknown #1
    0x00,                   // Unknown #2
    0x20,0x00,              // FirstChar
    0x7F,0x00,              // LastChar
    0x14,                   // FontHeight
    0x00,                   // Unknown #3
    // Directory of Chars  [Width] [Offset-L] [Offset-M] [Offset-H]
    0x05,0x88,0x01,0x00,    // 0x20 ' ' 
    0x04,0x9C,0x01,0x00,    // 0x21 '!' 
    0x06,0xB0,0x01,0x00,    // 0x22 '"' 
    0x0B,0xC4,0x01,0x00,    // 0x23 '#' 
    0x0B,0xEC,0x01,0x00,    // 0x24 '$' 
    0x11,0x14,0x02,0x00,    // 0x25 '%' 
    0x0D,0x50,0x02,0x00,    // 0x26 '&' 
    0x03,0x78,0x02,0x00,    // 0x27 ''' 
    0x06,0x8C,0x02,0x00,    // 0x28 '(' 
    0x06,0xA0,0x02,0x00,    // 0x29 ')' 
    0x07,0xB4,0x02,0x00,    // 0x2A '*' 
    0x0B,0xC8,0x02,0x00,    // 0x2B '+' 
    0x04,0xF0,0x02,0x00,    // 0x2C ',' 
    0x06,0x04,0x03,0x00,    // 0x2D '-' 
    0x04,0x18,0x03,0x00,    // 0x2E '.' 
    0x06,0x2C,0x03,0x00,    // 0x2F '/' 
    0x0B,0x40,0x03,0x00,    // 0x30 '0' 
    0x0B,0x68,0x03,0x00,    // 0x31 '1' 
    0x0B,0x90,0x03,0x00,    // 0x32 '2' 
    0x0B,0xB8,0x03,0x00,    // 0x33 '3' 
    0x0B,0xE0,0x03,0x00,    // 0x34 '4' 
    0x0B,0x08,0x04,0x00,    // 0x35 '5' 
    0x0B,0x30,0x04,0x00,    // 0x36 '6' 
    0x0B,0x58,0x04,0x00,    // 0x37 '7' 
    0x0B,0x80,0x04,0x00,    // 0x38 '8' 
    0x0B,0xA8,0x04,0x00,    // 0x39 '9' 
    0x04,0xD0,0x04,0x00,    // 0x3A ':' 
    0x04,0xE4,0x04,0x00,    // 0x3B ';' 
    0x0B,0xF8,0x04,0x00,    // 0x3C '<' 
    0x0B,0x20,0x05,0x00,    // 0x3D '=' 
    0x0B,0x48,0x05,0x00,    // 0x3E '>' 
    0x0B,0x70,0x05,0x00,    // 0x3F '?' 
    0x14,0x98,0x05,0x00,    // 0x40 '@' 
    0x0E,0xD4,0x05,0x00,    // 0x41 'A' 
    0x0D,0xFC,0x05,0x00,    // 0x42 'B' 
    0x0E,0x24,0x06,0x00,    // 0x43 'C' 
    0x0E,0x4C,0x06,0x00,    // 0x44 'D' 
    0x0D,0x74,0x06,0x00,    // 0x45 'E' 
    0x0C,0x9C,0x06,0x00,    // 0x46 'F' 
    0x0F,0xC4,0x06,0x00,    // 0x47 'G' 
    0x0D,0xEC,0x06,0x00,    // 0x48 'H' 
    0x04,0x14,0x07,0x00,    // 0x49 'I' 
    0x09,0x28,0x07,0x00,    // 0x4A 'J' 
    0x0E,0x50,0x07,0x00,    // 0x4B 'K' 
    0x0B,0x78,0x07,0x00,    // 0x4C 'L' 
    0x10,0xA0,0x07,0x00,    // 0x4D 'M' 
    0x0D,0xC8,0x07,0x00,    // 0x4E 'N' 
    0x0F,0xF0,0x07,0x00,    // 0x4F 'O' 
    0x0D,0x18,0x08,0x00,    // 0x50 'P' 
    0x0F,0x40,0x08,0x00,    // 0x51 'Q' 
    0x0F,0x68,0x08,0x00,    // 0x52 'R' 
    0x0D,0x90,0x08,0x00,    // 0x53 'S' 
    0x0C,0xB8,0x08,0x00,    // 0x54 'T' 
    0x0D,0xE0,0x08,0x00,    // 0x55 'U' 
    0x0E,0x08,0x09,0x00,    // 0x56 'V' 
    0x13,0x30,0x09,0x00,    // 0x57 'W' 
    0x0E,0x6C,0x09,0x00,    // 0x58 'X' 
    0x0D,0x94,0x09,0x00,    // 0x59 'Y' 
    0x0C,0xBC,0x09,0x00,    // 0x5A 'Z' 
    0x06,0xE4,0x09,0x00,    // 0x5B '[' 
    0x06,0xF8,0x09,0x00,    // 0x5C '\\' 
    0x04,0x0C,0x0A,0x00,    // 0x5D ']' 
    0x09,0x20,0x0A,0x00,    // 0x5E '^' 
    0x0C,0x48,0x0A,0x00,    // 0x5F '_' 
    0x05,0x70,0x0A,0x00,    // 0x60 '`' 
    0x0B,0x84,0x0A,0x00,    // 0x61 'a' 
    0x0B,0xAC,0x0A,0x00,    // 0x62 'b' 
    0x0A,0xD4,0x0A,0x00,    // 0x63 'c' 
    0x0A,0xFC,0x0A,0x00,    // 0x64 'd' 
    0x0B,0x24,0x0B,0x00,    // 0x65 'e' 
    0x06,0x4C,0x0B,0x00,    // 0x66 'f' 
    0x0A,0x60,0x0B,0x00,    // 0x67 'g' 
    0x0A,0x88,0x0B,0x00,    // 0x68 'h' 
    0x03,0xB0,0x0B,0x00,    // 0x69 'i' 
    0x03,0xC4,0x0B,0x00,    // 0x6A 'j' 
    0x0A,0xD8,0x0B,0x00,    // 0x6B 'k' 
    0x03,0x00,0x0C,0x00,    // 0x6C 'l' 
    0x10,0x14,0x0C,0x00,    // 0x6D 'm' 
    0x0A,0x3C,0x0C,0x00,    // 0x6E 'n' 
    0x0B,0x64,0x0C,0x00,    // 0x6F 'o' 
    0x0A,0x8C,0x0C,0x00,    // 0x70 'p' 
    0x0A,0xB4,0x0C,0x00,    // 0x71 'q' 
    0x07,0xDC,0x0C,0x00,    // 0x72 'r' 
    0x0A,0xF0,0x0C,0x00,    // 0x73 's' 
    0x06,0x18,0x0D,0x00,    // 0x74 't' 
    0x0A,0x2C,0x0D,0x00,    // 0x75 'u' 
    0x0A,0x54,0x0D,0x00,    // 0x76 'v' 
    0x0F,0x7C,0x0D,0x00,    // 0x77 'w' 
    0x0A,0xA4,0x0D,0x00,    // 0x78 'x' 
    0x0A,0xCC,0x0D,0x00,    // 0x79 'y' 
    0x0A,0xF4,0x0D,0x00,    // 0x7A 'z' 
    0x07,0x1C,0x0E,0x00,    // 0x7B '{' 
    0x04,0x30,0x0E,0x00,    // 0x7C '|' 
    0x06,0x44,0x0E,0x00,    // 0x7D '}' 
    0x0B,0x58,0x0E,0x00,    // 0x7E '~' 
    0x06,0x80,0x0E,0x00,    // 0x7F '<non-printable>' 
    // Chars Bitstream
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x20 ' '
    0x00,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x00,0x00,0x0C,0x0C,0x00,0x00,0x00,0x00,  // 0x21 '!'
    0x00,0x36,0x36,0x36,0x26,0x26,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x22 '"'
    0x00,0x00,0x30,0x02,0x10,0x02,0x10,0x03,0x18,0x03,0xFF,0x07,0xFF,0x07,0x08,0x01,0x88,0x01,0x8C,0x01,0xFF,0x07,0xFF,0x07,0x84,0x00,0xC4,0x00,0xC6,0x00,0xC6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x23 '#'
    0x60,0x00,0xFC,0x01,0xAC,0x03,0x26,0x03,0x26,0x00,0x26,0x00,0x2E,0x00,0x7C,0x00,0xF0,0x01,0xA0,0x03,0x20,0x07,0x20,0x06,0x26,0x06,0x26,0x03,0xAC,0x03,0xF8,0x01,0x20,0x00,0x20,0x00,0x00,0x00,0x00,0x00,  // 0x24 '$'
    0x00,0x00,0x00,0x7C,0x30,0x00,0x44,0x10,0x00,0xC6,0x18,0x00,0xC6,0x08,0x00,0xC6,0x0C,0x00,0x46,0x04,0x00,0x7C,0x06,0x00,0x18,0x02,0x00,0x00,0xF3,0x00,0x00,0x99,0x01,0x80,0x19,0x01,0x80,0x18,0x01,0xC0,0x18,0x01,0x40,0x98,0x01,0x60,0xF0,0x00,0x30,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x25 '%'
    0x00,0x00,0xF0,0x01,0x98,0x03,0x18,0x03,0x18,0x03,0x98,0x03,0xF0,0x01,0x70,0x00,0xF8,0x00,0xCC,0x0D,0x86,0x0D,0x06,0x0F,0x06,0x06,0x0E,0x0F,0x9C,0x1F,0xF8,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x26 '&'
    0x00,0x06,0x06,0x06,0x06,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x27 '''
    0x00,0x30,0x10,0x18,0x08,0x0C,0x0C,0x04,0x06,0x06,0x06,0x06,0x06,0x04,0x0C,0x0C,0x08,0x18,0x10,0x30,  // 0x28 '('
    0x00,0x04,0x0C,0x08,0x18,0x10,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x10,0x18,0x08,0x0C,0x04,  // 0x29 ')'
    0x00,0x18,0x5A,0x7E,0x18,0x3C,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x2A '*'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xFE,0x07,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x2B '+'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x0C,0x08,0x08,0x04,0x00,  // 0x2C ','
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x2D '-'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x0C,0x00,0x00,0x00,0x00,  // 0x2E '.'
    0x00,0x30,0x10,0x10,0x18,0x08,0x08,0x0C,0x0C,0x04,0x04,0x06,0x06,0x02,0x03,0x03,0x00,0x00,0x00,0x00,  // 0x2F '/'
    0x00,0x00,0xF8,0x00,0xDC,0x01,0x0C,0x03,0x06,0x03,0x06,0x02,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x02,0x06,0x03,0x0C,0x03,0x9C,0x01,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x30 '0'
    0x00,0x00,0xC0,0x00,0xE0,0x00,0xF0,0x00,0xF8,0x00,0xCC,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x31 '1'
    0x00,0x00,0xF8,0x00,0x9C,0x03,0x06,0x03,0x06,0x06,0x00,0x06,0x00,0x03,0x00,0x03,0x80,0x01,0xC0,0x00,0x70,0x00,0x38,0x00,0x1C,0x00,0x0E,0x00,0xFE,0x07,0xFE,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x32 '2'
    0x00,0x00,0xF8,0x00,0xDC,0x01,0x0E,0x03,0x06,0x03,0x00,0x03,0x80,0x03,0xE0,0x01,0xE0,0x01,0x00,0x03,0x00,0x06,0x00,0x06,0x06,0x06,0x06,0x03,0x9C,0x03,0xF8,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x33 '3'
    0x00,0x00,0x80,0x01,0xC0,0x01,0xE0,0x01,0xA0,0x01,0xB0,0x01,0x98,0x01,0x88,0x01,0x8C,0x01,0x86,0x01,0x83,0x01,0xFF,0x07,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x34 '4'
    0x00,0x00,0xF8,0x03,0xFC,0x03,0x0C,0x00,0x0C,0x00,0x0C,0x00,0xF4,0x00,0xFE,0x03,0x06,0x03,0x00,0x06,0x00,0x06,0x00,0x06,0x06,0x06,0x06,0x03,0x9C,0x03,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x35 '5'
    0x00,0x00,0xF0,0x01,0x98,0x03,0x0C,0x03,0x06,0x02,0x06,0x00,0xE6,0x00,0xFE,0x01,0x0E,0x03,0x06,0x07,0x06,0x06,0x06,0x06,0x06,0x06,0x0C,0x03,0x9C,0x03,0xF8,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x36 '6'
    0x00,0x00,0xFE,0x07,0xFE,0x07,0x00,0x03,0x80,0x01,0xC0,0x01,0xC0,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x37 '7'
    0x00,0x00,0xF8,0x00,0xDC,0x01,0x0C,0x03,0x06,0x03,0x04,0x03,0x0C,0x03,0xF8,0x01,0xFC,0x01,0x0E,0x03,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x03,0x9C,0x03,0xF8,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x38 '8'
    0x00,0x00,0xF8,0x00,0xDC,0x01,0x0E,0x03,0x06,0x02,0x06,0x06,0x06,0x06,0x06,0x07,0x0E,0x07,0xFC,0x06,0x78,0x06,0x00,0x02,0x06,0x03,0x06,0x03,0x8C,0x01,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x39 '9'
    0x00,0x00,0x00,0x00,0x00,0x0C,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x0C,0x00,0x00,0x00,0x00,  // 0x3A ':'
    0x00,0x00,0x00,0x00,0x00,0x0C,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x0C,0x08,0x08,0x04,0x00,  // 0x3B ';'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0xC0,0x07,0xF0,0x00,0x3C,0x00,0x06,0x00,0x1E,0x00,0xF0,0x00,0xC0,0x03,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x3C '<'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x07,0xFE,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x07,0xFE,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x3D '='
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x3C,0x00,0xF0,0x00,0xC0,0x07,0x00,0x06,0x80,0x07,0xF0,0x01,0x3C,0x00,0x0E,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x3E '>'
    0x00,0x00,0xF8,0x01,0x9C,0x03,0x06,0x03,0x06,0x06,0x00,0x06,0x00,0x03,0x80,0x03,0xC0,0x01,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x3F '?'
    0x00,0x00,0x00,0x80,0x7F,0x00,0xE0,0xC1,0x01,0x70,0x00,0x03,0x18,0x00,0x06,0x08,0xCF,0x04,0x8C,0x5B,0x0C,0xC4,0x70,0x0C,0xC6,0x60,0x08,0x66,0x60,0x0C,0x66,0x60,0x0C,0x66,0x30,0x0C,0x66,0x30,0x06,0x66,0x38,0x03,0xC4,0xFF,0x01,0x8C,0xF7,0x00,0x18,0x00,0x0C,0x38,0x00,0x06,0xE0,0x80,0x03,0xC0,0xFF,0x00,  // 0x40 '@'
    0x00,0x00,0xC0,0x00,0xE0,0x01,0xE0,0x01,0xB0,0x01,0x30,0x03,0x30,0x03,0x18,0x06,0x18,0x06,0x0C,0x06,0xFC,0x0F,0x0C,0x0C,0x06,0x1C,0x06,0x18,0x06,0x18,0x03,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x41 'A'
    0x00,0x00,0xFC,0x03,0xFC,0x07,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0xFC,0x07,0xFC,0x07,0x0C,0x0C,0x0C,0x18,0x0C,0x18,0x0C,0x18,0x0C,0x1C,0xFC,0x0F,0xFC,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x42 'B'
    0x00,0x00,0xE0,0x07,0x78,0x1E,0x1C,0x18,0x0C,0x30,0x0E,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x0C,0x30,0x0C,0x30,0x1C,0x18,0x78,0x1E,0xE0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x43 'C'
    0x00,0x00,0xFC,0x03,0xFC,0x0F,0x0C,0x1C,0x0C,0x18,0x0C,0x30,0x0C,0x30,0x0C,0x30,0x0C,0x30,0x0C,0x30,0x0C,0x30,0x0C,0x30,0x0C,0x18,0x0C,0x1C,0xFC,0x0F,0xFC,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x44 'D'
    0x00,0x00,0xFC,0x1F,0xFC,0x1F,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0xFC,0x0F,0xFC,0x0F,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0xFC,0x1F,0xFC,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x45 'E'
    0x00,0x00,0xFC,0x0F,0xFC,0x0F,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0xFC,0x07,0xFC,0x07,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x46 'F'
    0x00,0x00,0xE0,0x0F,0x78,0x1C,0x18,0x30,0x0C,0x60,0x0C,0x20,0x06,0x00,0x06,0x00,0x06,0x7E,0x06,0x7E,0x06,0x60,0x0C,0x60,0x0C,0x60,0x18,0x70,0xF0,0x3F,0xE0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x47 'G'
    0x00,0x00,0x0C,0x18,0x0C,0x18,0x0C,0x18,0x0C,0x18,0x0C,0x18,0x0C,0x18,0xFC,0x1F,0xFC,0x1F,0x0C,0x18,0x0C,0x18,0x0C,0x18,0x0C,0x18,0x0C,0x18,0x0C,0x18,0x0C,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x48 'H'
    0x00,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x00,0x00,0x00,0x00,  // 0x49 'I'
    0x00,0x00,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x86,0x01,0x86,0x01,0xFE,0x00,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x4A 'J'
    0x00,0x00,0x0C,0x1C,0x0C,0x0E,0x0C,0x07,0x8C,0x03,0xCC,0x01,0xEC,0x00,0xFC,0x00,0xFC,0x00,0x9C,0x01,0x8C,0x03,0x0C,0x07,0x0C,0x06,0x0C,0x0C,0x0C,0x1C,0x0C,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x4B 'K'
    0x00,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0xFC,0x07,0xFC,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x4C 'L'
    0x00,0x00,0x1C,0xE0,0x1C,0xE0,0x14,0xF0,0x34,0xF0,0x34,0xD0,0x24,0xD8,0x64,0xD8,0x64,0xC8,0x44,0xCC,0xC4,0xCC,0xC4,0xC4,0x84,0xC6,0x84,0xC3,0x84,0xC3,0x04,0xC3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x4D 'M'
    0x00,0x00,0x0C,0x10,0x1C,0x10,0x1C,0x10,0x3C,0x10,0x7C,0x10,0x6C,0x10,0xCC,0x10,0xCC,0x11,0x8C,0x11,0x0C,0x13,0x0C,0x17,0x0C,0x16,0x0C,0x1C,0x0C,0x1C,0x0C,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x4E 'N'
    0x00,0x00,0xE0,0x0F,0x78,0x1E,0x1C,0x38,0x0C,0x70,0x0E,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x0E,0x60,0x0C,0x70,0x18,0x38,0x78,0x1E,0xE0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x4F 'O'
    0x00,0x00,0xFC,0x07,0xFC,0x0F,0x0C,0x1C,0x0C,0x18,0x0C,0x18,0x0C,0x18,0x0C,0x1C,0xFC,0x0F,0xFC,0x03,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x50 'P'
    0x00,0x00,0xE0,0x0F,0x78,0x1E,0x1C,0x38,0x0C,0x30,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x0C,0x33,0x1C,0x3E,0x78,0x1E,0xE0,0x77,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x51 'Q'
    0x00,0x00,0xFC,0x0F,0xFC,0x1F,0x0C,0x18,0x0C,0x30,0x0C,0x30,0x0C,0x18,0x0C,0x1E,0xFC,0x0F,0x8C,0x03,0x0C,0x06,0x0C,0x0E,0x0C,0x1C,0x0C,0x18,0x0C,0x38,0x0C,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x52 'R'
    0x00,0x00,0xF8,0x03,0x3C,0x07,0x0C,0x0C,0x04,0x0C,0x0C,0x00,0x1C,0x00,0xF8,0x01,0xE0,0x07,0x00,0x0F,0x00,0x1C,0x06,0x18,0x06,0x18,0x0C,0x1C,0xFC,0x0F,0xF0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x53 'S'
    0x00,0x00,0xFF,0x0F,0xFF,0x0F,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x54 'T'
    0x00,0x00,0x0C,0x18,0x0C,0x18,0x0C,0x18,0x0C,0x18,0x0C,0x18,0x0C,0x18,0x0C,0x18,0x0C,0x18,0x0C,0x18,0x0C,0x18,0x0C,0x18,0x0C,0x18,0x1C,0x18,0xF8,0x0F,0xF0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x55 'U'
    0x00,0x00,0x03,0x30,0x06,0x18,0x06,0x18,0x0E,0x0C,0x0C,0x0C,0x0C,0x0C,0x18,0x06,0x18,0x06,0x18,0x06,0x30,0x03,0x30,0x03,0x20,0x01,0xE0,0x01,0xE0,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x56 'V'
    0x00,0x00,0x00,0x03,0x06,0x06,0x06,0x0F,0x06,0x06,0x0F,0x06,0x06,0x0D,0x06,0x86,0x09,0x03,0x8C,0x19,0x03,0x8C,0x19,0x03,0x8C,0x18,0x03,0xC8,0x30,0x01,0xD8,0xB0,0x01,0xD8,0xB0,0x01,0x58,0xA0,0x00,0x70,0xA0,0x00,0x70,0xE0,0x00,0x30,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x57 'W'
    0x00,0x00,0x0E,0x18,0x0C,0x0C,0x18,0x0E,0x38,0x06,0x30,0x03,0xE0,0x01,0xE0,0x01,0xC0,0x01,0xE0,0x01,0x30,0x03,0x38,0x07,0x18,0x06,0x0C,0x0C,0x0E,0x1C,0x07,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x58 'X'
    0x00,0x00,0x07,0x18,0x06,0x18,0x0C,0x0C,0x1C,0x06,0x18,0x06,0x30,0x03,0xF0,0x01,0xE0,0x01,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x59 'Y'
    0x00,0x00,0xFE,0x0F,0xFE,0x0F,0x00,0x06,0x00,0x07,0x80,0x03,0x80,0x01,0xC0,0x00,0x60,0x00,0x70,0x00,0x38,0x00,0x18,0x00,0x0C,0x00,0x06,0x00,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x5A 'Z'
    0x00,0x3E,0x3E,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x3E,  // 0x5B '['
    0x00,0x03,0x03,0x02,0x06,0x06,0x04,0x04,0x0C,0x0C,0x08,0x08,0x18,0x10,0x10,0x30,0x00,0x00,0x00,0x00,  // 0x5C '\\'
    0x00,0x0F,0x0F,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x0F,  // 0x5D ']'
    0x00,0x00,0x30,0x00,0x38,0x00,0x78,0x00,0x48,0x00,0xCC,0x00,0xC4,0x00,0x86,0x01,0x86,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x5E '^'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x0F,  // 0x5F '_'
    0x00,0x0E,0x0C,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x60 '`'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x01,0x9C,0x03,0x06,0x03,0x00,0x03,0x80,0x03,0xFC,0x03,0x0E,0x03,0x06,0x03,0x06,0x03,0xCE,0x03,0x7C,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x61 'a'
    0x00,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0xF6,0x00,0x9E,0x01,0x0E,0x03,0x06,0x03,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x03,0x06,0x03,0x9E,0x01,0xF6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x62 'b'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x00,0x9C,0x01,0x06,0x03,0x06,0x01,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x03,0x06,0x03,0x9C,0x01,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x63 'c'
    0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x78,0x03,0xDC,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x9C,0x03,0xF8,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x64 'd'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x00,0x9C,0x03,0x06,0x03,0x06,0x06,0x06,0x06,0xFE,0x07,0x06,0x00,0x06,0x00,0x06,0x03,0x9C,0x03,0xF8,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x65 'e'
    0x00,0x38,0x0C,0x0C,0x0C,0x3F,0x3F,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x00,0x00,0x00,0x00,  // 0x66 'f'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x02,0xDC,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x02,0x06,0x03,0x06,0x03,0x06,0x03,0xFC,0x03,0x78,0x03,0x00,0x03,0x06,0x03,0x8E,0x03,0xFC,0x01,  // 0x67 'g'
    0x00,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0xF6,0x01,0xBE,0x03,0x0E,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x68 'h'
    0x00,0x06,0x06,0x00,0x00,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x00,0x00,0x00,0x00,  // 0x69 'i'
    0x00,0x06,0x06,0x00,0x00,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x07,  // 0x6A 'j'
    0x00,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x86,0x03,0xC6,0x01,0xE6,0x00,0x76,0x00,0x3E,0x00,0x6E,0x00,0x66,0x00,0xC6,0x00,0x86,0x01,0x86,0x01,0x06,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x6B 'k'
    0x00,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x00,0x00,0x00,0x00,  // 0x6C 'l'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF6,0x79,0xDE,0xED,0x0E,0xC3,0x06,0xC3,0x06,0xC3,0x06,0xC3,0x06,0xC3,0x06,0xC3,0x06,0xC3,0x06,0xC3,0x06,0xC3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x6D 'm'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF6,0x01,0xBE,0x03,0x0E,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x6E 'n'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x01,0x9C,0x03,0x0E,0x03,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x03,0x9C,0x03,0xF8,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x6F 'o'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0xDE,0x01,0x06,0x03,0x06,0x03,0x06,0x03,0x02,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0xCE,0x01,0xFE,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,  // 0x70 'p'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x02,0xDC,0x03,0x06,0x03,0x06,0x03,0x06,0x02,0x06,0x02,0x06,0x02,0x06,0x03,0x06,0x03,0x9C,0x03,0xF8,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,  // 0x71 'q'
    0x00,0x00,0x00,0x00,0x00,0x76,0x7E,0x0E,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x00,0x00,0x00,0x00,  // 0x72 'r'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0xCE,0x01,0x86,0x01,0x06,0x00,0x3E,0x00,0xF8,0x01,0xC0,0x01,0x00,0x03,0x06,0x03,0x8E,0x01,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x73 's'
    0x00,0x08,0x0C,0x0C,0x0C,0x1F,0x1F,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x1C,0x3C,0x00,0x00,0x00,0x00,  // 0x74 't'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0x06,0x03,0xDC,0x02,0x78,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x75 'u'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x06,0x03,0x86,0x01,0x84,0x01,0x8C,0x01,0xCC,0x00,0xD8,0x00,0x58,0x00,0x78,0x00,0x70,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x76 'v'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x83,0x61,0xC3,0x61,0xC6,0x31,0x46,0x31,0x66,0x33,0x64,0x13,0x6C,0x1B,0x2C,0x1A,0x38,0x0E,0x38,0x0E,0x18,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x77 'w'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x03,0x8E,0x01,0xCC,0x00,0xF8,0x00,0x70,0x00,0x30,0x00,0x78,0x00,0xD8,0x00,0xCC,0x01,0x86,0x01,0x06,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x78 'x'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x06,0x03,0x06,0x01,0x8C,0x01,0x8C,0x01,0xCC,0x00,0xD8,0x00,0xD8,0x00,0x50,0x00,0x70,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x18,0x00,0x1E,0x00,  // 0x79 'y'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x03,0xFE,0x03,0x80,0x01,0xC0,0x00,0x60,0x00,0x30,0x00,0x18,0x00,0x0C,0x00,0x0E,0x00,0xFF,0x03,0xFF,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x7A 'z'
    0x00,0x70,0x18,0x08,0x08,0x08,0x08,0x08,0x0C,0x0C,0x02,0x0E,0x0C,0x08,0x08,0x08,0x08,0x08,0x18,0x78,  // 0x7B '{'
    0x00,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,  // 0x7C '|'
    0x00,0x07,0x0C,0x08,0x08,0x08,0x08,0x08,0x18,0x18,0x20,0x38,0x18,0x08,0x08,0x08,0x08,0x08,0x0C,0x0F,  // 0x7D '}'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0xFE,0x07,0xC2,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x7E '~'
    0x3E,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x3E,0x00,0x00,0x00,0x00  // 0x7F '<non-printable>'
};
