//                                                                               
//    This script modifies a font file which was generated with a tool by        
//    MikroElektronika - GLD Font Creator.                                       
//                                                                               
//    That tool creates the font data set for an embedded system from a Windows  
//    True Type font. The user is encouraged to ensure that the font used is     
//    properly licenses, or drawn from a source that does not have a license     
//    restriction.                                                               
//                                                                               
//    This script will read and then modify the file for a few specific purposes:
//      * <space>   character is redefined to set the width to 1/4 the height.   
//      * '0' - '9' characters are redefined to set the width equal to width('0')
//                  or to the user override value.                               
//                                                                               
//    And just because it can, it then improves upon the documentation in the    
//    resulting data structure.                                                  
//                                                                               
//    This script was created by Smartware Computing, and is provided 'as is'    
//    with no warranty or suitability of fitness for any purpose. Anyone may use 
//    or modify it subject to the agreement that:                                
//      * The Smartware copyright statement remains intact.                      
//      * Modifications for derivative use are clearly stated in this header.    
//                                                                               
//    Modifications from the original:                                           
//      * none.                                                                  
//                                                                               
// Script Activation:
//   ParseMikroeFont -0=32 BPG_Arial63x63.h New_BPG_Arial63x63.h

//Font Generated by MikroElektronika GLCD Font Creator 1.2.0.0
//MikroElektrnika 2011 
//http://www.mikroe.com 

//GLCD FontName : BPG_Arial63x63
//GLCD FontSize : 63 x 63

const unsigned char BPG_Arial63x63[] = {
    // Font Info
    0x00,                   // Unknown #1
    0x00,                   // Unknown #2
    0x20,0x00,              // FirstChar
    0x7F,0x00,              // LastChar
    0x3F,                   // FontHeight
    0x00,                   // Unknown #3
    // Directory of Chars  [Width] [Offset-L] [Offset-M] [Offset-H]
    0x0F,0x88,0x01,0x00,    // 0x20 ' ' 
    0x0C,0x06,0x02,0x00,    // 0x21 '!' 
    0x14,0x84,0x02,0x00,    // 0x22 '"' 
    0x23,0x41,0x03,0x00,    // 0x23 '#' 
    0x21,0x7C,0x04,0x00,    // 0x24 '$' 
    0x35,0xB7,0x05,0x00,    // 0x25 '%' 
    0x29,0x70,0x07,0x00,    // 0x26 '&' 
    0x09,0xEA,0x08,0x00,    // 0x27 ''' 
    0x13,0x68,0x09,0x00,    // 0x28 '(' 
    0x13,0x25,0x0A,0x00,    // 0x29 ')' 
    0x17,0xE2,0x0A,0x00,    // 0x2A '*' 
    0x22,0x9F,0x0B,0x00,    // 0x2B '+' 
    0x0C,0xDA,0x0C,0x00,    // 0x2C ',' 
    0x13,0x58,0x0D,0x00,    // 0x2D '-' 
    0x0C,0x15,0x0E,0x00,    // 0x2E '.' 
    0x12,0x93,0x0E,0x00,    // 0x2F '/' 
    0x20,0x50,0x0F,0x00,    // 0x30 '0' 
    0x20,0x4C,0x10,0x00,    // 0x31 '1' 
    0x20,0x48,0x11,0x00,    // 0x32 '2' 
    0x20,0x44,0x12,0x00,    // 0x33 '3' 
    0x20,0x40,0x13,0x00,    // 0x34 '4' 
    0x20,0x3C,0x14,0x00,    // 0x35 '5' 
    0x20,0x38,0x15,0x00,    // 0x36 '6' 
    0x20,0x34,0x16,0x00,    // 0x37 '7' 
    0x20,0x30,0x17,0x00,    // 0x38 '8' 
    0x20,0x2C,0x18,0x00,    // 0x39 '9' 
    0x0C,0x28,0x19,0x00,    // 0x3A ':' 
    0x0C,0xA6,0x19,0x00,    // 0x3B ';' 
    0x22,0x24,0x1A,0x00,    // 0x3C '<' 
    0x22,0x5F,0x1B,0x00,    // 0x3D '=' 
    0x22,0x9A,0x1C,0x00,    // 0x3E '>' 
    0x20,0xD5,0x1D,0x00,    // 0x3F '?' 
    0x3F,0xD1,0x1E,0x00,    // 0x40 '@' 
    0x2B,0xC9,0x20,0x00,    // 0x41 'A' 
    0x27,0x43,0x22,0x00,    // 0x42 'B' 
    0x2C,0x7E,0x23,0x00,    // 0x43 'C' 
    0x2B,0xF8,0x24,0x00,    // 0x44 'D' 
    0x27,0x72,0x26,0x00,    // 0x45 'E' 
    0x24,0xAD,0x27,0x00,    // 0x46 'F' 
    0x2E,0xE8,0x28,0x00,    // 0x47 'G' 
    0x29,0x62,0x2A,0x00,    // 0x48 'H' 
    0x0C,0xDC,0x2B,0x00,    // 0x49 'I' 
    0x1B,0x5A,0x2C,0x00,    // 0x4A 'J' 
    0x2A,0x56,0x2D,0x00,    // 0x4B 'K' 
    0x21,0xD0,0x2E,0x00,    // 0x4C 'L' 
    0x30,0x0B,0x30,0x00,    // 0x4D 'M' 
    0x29,0x85,0x31,0x00,    // 0x4E 'N' 
    0x2F,0xFF,0x32,0x00,    // 0x4F 'O' 
    0x28,0x79,0x34,0x00,    // 0x50 'P' 
    0x2F,0xB4,0x35,0x00,    // 0x51 'Q' 
    0x2D,0x2E,0x37,0x00,    // 0x52 'R' 
    0x27,0xA8,0x38,0x00,    // 0x53 'S' 
    0x26,0xE3,0x39,0x00,    // 0x54 'T' 
    0x29,0x1E,0x3B,0x00,    // 0x55 'U' 
    0x2A,0x98,0x3C,0x00,    // 0x56 'V' 
    0x3C,0x12,0x3E,0x00,    // 0x57 'W' 
    0x2A,0x0A,0x40,0x00,    // 0x58 'X' 
    0x2A,0x84,0x41,0x00,    // 0x59 'Y' 
    0x26,0xFE,0x42,0x00,    // 0x5A 'Z' 
    0x11,0x39,0x44,0x00,    // 0x5B '[' 
    0x12,0xF6,0x44,0x00,    // 0x5C '\\' 
    0x0E,0xB3,0x45,0x00,    // 0x5D ']' 
    0x1C,0x31,0x46,0x00,    // 0x5E '^' 
    0x24,0x2D,0x47,0x00,    // 0x5F '_' 
    0x0E,0x68,0x48,0x00,    // 0x60 '`' 
    0x21,0xE6,0x48,0x00,    // 0x61 'a' 
    0x20,0x21,0x4A,0x00,    // 0x62 'b' 
    0x1F,0x1D,0x4B,0x00,    // 0x63 'c' 
    0x1F,0x19,0x4C,0x00,    // 0x64 'd' 
    0x21,0x15,0x4D,0x00,    // 0x65 'e' 
    0x14,0x50,0x4E,0x00,    // 0x66 'f' 
    0x1F,0x0D,0x4F,0x00,    // 0x67 'g' 
    0x1F,0x09,0x50,0x00,    // 0x68 'h' 
    0x0A,0x05,0x51,0x00,    // 0x69 'i' 
    0x0A,0x83,0x51,0x00,    // 0x6A 'j' 
    0x1F,0x01,0x52,0x00,    // 0x6B 'k' 
    0x0A,0xFD,0x52,0x00,    // 0x6C 'l' 
    0x31,0x7B,0x53,0x00,    // 0x6D 'm' 
    0x1F,0x34,0x55,0x00,    // 0x6E 'n' 
    0x22,0x30,0x56,0x00,    // 0x6F 'o' 
    0x1F,0x6B,0x57,0x00,    // 0x70 'p' 
    0x1F,0x67,0x58,0x00,    // 0x71 'q' 
    0x16,0x63,0x59,0x00,    // 0x72 'r' 
    0x1E,0x20,0x5A,0x00,    // 0x73 's' 
    0x11,0x1C,0x5B,0x00,    // 0x74 't' 
    0x1F,0xD9,0x5B,0x00,    // 0x75 'u' 
    0x1F,0xD5,0x5C,0x00,    // 0x76 'v' 
    0x2E,0xD1,0x5D,0x00,    // 0x77 'w' 
    0x1F,0x4B,0x5F,0x00,    // 0x78 'x' 
    0x1F,0x47,0x60,0x00,    // 0x79 'y' 
    0x1F,0x43,0x61,0x00,    // 0x7A 'z' 
    0x14,0x3F,0x62,0x00,    // 0x7B '{' 
    0x0B,0xFC,0x62,0x00,    // 0x7C '|' 
    0x14,0x7A,0x63,0x00,    // 0x7D '}' 
    0x23,0x37,0x64,0x00,    // 0x7E '~' 
    0x10,0x72,0x65,0x00,    // 0x7F '<non-printable>' 
    // Chars Bitstream
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x20 ' '
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x0F,0xE0,0x0F,0xE0,0x0F,0xE0,0x0F,0xE0,0x0F,0xE0,0x0F,0xE0,0x0F,0xE0,0x0F,0xE0,0x0F,0xE0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0x80,0x0F,0x80,0x07,0x80,0x07,0x80,0x07,0x80,0x07,0x80,0x07,0x80,0x07,0x80,0x07,0x80,0x07,0x80,0x07,0x80,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x21 '!'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xE1,0x0F,0xF8,0xE1,0x0F,0xF8,0xE1,0x0F,0xF8,0xE1,0x0F,0xF8,0xE1,0x0F,0xF8,0xE1,0x0F,0xF8,0xE1,0x0F,0xF8,0xE1,0x0F,0xF8,0xE1,0x0F,0xF8,0xC1,0x07,0xF8,0xC1,0x07,0xF0,0xC1,0x07,0xF0,0xC1,0x07,0xF0,0xC0,0x07,0xF0,0x80,0x07,0xF0,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x22 '"'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x03,0xF8,0x00,0x00,0xE0,0x01,0xF8,0x00,0x00,0xF0,0x01,0xF8,0x00,0x00,0xF0,0x01,0x78,0x00,0x00,0xF0,0x01,0x78,0x00,0x00,0xF0,0x00,0x7C,0x00,0x00,0xF0,0x00,0x7C,0x00,0x00,0xF8,0x00,0x7C,0x00,0x00,0xF8,0x00,0x3C,0x00,0x00,0xF8,0x00,0x3C,0x00,0x00,0x78,0x00,0x3E,0x00,0x00,0x78,0x00,0x3E,0x00,0x00,0x7C,0x00,0x3E,0x00,0x00,0x7C,0x00,0x1E,0x00,0xFE,0xFF,0xFF,0xFF,0x07,0xFE,0xFF,0xFF,0xFF,0x07,0xFE,0xFF,0xFF,0xFF,0x07,0xFE,0xFF,0xFF,0xFF,0x07,0x00,0x3E,0x00,0x0F,0x00,0x00,0x3E,0x00,0x0F,0x00,0x00,0x1E,0x80,0x0F,0x00,0x00,0x1E,0x80,0x0F,0x00,0x00,0x1F,0x80,0x0F,0x00,0x00,0x1F,0x80,0x07,0x00,0x00,0x1F,0xC0,0x07,0x00,0x00,0x0F,0xC0,0x07,0x00,0x00,0x0F,0xC0,0x07,0x00,0x80,0x0F,0xC0,0x07,0x00,0x80,0x0F,0xC0,0x03,0x00,0x80,0x0F,0xE0,0x03,0x00,0xFE,0xFF,0xFF,0xFF,0x07,0xFE,0xFF,0xFF,0xFF,0x07,0xFE,0xFF,0xFF,0xFF,0x07,0xFE,0xFF,0xFF,0xFF,0x07,0xC0,0x07,0xF0,0x01,0x00,0xC0,0x03,0xF0,0x01,0x00,0xC0,0x03,0xF0,0x01,0x00,0xE0,0x03,0xF0,0x01,0x00,0xE0,0x03,0xF0,0x00,0x00,0xE0,0x03,0xF8,0x00,0x00,0xE0,0x01,0xF8,0x00,0x00,0xE0,0x01,0xF8,0x00,0x00,0xF0,0x01,0xF8,0x00,0x00,0xF0,0x01,0x78,0x00,0x00,0xF0,0x01,0x7C,0x00,0x00,0xF0,0x00,0x7C,0x00,0x00,0xF8,0x00,0x7C,0x00,0x00,0xF8,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x23 '#'
    0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0xF0,0x7F,0x00,0x00,0x00,0xFE,0xFF,0x03,0x00,0x00,0xFF,0xFF,0x07,0x00,0x80,0xFF,0xFF,0x0F,0x00,0xC0,0x7F,0xF7,0x1F,0x00,0xE0,0x1F,0xC7,0x3F,0x00,0xE0,0x07,0x87,0x3F,0x00,0xF0,0x03,0x07,0x7F,0x00,0xF0,0x03,0x07,0x7E,0x00,0xF0,0x01,0x07,0x7E,0x00,0xF8,0x01,0x07,0x7E,0x00,0xF8,0x01,0x07,0x0C,0x00,0xF8,0x01,0x07,0x00,0x00,0xF8,0x01,0x07,0x00,0x00,0xF8,0x01,0x07,0x00,0x00,0xF0,0x03,0x07,0x00,0x00,0xF0,0x03,0x07,0x00,0x00,0xF0,0x07,0x07,0x00,0x00,0xE0,0x1F,0x07,0x00,0x00,0xE0,0x7F,0x07,0x00,0x00,0xC0,0xFF,0x07,0x00,0x00,0x80,0xFF,0x7F,0x00,0x00,0x00,0xFE,0xFF,0x01,0x00,0x00,0xF8,0xFF,0x07,0x00,0x00,0xE0,0xFF,0x1F,0x00,0x00,0x00,0xFF,0x3F,0x00,0x00,0x00,0xF7,0x3F,0x00,0x00,0x00,0x87,0x7F,0x00,0x00,0x00,0x07,0x7F,0x00,0x00,0x00,0x07,0xFE,0x00,0x00,0x00,0x07,0xFC,0x00,0x00,0x00,0x07,0xFC,0x00,0x00,0x00,0x07,0xF8,0x01,0xC0,0x00,0x07,0xF8,0x01,0xFC,0x00,0x07,0xF8,0x01,0xFC,0x00,0x07,0xF8,0x01,0xF8,0x01,0x07,0xF8,0x00,0xF8,0x01,0x07,0xFC,0x00,0xF8,0x01,0x07,0xFC,0x00,0xF8,0x03,0x07,0xFE,0x00,0xF0,0x07,0x07,0x7E,0x00,0xF0,0x0F,0x87,0x7F,0x00,0xE0,0x1F,0xC7,0x3F,0x00,0xC0,0xFF,0xFF,0x1F,0x00,0x80,0xFF,0xFF,0x0F,0x00,0x00,0xFF,0xFF,0x07,0x00,0x00,0xFC,0xFF,0x01,0x00,0x00,0xE0,0x3F,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x24 '$'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x00,0x80,0x07,0x00,0x00,0xFE,0x03,0x00,0xC0,0x07,0x00,0x80,0xFF,0x07,0x00,0xC0,0x03,0x00,0xC0,0xFF,0x0F,0x00,0xE0,0x03,0x00,0xC0,0x8F,0x1F,0x00,0xF0,0x01,0x00,0xE0,0x07,0x3F,0x00,0xF0,0x01,0x00,0xE0,0x03,0x3E,0x00,0xF8,0x00,0x00,0xF0,0x01,0x7C,0x00,0x78,0x00,0x00,0xF0,0x01,0x7C,0x00,0x7C,0x00,0x00,0xF0,0x01,0x7C,0x00,0x3C,0x00,0x00,0xF0,0x01,0x7C,0x00,0x3E,0x00,0x00,0xF0,0x01,0x7C,0x00,0x1E,0x00,0x00,0xF0,0x01,0x7C,0x00,0x1F,0x00,0x00,0xF0,0x01,0x7C,0x00,0x0F,0x00,0x00,0xF0,0x01,0x7C,0x80,0x0F,0x00,0x00,0xF0,0x01,0x7C,0x80,0x07,0x00,0x00,0xF0,0x01,0x7C,0xC0,0x07,0x00,0x00,0xF0,0x01,0x7C,0xC0,0x03,0x00,0x00,0xE0,0x03,0x3E,0xE0,0x03,0x00,0x00,0xE0,0x07,0x3E,0xE0,0x01,0x00,0x00,0xC0,0x8F,0x1F,0xF0,0x01,0x00,0x00,0xC0,0xFF,0x0F,0xF0,0x00,0x00,0x00,0x80,0xFF,0x07,0xF8,0x00,0x00,0x00,0x00,0xFE,0x03,0x78,0x00,0x00,0x00,0x00,0x70,0x00,0x7C,0x00,0x0C,0x00,0x00,0x00,0x00,0x3C,0xC0,0x7F,0x00,0x00,0x00,0x00,0x3E,0xE0,0xFF,0x01,0x00,0x00,0x00,0x1E,0xF0,0xFF,0x03,0x00,0x00,0x00,0x1F,0xF8,0xF3,0x07,0x00,0x00,0x80,0x0F,0xF8,0xC0,0x0F,0x00,0x00,0x80,0x0F,0x7C,0x80,0x0F,0x00,0x00,0xC0,0x07,0x7C,0x80,0x0F,0x00,0x00,0xC0,0x07,0x7C,0x00,0x1F,0x00,0x00,0xE0,0x03,0x3C,0x00,0x1F,0x00,0x00,0xE0,0x03,0x3E,0x00,0x1F,0x00,0x00,0xF0,0x01,0x3E,0x00,0x1F,0x00,0x00,0xF0,0x00,0x3E,0x00,0x1F,0x00,0x00,0xF8,0x00,0x3E,0x00,0x1F,0x00,0x00,0x78,0x00,0x3E,0x00,0x1F,0x00,0x00,0x7C,0x00,0x3C,0x00,0x1F,0x00,0x00,0x3C,0x00,0x7C,0x00,0x1F,0x00,0x00,0x3E,0x00,0x7C,0x80,0x0F,0x00,0x00,0x1E,0x00,0x7C,0x80,0x0F,0x00,0x00,0x1F,0x00,0xF8,0xC0,0x0F,0x00,0x00,0x0F,0x00,0xF8,0xE3,0x07,0x00,0x80,0x0F,0x00,0xF0,0xFF,0x03,0x00,0x80,0x07,0x00,0xE0,0xFF,0x01,0x00,0xC0,0x07,0x00,0xC0,0xFF,0x00,0x00,0xC0,0x03,0x00,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x25 '%'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x00,0x80,0xFF,0x01,0x00,0x00,0x00,0xE0,0xFF,0x07,0x00,0x00,0x00,0xF0,0xFF,0x0F,0x00,0x00,0x00,0xF8,0xFF,0x1F,0x00,0x00,0x00,0xFC,0xC1,0x1F,0x00,0x00,0x00,0xFE,0x80,0x3F,0x00,0x00,0x00,0x7E,0x00,0x3F,0x00,0x00,0x00,0x7E,0x00,0x3E,0x00,0x00,0x00,0x3E,0x00,0x7E,0x00,0x00,0x00,0x3E,0x00,0x7E,0x00,0x00,0x00,0x7E,0x00,0x3E,0x00,0x00,0x00,0x7E,0x00,0x3F,0x00,0x00,0x00,0x7E,0x00,0x3F,0x00,0x00,0x00,0xFE,0x80,0x1F,0x00,0x00,0x00,0xFC,0xC1,0x1F,0x00,0x00,0x00,0xFC,0xE3,0x0F,0x00,0x00,0x00,0xF8,0xFF,0x07,0x00,0x00,0x00,0xF0,0xFF,0x03,0x00,0x00,0x00,0xE0,0xFF,0x01,0x00,0x00,0x00,0xE0,0x7F,0x00,0x00,0x00,0x00,0xF0,0x3F,0x00,0x00,0x00,0x00,0xFC,0x7F,0x00,0x00,0x00,0x00,0xFE,0xFF,0x00,0x00,0x00,0x00,0xFF,0xFE,0x00,0x00,0x00,0x80,0x7F,0xFE,0x01,0x01,0x00,0xC0,0x1F,0xFC,0x03,0x1F,0x00,0xE0,0x0F,0xF8,0x07,0x3F,0x00,0xF0,0x07,0xF0,0x87,0x3F,0x00,0xF0,0x03,0xE0,0x8F,0x1F,0x00,0xF8,0x03,0xC0,0x9F,0x1F,0x00,0xF8,0x01,0xC0,0xFF,0x1F,0x00,0xF8,0x01,0x80,0xFF,0x0F,0x00,0xF8,0x01,0x00,0xFF,0x0F,0x00,0xF8,0x01,0x00,0xFE,0x07,0x00,0xF8,0x01,0x00,0xFC,0x07,0x00,0xF8,0x01,0x00,0xFC,0x03,0x00,0xF8,0x03,0x00,0xF8,0x07,0x00,0xF8,0x03,0x00,0xFC,0x0F,0x00,0xF0,0x07,0x00,0xFE,0x1F,0x00,0xF0,0x0F,0x00,0xFF,0x3F,0x00,0xE0,0x1F,0xC0,0xFF,0x7F,0x00,0xC0,0x7F,0xF0,0xBF,0xFF,0x00,0x80,0xFF,0xFF,0x0F,0xFF,0x01,0x00,0xFF,0xFF,0x07,0xFE,0x00,0x00,0xFE,0xFF,0x03,0xFC,0x00,0x00,0xF8,0xFF,0x00,0x78,0x00,0x00,0xC0,0x0F,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x26 '&'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x01,0xF8,0x01,0xF8,0x01,0xF8,0x01,0xF8,0x01,0xF8,0x01,0xF8,0x01,0xF8,0x01,0xF8,0x01,0xF8,0x01,0xF8,0x01,0xF8,0x01,0xF0,0x00,0xF0,0x00,0xF0,0x00,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x27 '''
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x07,0x00,0xC0,0x03,0x00,0xE0,0x03,0x00,0xE0,0x01,0x00,0xF0,0x01,0x00,0xF8,0x00,0x00,0xF8,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x80,0x0F,0x00,0x80,0x0F,0x00,0x80,0x0F,0x00,0xC0,0x0F,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x03,0x00,0xE0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xE0,0x03,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x0F,0x00,0x80,0x0F,0x00,0x80,0x0F,0x00,0x80,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0xF8,0x00,0x00,0xF0,0x00,0x00,0xF0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x03,0x00,0xC0,0x03,  // 0x28 '('
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x00,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xC0,0x03,0x00,0xC0,0x07,0x00,0x80,0x07,0x00,0x80,0x0F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0xFC,0x00,0x00,0xF8,0x00,0x00,0xF8,0x00,0x00,0xF8,0x01,0x00,0xF0,0x01,0x00,0xF0,0x01,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xE0,0x03,0x00,0xE0,0x03,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x03,0x00,0xE0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x01,0x00,0xF8,0x01,0x00,0xF8,0x01,0x00,0xF8,0x00,0x00,0xF8,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x7E,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x80,0x0F,0x00,0x80,0x07,0x00,0xC0,0x07,0x00,0xC0,0x03,0x00,0xE0,0x01,0x00,0xF0,0x01,0x00,  // 0x29 ')'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x08,0x3C,0x10,0x78,0x3C,0x3C,0xF8,0xB9,0x3F,0xFC,0xFF,0x3F,0xFC,0xFF,0x7F,0xC0,0xFF,0x0F,0x00,0x7E,0x00,0x00,0xFE,0x00,0x00,0xFF,0x01,0x80,0xEF,0x03,0xC0,0xC7,0x07,0xE0,0xC3,0x0F,0xE0,0x83,0x0F,0xC0,0x01,0x03,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x2A '*'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0xF0,0xFF,0xFF,0xFF,0x03,0xF0,0xFF,0xFF,0xFF,0x03,0xF0,0xFF,0xFF,0xFF,0x03,0xF0,0xFF,0xFF,0xFF,0x03,0xF0,0xFF,0xFF,0xFF,0x03,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x2B '+'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0F,0x00,0x07,0x80,0x07,0xC0,0x03,0xC0,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x2C ','
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0x07,0xFC,0xFF,0x07,0xFC,0xFF,0x07,0xFC,0xFF,0x07,0xFC,0xFF,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x2D '-'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x2E '.'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x03,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xF0,0x01,0x00,0xF0,0x01,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF8,0x00,0x00,0xF8,0x00,0x00,0x78,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x1E,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x80,0x0F,0x00,0x80,0x0F,0x00,0x80,0x07,0x00,0x80,0x07,0x00,0xC0,0x07,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xE0,0x03,0x00,0xE0,0x03,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xF0,0x01,0x00,0xF0,0x01,0x00,0xF0,0x00,0x00,0xF8,0x00,0x00,0xF8,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x3C,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x2F '/'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x3F,0x00,0x00,0xF8,0xFF,0x00,0x00,0xFC,0xFF,0x03,0x00,0xFF,0xFF,0x07,0x80,0xFF,0xFF,0x0F,0x80,0x3F,0xE0,0x0F,0xC0,0x1F,0xC0,0x1F,0xC0,0x0F,0x80,0x3F,0xE0,0x07,0x00,0x3F,0xE0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7C,0xF0,0x01,0x00,0x7C,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xF8,0xF8,0x01,0x00,0xF8,0xF8,0x01,0x00,0xF8,0xF8,0x00,0x00,0xF8,0xF8,0x00,0x00,0xF8,0xF8,0x00,0x00,0xF8,0xF8,0x00,0x00,0xF8,0xF8,0x00,0x00,0xF8,0xF8,0x00,0x00,0xF8,0xF8,0x00,0x00,0xF8,0xF8,0x01,0x00,0xF8,0xF8,0x01,0x00,0xF8,0xF8,0x01,0x00,0xF8,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF0,0x01,0x00,0xFC,0xF0,0x01,0x00,0x7C,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xE0,0x07,0x00,0x3E,0xE0,0x07,0x00,0x3F,0xC0,0x0F,0x80,0x3F,0xC0,0x1F,0xC0,0x1F,0x80,0x7F,0xE0,0x0F,0x00,0xFF,0xFF,0x0F,0x00,0xFE,0xFF,0x07,0x00,0xFC,0xFF,0x01,0x00,0xF8,0xFF,0x00,0x00,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x30 '0'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFE,0x00,0x00,0x00,0xFF,0x00,0x00,0x80,0xFF,0x00,0x00,0xC0,0xFF,0x00,0x00,0xF0,0xFF,0x00,0x00,0xF8,0xFF,0x00,0x00,0xFE,0xFF,0x00,0x80,0xFF,0xFD,0x00,0x80,0x7F,0xFC,0x00,0x80,0x3F,0xFC,0x00,0x80,0x0F,0xFC,0x00,0x80,0x03,0xFC,0x00,0x80,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x31 '1'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x3F,0x00,0x00,0xFC,0xFF,0x01,0x00,0xFE,0xFF,0x07,0x80,0xFF,0xFF,0x0F,0xC0,0xFF,0xFF,0x1F,0xC0,0x3F,0xC0,0x3F,0xE0,0x0F,0x80,0x7F,0xF0,0x07,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xE0,0x01,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFE,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x7F,0x00,0x00,0x00,0x3F,0x00,0x00,0x80,0x3F,0x00,0x00,0xC0,0x1F,0x00,0x00,0xE0,0x0F,0x00,0x00,0xF0,0x07,0x00,0x00,0xF8,0x07,0x00,0x00,0xFC,0x03,0x00,0x00,0xFE,0x01,0x00,0x00,0xFF,0x00,0x00,0xC0,0x3F,0x00,0x00,0xE0,0x1F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF8,0x07,0x00,0x00,0xFC,0x03,0x00,0x00,0xFE,0x01,0x00,0x00,0x7F,0x00,0x00,0x80,0x3F,0x00,0x00,0xC0,0x1F,0x00,0x00,0xE0,0x0F,0x00,0x00,0xF0,0x07,0x00,0x00,0xF0,0x03,0x00,0x00,0xF8,0x03,0x00,0x00,0xF8,0xFF,0xFF,0xFF,0xFC,0xFF,0xFF,0xFF,0xFC,0xFF,0xFF,0xFF,0xFC,0xFF,0xFF,0xFF,0xFC,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x32 '2'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x1F,0x00,0x00,0xFC,0xFF,0x00,0x00,0xFE,0xFF,0x01,0x80,0xFF,0xFF,0x07,0x80,0xFF,0xFF,0x0F,0xC0,0x1F,0xE0,0x0F,0xE0,0x0F,0xC0,0x1F,0xE0,0x07,0x80,0x3F,0xF0,0x03,0x00,0x3F,0xF0,0x03,0x00,0x3F,0xF0,0x01,0x00,0x3E,0xF8,0x01,0x00,0x3E,0x80,0x01,0x00,0x3E,0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x3F,0x00,0x00,0x80,0x1F,0x00,0x00,0xC0,0x1F,0x00,0x00,0xF0,0x0F,0x00,0xC0,0xFF,0x07,0x00,0xC0,0xFF,0x01,0x00,0xC0,0xFF,0x01,0x00,0xC0,0xFF,0x0F,0x00,0xC0,0xFF,0x1F,0x00,0x00,0xC0,0x3F,0x00,0x00,0x80,0x7F,0x00,0x00,0x00,0x7F,0x00,0x00,0x00,0xFE,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0xC0,0x00,0x00,0xF8,0xF8,0x01,0x00,0xF8,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF8,0x03,0x00,0xFE,0xF0,0x03,0x00,0x7E,0xF0,0x07,0x00,0x7F,0xE0,0x0F,0x80,0x3F,0xC0,0x3F,0xE0,0x1F,0xC0,0xFF,0xFF,0x0F,0x00,0xFF,0xFF,0x07,0x00,0xFE,0xFF,0x03,0x00,0xF8,0xFF,0x00,0x00,0xC0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x33 '3'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF8,0x03,0x00,0x00,0xF8,0x03,0x00,0x00,0xFC,0x03,0x00,0x00,0xFE,0x03,0x00,0x00,0xFE,0x03,0x00,0x00,0xFF,0x03,0x00,0x80,0xEF,0x03,0x00,0xC0,0xEF,0x03,0x00,0xC0,0xE7,0x03,0x00,0xE0,0xE3,0x03,0x00,0xF0,0xE3,0x03,0x00,0xF0,0xE1,0x03,0x00,0xF8,0xE0,0x03,0x00,0xFC,0xE0,0x03,0x00,0x7C,0xE0,0x03,0x00,0x3E,0xE0,0x03,0x00,0x3F,0xE0,0x03,0x80,0x1F,0xE0,0x03,0x80,0x0F,0xE0,0x03,0xC0,0x07,0xE0,0x03,0xE0,0x07,0xE0,0x03,0xE0,0x03,0xE0,0x03,0xF0,0x01,0xE0,0x03,0xF8,0x01,0xE0,0x03,0xFC,0x00,0xE0,0x03,0x7C,0x00,0xE0,0x03,0x7E,0x00,0xE0,0x03,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x34 '4'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x7F,0x00,0xFF,0xFF,0x7F,0x00,0xFF,0xFF,0x7F,0x80,0xFF,0xFF,0x7F,0x80,0xFF,0xFF,0x7F,0x80,0x1F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0xC0,0x0F,0x00,0x00,0xC0,0x0F,0x00,0x00,0xC0,0x0F,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xC0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0xC7,0xFF,0x00,0xE0,0xF3,0xFF,0x03,0xE0,0xFF,0xFF,0x07,0xE0,0xFF,0xFF,0x1F,0xF0,0xFF,0xFF,0x3F,0xF0,0x1F,0xC0,0x3F,0xF0,0x07,0x80,0x7F,0xF0,0x03,0x00,0xFF,0xE0,0x01,0x00,0xFE,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0xF8,0x01,0x00,0xF8,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF8,0x03,0x00,0xFE,0xF0,0x03,0x00,0x7E,0xF0,0x07,0x00,0x7F,0xE0,0x0F,0x80,0x3F,0xE0,0x3F,0xE0,0x1F,0xC0,0xFF,0xFF,0x0F,0x80,0xFF,0xFF,0x07,0x00,0xFE,0xFF,0x03,0x00,0xF8,0xFF,0x00,0x00,0xC0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x35 '5'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x7F,0x00,0x00,0xF0,0xFF,0x01,0x00,0xFC,0xFF,0x07,0x00,0xFE,0xFF,0x0F,0x00,0xFF,0xFF,0x1F,0x80,0x7F,0xC0,0x3F,0xC0,0x1F,0x00,0x3F,0xC0,0x0F,0x00,0x7E,0xE0,0x07,0x00,0x7E,0xE0,0x07,0x00,0x7C,0xF0,0x03,0x00,0xFC,0xF0,0x03,0x00,0x7C,0xF0,0x01,0x00,0x00,0xF0,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF8,0x00,0x3E,0x00,0xF8,0xC0,0xFF,0x01,0xF8,0xF0,0xFF,0x03,0xF8,0xFC,0xFF,0x0F,0xF8,0xFE,0xFF,0x1F,0xFC,0xFE,0xF0,0x3F,0xFC,0x1F,0x80,0x3F,0xFC,0x0F,0x00,0x7F,0xFC,0x07,0x00,0x7E,0xFC,0x03,0x00,0xFE,0xFC,0x03,0x00,0xFC,0xFC,0x01,0x00,0xFC,0xF8,0x01,0x00,0xF8,0xF8,0x01,0x00,0xF8,0xF8,0x01,0x00,0xF8,0xF8,0x01,0x00,0xF8,0xF8,0x01,0x00,0xF8,0xF8,0x01,0x00,0xF8,0xF8,0x01,0x00,0xF8,0xF0,0x03,0x00,0xFC,0xF0,0x03,0x00,0xFC,0xF0,0x07,0x00,0xFC,0xE0,0x07,0x00,0x7E,0xE0,0x0F,0x00,0x7F,0xC0,0x1F,0x80,0x3F,0x80,0x7F,0xE0,0x1F,0x00,0xFF,0xFF,0x1F,0x00,0xFE,0xFF,0x07,0x00,0xFC,0xFF,0x03,0x00,0xF0,0xFF,0x00,0x00,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x36 '6'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xFF,0xFF,0xFF,0xF8,0xFF,0xFF,0xFF,0xF8,0xFF,0xFF,0xFF,0xF8,0xFF,0xFF,0xFF,0xF8,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x7F,0x00,0x00,0x00,0x3F,0x00,0x00,0x80,0x1F,0x00,0x00,0xC0,0x0F,0x00,0x00,0xE0,0x0F,0x00,0x00,0xE0,0x07,0x00,0x00,0xF0,0x03,0x00,0x00,0xF8,0x03,0x00,0x00,0xF8,0x01,0x00,0x00,0xFC,0x01,0x00,0x00,0xFC,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x3F,0x00,0x00,0x80,0x1F,0x00,0x00,0x80,0x1F,0x00,0x00,0xC0,0x1F,0x00,0x00,0xC0,0x0F,0x00,0x00,0xC0,0x0F,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF8,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x37 '7'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x3F,0x00,0x00,0xF8,0xFF,0x00,0x00,0xFE,0xFF,0x03,0x00,0xFF,0xFF,0x07,0x80,0xFF,0xFF,0x0F,0xC0,0x3F,0xE0,0x1F,0xC0,0x1F,0x80,0x3F,0xE0,0x0F,0x00,0x3F,0xE0,0x07,0x00,0x3F,0xE0,0x07,0x00,0x7E,0xE0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xE0,0x03,0x00,0x7E,0xE0,0x07,0x00,0x7E,0xE0,0x07,0x00,0x3F,0xC0,0x0F,0x80,0x3F,0xC0,0x1F,0xC0,0x1F,0x80,0x7F,0xE0,0x0F,0x00,0xFF,0xFF,0x07,0x00,0xFC,0xFF,0x03,0x00,0xFC,0xFF,0x01,0x00,0xFF,0xFF,0x07,0x80,0xFF,0xFF,0x1F,0xE0,0x1F,0xC0,0x3F,0xE0,0x0F,0x80,0x7F,0xF0,0x07,0x00,0x7E,0xF0,0x03,0x00,0xFE,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xF8,0xF8,0x00,0x00,0xF8,0xF8,0x00,0x00,0xF8,0xF8,0x00,0x00,0xF8,0xF8,0x01,0x00,0xF8,0xF8,0x01,0x00,0xF8,0xF8,0x01,0x00,0xFC,0xF8,0x03,0x00,0xFC,0xF0,0x03,0x00,0xFE,0xF0,0x07,0x00,0x7F,0xE0,0x0F,0x80,0x7F,0xC0,0x3F,0xE0,0x3F,0xC0,0xFF,0xFF,0x1F,0x00,0xFF,0xFF,0x0F,0x00,0xFE,0xFF,0x03,0x00,0xF8,0xFF,0x01,0x00,0xC0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x38 '8'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x1F,0x00,0x00,0xFC,0xFF,0x00,0x00,0xFE,0xFF,0x01,0x00,0xFF,0xFF,0x07,0x80,0xFF,0xFF,0x0F,0xC0,0x3F,0xE0,0x1F,0xE0,0x1F,0x80,0x1F,0xF0,0x07,0x00,0x3F,0xF0,0x07,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF8,0x01,0x00,0x7C,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF8,0x00,0x00,0xF8,0xF8,0x00,0x00,0xF8,0xF8,0x00,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF0,0x03,0x00,0xFE,0xF0,0x07,0x00,0xFF,0xE0,0x0F,0x80,0xFF,0xE0,0x1F,0xC0,0xFF,0xC0,0xFF,0xFF,0xFB,0x80,0xFF,0xFF,0xFB,0x00,0xFF,0xFF,0xF8,0x00,0xFE,0x7F,0xF8,0x00,0xF8,0x1F,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x7C,0xF0,0x01,0x00,0x7E,0xF0,0x01,0x00,0x7E,0xF0,0x03,0x00,0x3F,0xF0,0x03,0x00,0x3F,0xE0,0x07,0x80,0x1F,0xE0,0x0F,0xC0,0x1F,0xC0,0x1F,0xF0,0x0F,0xC0,0xFF,0xFF,0x07,0x80,0xFF,0xFF,0x03,0x00,0xFF,0xFF,0x01,0x00,0xFC,0x7F,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x39 '9'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x3A ':'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0F,0x00,0x07,0x80,0x07,0xC0,0x03,0xC0,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x3B ';'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0xC0,0x03,0x00,0x00,0x00,0xF0,0x03,0x00,0x00,0x00,0xFE,0x03,0x00,0x00,0x80,0xFF,0x03,0x00,0x00,0xE0,0xFF,0x03,0x00,0x00,0xFC,0x7F,0x00,0x00,0x00,0xFF,0x1F,0x00,0x00,0xE0,0xFF,0x07,0x00,0x00,0xF8,0xFF,0x00,0x00,0x00,0xFE,0x3F,0x00,0x00,0xC0,0xFF,0x07,0x00,0x00,0xF0,0xFF,0x01,0x00,0x00,0xF8,0x3F,0x00,0x00,0x00,0xF8,0x0F,0x00,0x00,0x00,0xF8,0x03,0x00,0x00,0x00,0xF8,0x0F,0x00,0x00,0x00,0xF8,0x7F,0x00,0x00,0x00,0xE0,0xFF,0x01,0x00,0x00,0x80,0xFF,0x0F,0x00,0x00,0x00,0xFE,0x3F,0x00,0x00,0x00,0xF0,0xFF,0x01,0x00,0x00,0xC0,0xFF,0x07,0x00,0x00,0x00,0xFF,0x1F,0x00,0x00,0x00,0xF8,0xFF,0x00,0x00,0x00,0xE0,0xFF,0x03,0x00,0x00,0x80,0xFF,0x03,0x00,0x00,0x00,0xFC,0x03,0x00,0x00,0x00,0xF0,0x03,0x00,0x00,0x00,0xC0,0x03,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x3C '<'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0xFF,0xFF,0x03,0xF0,0xFF,0xFF,0xFF,0x03,0xF0,0xFF,0xFF,0xFF,0x03,0xF0,0xFF,0xFF,0xFF,0x03,0xF0,0xFF,0xFF,0xFF,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0xFF,0xFF,0x03,0xF0,0xFF,0xFF,0xFF,0x03,0xF0,0xFF,0xFF,0xFF,0x03,0xF0,0xFF,0xFF,0xFF,0x03,0xF0,0xFF,0xFF,0xFF,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x3D '='
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x00,0xF8,0x03,0x00,0x00,0x00,0xF8,0x0F,0x00,0x00,0x00,0xF8,0x3F,0x00,0x00,0x00,0xF8,0xFF,0x01,0x00,0x00,0xC0,0xFF,0x07,0x00,0x00,0x00,0xFF,0x1F,0x00,0x00,0x00,0xF8,0xFF,0x00,0x00,0x00,0xE0,0xFF,0x03,0x00,0x00,0x00,0xFF,0x1F,0x00,0x00,0x00,0xFC,0x7F,0x00,0x00,0x00,0xE0,0xFF,0x01,0x00,0x00,0x80,0xFF,0x03,0x00,0x00,0x00,0xFE,0x03,0x00,0x00,0x00,0xF8,0x03,0x00,0x00,0x00,0xFE,0x03,0x00,0x00,0xC0,0xFF,0x03,0x00,0x00,0xF0,0xFF,0x01,0x00,0x00,0xFC,0x3F,0x00,0x00,0x80,0xFF,0x0F,0x00,0x00,0xE0,0xFF,0x03,0x00,0x00,0xFC,0x7F,0x00,0x00,0x00,0xFF,0x1F,0x00,0x00,0xC0,0xFF,0x07,0x00,0x00,0xF8,0xFF,0x00,0x00,0x00,0xF8,0x3F,0x00,0x00,0x00,0xF8,0x0F,0x00,0x00,0x00,0xF8,0x01,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x3E '>'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0xF8,0xFF,0x00,0x00,0xFE,0xFF,0x03,0x00,0xFF,0xFF,0x0F,0x80,0xFF,0xFF,0x1F,0xC0,0x7F,0xE0,0x3F,0xE0,0x1F,0x80,0x3F,0xE0,0x0F,0x00,0x7F,0xF0,0x07,0x00,0xFE,0xF0,0x03,0x00,0xFC,0xF8,0x03,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xF8,0xF8,0x01,0x00,0xF8,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x7F,0x00,0x00,0x80,0x3F,0x00,0x00,0xC0,0x3F,0x00,0x00,0xE0,0x1F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF8,0x07,0x00,0x00,0xFC,0x03,0x00,0x00,0xFE,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x3F,0x00,0x00,0x80,0x1F,0x00,0x00,0x80,0x1F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x1F,0x00,0x00,0xC0,0x1F,0x00,0x00,0xC0,0x1F,0x00,0x00,0xC0,0x1F,0x00,0x00,0xC0,0x1F,0x00,0x00,0xC0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x3F '?'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFF,0x07,0x00,0x00,0x00,0x00,0xC0,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0xF0,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0xFC,0xFF,0xFF,0xFF,0x03,0x00,0x00,0x00,0xFF,0x0F,0x00,0xFF,0x0F,0x00,0x00,0x80,0xFF,0x01,0x00,0xF8,0x1F,0x00,0x00,0xC0,0x3F,0x00,0x00,0xC0,0x3F,0x00,0x00,0xE0,0x0F,0x00,0x00,0x80,0x7F,0x00,0x00,0xF0,0x07,0x00,0x00,0x00,0xFE,0x00,0x00,0xF8,0x03,0x00,0x00,0x00,0xFC,0x01,0x00,0xFC,0x00,0x00,0x00,0x00,0xF8,0x01,0x00,0x7C,0x00,0x00,0x00,0x00,0xF0,0x03,0x00,0x7E,0x00,0xE0,0x03,0x00,0xE0,0x03,0x00,0x3F,0x00,0xFC,0x1F,0xFC,0xC0,0x07,0x00,0x1F,0x00,0xFF,0x3F,0x7C,0xC0,0x07,0x80,0x0F,0x80,0xFF,0x7F,0x7C,0x80,0x0F,0x80,0x0F,0xC0,0xFF,0xFF,0x7E,0x80,0x0F,0xC0,0x07,0xE0,0x1F,0xF8,0x7F,0x00,0x0F,0xC0,0x07,0xF0,0x07,0xE0,0x7F,0x00,0x1F,0xC0,0x03,0xF8,0x03,0xE0,0x3F,0x00,0x1F,0xE0,0x03,0xF8,0x01,0xC0,0x3F,0x00,0x1F,0xE0,0x03,0xFC,0x01,0x80,0x3F,0x00,0x1F,0xE0,0x01,0xFC,0x00,0x80,0x3F,0x00,0x1F,0xF0,0x01,0x7E,0x00,0x80,0x1F,0x00,0x1F,0xF0,0x01,0x7E,0x00,0x80,0x1F,0x00,0x1F,0xF0,0x01,0x7F,0x00,0x80,0x1F,0x00,0x1F,0xF0,0x00,0x3F,0x00,0x80,0x1F,0x00,0x1F,0xF0,0x00,0x3F,0x00,0x80,0x1F,0x00,0x1F,0xF0,0x00,0x3F,0x00,0x80,0x0F,0x00,0x1F,0xF0,0x00,0x1F,0x00,0x80,0x0F,0x00,0x0F,0xF8,0x80,0x1F,0x00,0x80,0x0F,0x80,0x0F,0xF8,0x80,0x1F,0x00,0xC0,0x0F,0x80,0x0F,0xF8,0x80,0x1F,0x00,0xC0,0x0F,0xC0,0x07,0xF0,0x80,0x1F,0x00,0xC0,0x07,0xC0,0x07,0xF0,0x00,0x1F,0x00,0xE0,0x07,0xE0,0x07,0xF0,0x00,0x1F,0x00,0xE0,0x07,0xF0,0x03,0xF0,0x01,0x3F,0x00,0xF0,0x07,0xF0,0x01,0xF0,0x01,0x3F,0x00,0xF8,0x03,0xF8,0x01,0xF0,0x01,0x7E,0x00,0xFC,0x03,0xFE,0x00,0xF0,0x01,0xFE,0x00,0xFE,0x03,0x7F,0x00,0xE0,0x03,0xFC,0x81,0xFF,0xC7,0x3F,0x00,0xE0,0x03,0xFC,0xFF,0xFF,0xFF,0x1F,0x00,0xE0,0x07,0xF8,0xFF,0xE7,0xFF,0x0F,0x00,0xC0,0x07,0xF0,0xFF,0xE3,0xFF,0x07,0x00,0xC0,0x0F,0xE0,0xFF,0xC0,0xFF,0x01,0x00,0x80,0x0F,0x80,0x3F,0x80,0x3F,0x00,0x7E,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,0x3F,0x00,0x00,0x00,0x00,0x80,0x1F,0x00,0x7E,0x00,0x00,0x00,0x00,0xC0,0x1F,0x00,0xFC,0x00,0x00,0x00,0x00,0xE0,0x0F,0x00,0xFC,0x03,0x00,0x00,0x00,0xF0,0x07,0x00,0xF8,0x0F,0x00,0x00,0x00,0xFC,0x03,0x00,0xE0,0x3F,0x00,0x00,0x00,0xFF,0x01,0x00,0xC0,0xFF,0x01,0x00,0xE0,0x7F,0x00,0x00,0x80,0xFF,0x3F,0x00,0xFF,0x3F,0x00,0x00,0x00,0xFE,0xFF,0xFF,0xFF,0x0F,0x00,0x00,0x00,0xF8,0xFF,0xFF,0xFF,0x03,0x00,0x00,0x00,0xC0,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0xFE,0xFF,0x1F,0x00,0x00,  // 0x40 '@'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0xFE,0x01,0x00,0x00,0x00,0x00,0xFE,0x01,0x00,0x00,0x00,0x00,0xFF,0x01,0x00,0x00,0x00,0x00,0xFF,0x03,0x00,0x00,0x00,0x80,0xFF,0x03,0x00,0x00,0x00,0x80,0xEF,0x07,0x00,0x00,0x00,0x80,0xEF,0x07,0x00,0x00,0x00,0xC0,0xCF,0x07,0x00,0x00,0x00,0xC0,0xCF,0x0F,0x00,0x00,0x00,0xC0,0xC7,0x0F,0x00,0x00,0x00,0xE0,0x87,0x1F,0x00,0x00,0x00,0xE0,0x87,0x1F,0x00,0x00,0x00,0xF0,0x83,0x1F,0x00,0x00,0x00,0xF0,0x03,0x3F,0x00,0x00,0x00,0xF0,0x03,0x3F,0x00,0x00,0x00,0xF8,0x01,0x7E,0x00,0x00,0x00,0xF8,0x01,0x7E,0x00,0x00,0x00,0xFC,0x00,0xFE,0x00,0x00,0x00,0xFC,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0xFC,0x00,0x00,0x00,0x7E,0x00,0xF8,0x01,0x00,0x00,0x7E,0x00,0xF8,0x01,0x00,0x00,0x7E,0x00,0xF8,0x03,0x00,0x00,0x3F,0x00,0xF0,0x03,0x00,0x00,0x3F,0x00,0xF0,0x03,0x00,0x80,0x1F,0x00,0xF0,0x07,0x00,0x80,0xFF,0xFF,0xFF,0x07,0x00,0x80,0xFF,0xFF,0xFF,0x0F,0x00,0xC0,0xFF,0xFF,0xFF,0x0F,0x00,0xC0,0xFF,0xFF,0xFF,0x0F,0x00,0xE0,0xFF,0xFF,0xFF,0x1F,0x00,0xE0,0x07,0x00,0x80,0x1F,0x00,0xE0,0x07,0x00,0x80,0x3F,0x00,0xF0,0x07,0x00,0x80,0x3F,0x00,0xF0,0x03,0x00,0x00,0x3F,0x00,0xF0,0x03,0x00,0x00,0x7F,0x00,0xF8,0x01,0x00,0x00,0x7E,0x00,0xF8,0x01,0x00,0x00,0xFE,0x00,0xFC,0x01,0x00,0x00,0xFE,0x00,0xFC,0x00,0x00,0x00,0xFC,0x01,0xFC,0x00,0x00,0x00,0xFC,0x01,0xFE,0x00,0x00,0x00,0xF8,0x01,0x7E,0x00,0x00,0x00,0xF8,0x03,0x7F,0x00,0x00,0x00,0xF8,0x03,0x7F,0x00,0x00,0x00,0xF0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x41 'A'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFF,0xFF,0x03,0x00,0xE0,0xFF,0xFF,0x3F,0x00,0xE0,0xFF,0xFF,0xFF,0x00,0xE0,0xFF,0xFF,0xFF,0x01,0xE0,0xFF,0xFF,0xFF,0x03,0xE0,0xFF,0xFF,0xFF,0x07,0xE0,0x07,0x00,0xF0,0x0F,0xE0,0x07,0x00,0xE0,0x0F,0xE0,0x07,0x00,0xC0,0x1F,0xE0,0x07,0x00,0xC0,0x1F,0xE0,0x07,0x00,0x80,0x1F,0xE0,0x07,0x00,0x80,0x1F,0xE0,0x07,0x00,0x80,0x1F,0xE0,0x07,0x00,0x80,0x1F,0xE0,0x07,0x00,0x80,0x1F,0xE0,0x07,0x00,0x80,0x0F,0xE0,0x07,0x00,0xC0,0x0F,0xE0,0x07,0x00,0xE0,0x07,0xE0,0x07,0x00,0xF0,0x07,0xE0,0xFF,0xFF,0xFF,0x03,0xE0,0xFF,0xFF,0xFF,0x01,0xE0,0xFF,0xFF,0x7F,0x00,0xE0,0xFF,0xFF,0xFF,0x01,0xE0,0xFF,0xFF,0xFF,0x07,0xE0,0xFF,0xFF,0xFF,0x0F,0xE0,0x07,0x00,0xF0,0x1F,0xE0,0x07,0x00,0xC0,0x3F,0xE0,0x07,0x00,0x80,0x3F,0xE0,0x07,0x00,0x00,0x7F,0xE0,0x07,0x00,0x00,0x7F,0xE0,0x07,0x00,0x00,0x7E,0xE0,0x07,0x00,0x00,0x7E,0xE0,0x07,0x00,0x00,0x7E,0xE0,0x07,0x00,0x00,0x7E,0xE0,0x07,0x00,0x00,0x7E,0xE0,0x07,0x00,0x00,0x7E,0xE0,0x07,0x00,0x00,0x7F,0xE0,0x07,0x00,0x00,0x3F,0xE0,0x07,0x00,0x80,0x3F,0xE0,0x07,0x00,0xE0,0x3F,0xE0,0x07,0x00,0xFE,0x1F,0xE0,0xFF,0xFF,0xFF,0x0F,0xE0,0xFF,0xFF,0xFF,0x07,0xE0,0xFF,0xFF,0xFF,0x03,0xE0,0xFF,0xFF,0xFF,0x00,0xE0,0xFF,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x42 'B'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x07,0x00,0x00,0x00,0x00,0xFC,0xFF,0x00,0x00,0x00,0x80,0xFF,0xFF,0x03,0x00,0x00,0xE0,0xFF,0xFF,0x0F,0x00,0x00,0xF0,0xFF,0xFF,0x1F,0x00,0x00,0xFC,0xFF,0xFF,0x3F,0x00,0x00,0xFE,0x07,0xC0,0x7F,0x00,0x00,0xFF,0x01,0x00,0xFF,0x00,0x00,0x7F,0x00,0x00,0xFE,0x01,0x80,0x3F,0x00,0x00,0xFC,0x01,0xC0,0x1F,0x00,0x00,0xF8,0x03,0xC0,0x1F,0x00,0x00,0xF8,0x03,0xE0,0x0F,0x00,0x00,0xF0,0x07,0xE0,0x07,0x00,0x00,0xF0,0x07,0xE0,0x07,0x00,0x00,0xE0,0x00,0xF0,0x07,0x00,0x00,0x00,0x00,0xF0,0x03,0x00,0x00,0x00,0x00,0xF0,0x03,0x00,0x00,0x00,0x00,0xF0,0x03,0x00,0x00,0x00,0x00,0xF8,0x03,0x00,0x00,0x00,0x00,0xF8,0x03,0x00,0x00,0x00,0x00,0xF8,0x03,0x00,0x00,0x00,0x00,0xF8,0x01,0x00,0x00,0x00,0x00,0xF8,0x01,0x00,0x00,0x00,0x00,0xF8,0x01,0x00,0x00,0x00,0x00,0xF8,0x01,0x00,0x00,0x00,0x00,0xF8,0x03,0x00,0x00,0x00,0x00,0xF8,0x03,0x00,0x00,0x00,0x00,0xF0,0x03,0x00,0x00,0x00,0x00,0xF0,0x03,0x00,0x00,0x00,0x00,0xF0,0x03,0x00,0x00,0x00,0x00,0xF0,0x03,0x00,0x00,0xE0,0x00,0xF0,0x07,0x00,0x00,0xE0,0x0F,0xE0,0x07,0x00,0x00,0xE0,0x07,0xE0,0x07,0x00,0x00,0xE0,0x07,0xE0,0x0F,0x00,0x00,0xF0,0x07,0xC0,0x0F,0x00,0x00,0xF0,0x03,0xC0,0x1F,0x00,0x00,0xF8,0x03,0x80,0x3F,0x00,0x00,0xFC,0x01,0x80,0x7F,0x00,0x00,0xFE,0x01,0x00,0xFF,0x01,0x00,0xFF,0x00,0x00,0xFE,0x07,0xC0,0x7F,0x00,0x00,0xFC,0x3F,0xFC,0x3F,0x00,0x00,0xF8,0xFF,0xFF,0x1F,0x00,0x00,0xF0,0xFF,0xFF,0x0F,0x00,0x00,0xC0,0xFF,0xFF,0x03,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x43 'C'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFF,0xFF,0x07,0x00,0x00,0xE0,0xFF,0xFF,0x7F,0x00,0x00,0xE0,0xFF,0xFF,0xFF,0x01,0x00,0xE0,0xFF,0xFF,0xFF,0x07,0x00,0xE0,0xFF,0xFF,0xFF,0x0F,0x00,0xE0,0xFF,0xFF,0xFF,0x1F,0x00,0xE0,0x07,0x00,0xF0,0x3F,0x00,0xE0,0x07,0x00,0xC0,0x7F,0x00,0xE0,0x07,0x00,0x00,0x7F,0x00,0xE0,0x07,0x00,0x00,0xFE,0x00,0xE0,0x07,0x00,0x00,0xFE,0x00,0xE0,0x07,0x00,0x00,0xFC,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x03,0xE0,0x07,0x00,0x00,0xF8,0x03,0xE0,0x07,0x00,0x00,0xF0,0x03,0xE0,0x07,0x00,0x00,0xF0,0x03,0xE0,0x07,0x00,0x00,0xF0,0x03,0xE0,0x07,0x00,0x00,0xF0,0x07,0xE0,0x07,0x00,0x00,0xF0,0x07,0xE0,0x07,0x00,0x00,0xE0,0x07,0xE0,0x07,0x00,0x00,0xE0,0x07,0xE0,0x07,0x00,0x00,0xE0,0x07,0xE0,0x07,0x00,0x00,0xE0,0x07,0xE0,0x07,0x00,0x00,0xE0,0x07,0xE0,0x07,0x00,0x00,0xF0,0x07,0xE0,0x07,0x00,0x00,0xF0,0x07,0xE0,0x07,0x00,0x00,0xF0,0x07,0xE0,0x07,0x00,0x00,0xF0,0x03,0xE0,0x07,0x00,0x00,0xF0,0x03,0xE0,0x07,0x00,0x00,0xF0,0x03,0xE0,0x07,0x00,0x00,0xF8,0x03,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xFC,0x01,0xE0,0x07,0x00,0x00,0xFC,0x00,0xE0,0x07,0x00,0x00,0xFE,0x00,0xE0,0x07,0x00,0x00,0x7F,0x00,0xE0,0x07,0x00,0x80,0x7F,0x00,0xE0,0x07,0x00,0xE0,0x3F,0x00,0xE0,0x07,0x00,0xFF,0x1F,0x00,0xE0,0xFF,0xFF,0xFF,0x0F,0x00,0xE0,0xFF,0xFF,0xFF,0x07,0x00,0xE0,0xFF,0xFF,0xFF,0x01,0x00,0xE0,0xFF,0xFF,0x7F,0x00,0x00,0xE0,0xFF,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x44 'D'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFF,0xFF,0xFF,0x3F,0xE0,0xFF,0xFF,0xFF,0x3F,0xE0,0xFF,0xFF,0xFF,0x3F,0xE0,0xFF,0xFF,0xFF,0x3F,0xE0,0xFF,0xFF,0xFF,0x3F,0xE0,0xFF,0xFF,0xFF,0x3F,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0xFF,0xFF,0xFF,0x0F,0xE0,0xFF,0xFF,0xFF,0x0F,0xE0,0xFF,0xFF,0xFF,0x0F,0xE0,0xFF,0xFF,0xFF,0x0F,0xE0,0xFF,0xFF,0xFF,0x0F,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0xFF,0xFF,0xFF,0x7F,0xE0,0xFF,0xFF,0xFF,0x7F,0xE0,0xFF,0xFF,0xFF,0x7F,0xE0,0xFF,0xFF,0xFF,0x7F,0xE0,0xFF,0xFF,0xFF,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x45 'E'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFF,0xFF,0xFF,0x0F,0xE0,0xFF,0xFF,0xFF,0x0F,0xE0,0xFF,0xFF,0xFF,0x0F,0xE0,0xFF,0xFF,0xFF,0x0F,0xE0,0xFF,0xFF,0xFF,0x0F,0xE0,0xFF,0xFF,0xFF,0x0F,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0xFF,0xFF,0xFF,0x01,0xE0,0xFF,0xFF,0xFF,0x01,0xE0,0xFF,0xFF,0xFF,0x01,0xE0,0xFF,0xFF,0xFF,0x01,0xE0,0xFF,0xFF,0xFF,0x01,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x46 'F'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0xFC,0xFF,0x03,0x00,0x00,0x00,0xFF,0xFF,0x0F,0x00,0x00,0xC0,0xFF,0xFF,0x3F,0x00,0x00,0xF0,0xFF,0xFF,0xFF,0x00,0x00,0xF8,0xFF,0xFF,0xFF,0x01,0x00,0xFC,0x0F,0x00,0xFF,0x03,0x00,0xFE,0x03,0x00,0xFC,0x03,0x00,0xFF,0x00,0x00,0xF0,0x07,0x00,0x7F,0x00,0x00,0xE0,0x07,0x80,0x3F,0x00,0x00,0xE0,0x0F,0xC0,0x1F,0x00,0x00,0xC0,0x0F,0xC0,0x1F,0x00,0x00,0x80,0x1F,0xE0,0x0F,0x00,0x00,0x80,0x1F,0xE0,0x07,0x00,0x00,0x80,0x07,0xE0,0x07,0x00,0x00,0x00,0x00,0xF0,0x07,0x00,0x00,0x00,0x00,0xF0,0x03,0x00,0x00,0x00,0x00,0xF0,0x03,0x00,0x00,0x00,0x00,0xF0,0x03,0x00,0x00,0x00,0x00,0xF0,0x03,0x00,0x00,0x00,0x00,0xF0,0x03,0x00,0x00,0x00,0x00,0xF8,0x03,0x00,0x00,0x00,0x00,0xF8,0x03,0x00,0x00,0x00,0x00,0xF8,0x03,0x00,0xFC,0xFF,0x3F,0xF8,0x03,0x00,0xFC,0xFF,0x3F,0xF8,0x03,0x00,0xFC,0xFF,0x3F,0xF0,0x03,0x00,0xFC,0xFF,0x3F,0xF0,0x03,0x00,0xFC,0xFF,0x3F,0xF0,0x03,0x00,0x00,0x00,0x3F,0xF0,0x03,0x00,0x00,0x00,0x3F,0xF0,0x07,0x00,0x00,0x00,0x3F,0xE0,0x07,0x00,0x00,0x00,0x3F,0xE0,0x07,0x00,0x00,0x00,0x3F,0xE0,0x0F,0x00,0x00,0x00,0x3F,0xC0,0x1F,0x00,0x00,0x00,0x3F,0xC0,0x1F,0x00,0x00,0x00,0x3F,0x80,0x3F,0x00,0x00,0x00,0x3F,0x80,0x7F,0x00,0x00,0x80,0x3F,0x00,0xFF,0x00,0x00,0xE0,0x3F,0x00,0xFE,0x03,0x00,0xF8,0x3F,0x00,0xFC,0x1F,0x00,0xFF,0x1F,0x00,0xF8,0xFF,0xFF,0xFF,0x07,0x00,0xF0,0xFF,0xFF,0xFF,0x03,0x00,0xC0,0xFF,0xFF,0xFF,0x00,0x00,0x00,0xFF,0xFF,0x3F,0x00,0x00,0x00,0xFC,0xFF,0x07,0x00,0x00,0x00,0x80,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x47 'G'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0xFF,0xFF,0xFF,0xFF,0x01,0xE0,0xFF,0xFF,0xFF,0xFF,0x01,0xE0,0xFF,0xFF,0xFF,0xFF,0x01,0xE0,0xFF,0xFF,0xFF,0xFF,0x01,0xE0,0xFF,0xFF,0xFF,0xFF,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x48 'H'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0xC0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x49 'I'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x60,0x00,0xE0,0x07,0x7C,0x00,0xE0,0x07,0x7C,0x00,0xE0,0x07,0xFC,0x00,0xE0,0x07,0xFC,0x00,0xE0,0x07,0xFC,0x00,0xF0,0x07,0xFC,0x01,0xF0,0x03,0xF8,0x01,0xF8,0x03,0xF8,0x07,0xFC,0x03,0xF0,0xFF,0xFF,0x01,0xF0,0xFF,0xFF,0x00,0xE0,0xFF,0x7F,0x00,0xC0,0xFF,0x3F,0x00,0x00,0xFF,0x0F,0x00,0x00,0xF8,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x4A 'J'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0xFE,0x01,0xE0,0x07,0x00,0x00,0xFF,0x00,0xE0,0x07,0x00,0x80,0x7F,0x00,0xE0,0x07,0x00,0xC0,0x3F,0x00,0xE0,0x07,0x00,0xE0,0x1F,0x00,0xE0,0x07,0x00,0xF0,0x0F,0x00,0xE0,0x07,0x00,0xF8,0x07,0x00,0xE0,0x07,0x00,0xFC,0x03,0x00,0xE0,0x07,0x00,0xFE,0x01,0x00,0xE0,0x07,0x00,0xFF,0x00,0x00,0xE0,0x07,0x80,0x7F,0x00,0x00,0xE0,0x07,0xC0,0x3F,0x00,0x00,0xE0,0x07,0xE0,0x1F,0x00,0x00,0xE0,0x07,0xF0,0x0F,0x00,0x00,0xE0,0x07,0xF8,0x07,0x00,0x00,0xE0,0x07,0xFC,0x03,0x00,0x00,0xE0,0x07,0xFE,0x01,0x00,0x00,0xE0,0x07,0xFF,0x00,0x00,0x00,0xE0,0x87,0x7F,0x00,0x00,0x00,0xE0,0xC7,0x7F,0x00,0x00,0x00,0xE0,0xE7,0xFF,0x00,0x00,0x00,0xE0,0xF7,0xFF,0x01,0x00,0x00,0xE0,0xFF,0xFF,0x01,0x00,0x00,0xE0,0xFF,0xFB,0x03,0x00,0x00,0xE0,0xFF,0xF9,0x07,0x00,0x00,0xE0,0x7F,0xF0,0x07,0x00,0x00,0xE0,0x3F,0xE0,0x0F,0x00,0x00,0xE0,0x1F,0xC0,0x1F,0x00,0x00,0xE0,0x0F,0xC0,0x3F,0x00,0x00,0xE0,0x07,0x80,0x3F,0x00,0x00,0xE0,0x07,0x00,0x7F,0x00,0x00,0xE0,0x07,0x00,0xFF,0x00,0x00,0xE0,0x07,0x00,0xFE,0x01,0x00,0xE0,0x07,0x00,0xFC,0x01,0x00,0xE0,0x07,0x00,0xFC,0x03,0x00,0xE0,0x07,0x00,0xF8,0x07,0x00,0xE0,0x07,0x00,0xF0,0x0F,0x00,0xE0,0x07,0x00,0xE0,0x0F,0x00,0xE0,0x07,0x00,0xE0,0x1F,0x00,0xE0,0x07,0x00,0xC0,0x3F,0x00,0xE0,0x07,0x00,0x80,0x7F,0x00,0xE0,0x07,0x00,0x80,0x7F,0x00,0xE0,0x07,0x00,0x00,0xFF,0x00,0xE0,0x07,0x00,0x00,0xFE,0x01,0xE0,0x07,0x00,0x00,0xFC,0x01,0xE0,0x07,0x00,0x00,0xFC,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x4B 'K'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0xFF,0xFF,0xFF,0x01,0xE0,0xFF,0xFF,0xFF,0x01,0xE0,0xFF,0xFF,0xFF,0x01,0xE0,0xFF,0xFF,0xFF,0x01,0xE0,0xFF,0xFF,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x4C 'L'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x3F,0x00,0x00,0x00,0xFF,0xE0,0x3F,0x00,0x00,0x00,0xFF,0xE0,0x7F,0x00,0x00,0x00,0xFF,0xE0,0x7F,0x00,0x00,0x80,0xFF,0xE0,0x7F,0x00,0x00,0x80,0xFF,0xE0,0xFF,0x00,0x00,0xC0,0xFF,0xE0,0xFF,0x00,0x00,0xC0,0xFF,0xE0,0xFF,0x00,0x00,0xC0,0xFF,0xE0,0xFF,0x01,0x00,0xE0,0xFB,0xE0,0xFF,0x01,0x00,0xE0,0xFB,0xE0,0xF7,0x01,0x00,0xE0,0xFB,0xE0,0xF7,0x03,0x00,0xF0,0xF9,0xE0,0xF7,0x03,0x00,0xF0,0xF9,0xE0,0xE7,0x03,0x00,0xF0,0xF9,0xE0,0xE7,0x07,0x00,0xF8,0xF8,0xE0,0xE7,0x07,0x00,0xF8,0xF8,0xE0,0xC7,0x07,0x00,0xF8,0xF8,0xE0,0xC7,0x0F,0x00,0x7C,0xF8,0xE0,0x87,0x0F,0x00,0x7C,0xF8,0xE0,0x87,0x0F,0x00,0x7C,0xF8,0xE0,0x87,0x1F,0x00,0x3E,0xF8,0xE0,0x07,0x1F,0x00,0x3E,0xF8,0xE0,0x07,0x1F,0x00,0x1E,0xF8,0xE0,0x07,0x3F,0x00,0x1F,0xF8,0xE0,0x07,0x3E,0x00,0x1F,0xF8,0xE0,0x07,0x3E,0x00,0x0F,0xF8,0xE0,0x07,0x7E,0x80,0x0F,0xF8,0xE0,0x07,0x7C,0x80,0x0F,0xF8,0xE0,0x07,0x7C,0x80,0x07,0xF8,0xE0,0x07,0xFC,0xC0,0x07,0xF8,0xE0,0x07,0xF8,0xC0,0x07,0xF8,0xE0,0x07,0xF8,0xC0,0x03,0xF8,0xE0,0x07,0xF8,0xE1,0x03,0xF8,0xE0,0x07,0xF0,0xE1,0x03,0xF8,0xE0,0x07,0xF0,0xE1,0x01,0xF8,0xE0,0x07,0xF0,0xF3,0x01,0xF8,0xE0,0x07,0xE0,0xF3,0x01,0xF8,0xE0,0x07,0xE0,0xF3,0x00,0xF8,0xE0,0x07,0xE0,0xFF,0x00,0xF8,0xE0,0x07,0xC0,0xFF,0x00,0xF8,0xE0,0x07,0xC0,0x7F,0x00,0xF8,0xE0,0x07,0xC0,0x7F,0x00,0xF8,0xE0,0x07,0x80,0x7F,0x00,0xF8,0xE0,0x07,0x80,0x3F,0x00,0xF8,0xE0,0x07,0x80,0x3F,0x00,0xF8,0xE0,0x07,0x00,0x1F,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x4D 'M'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x0F,0x00,0x00,0xF8,0x01,0xE0,0x1F,0x00,0x00,0xF8,0x01,0xE0,0x1F,0x00,0x00,0xF8,0x01,0xE0,0x3F,0x00,0x00,0xF8,0x01,0xE0,0x7F,0x00,0x00,0xF8,0x01,0xE0,0x7F,0x00,0x00,0xF8,0x01,0xE0,0xFF,0x00,0x00,0xF8,0x01,0xE0,0xFF,0x01,0x00,0xF8,0x01,0xE0,0xFF,0x01,0x00,0xF8,0x01,0xE0,0xFF,0x03,0x00,0xF8,0x01,0xE0,0xF7,0x07,0x00,0xF8,0x01,0xE0,0xF7,0x07,0x00,0xF8,0x01,0xE0,0xE7,0x0F,0x00,0xF8,0x01,0xE0,0xC7,0x1F,0x00,0xF8,0x01,0xE0,0xC7,0x1F,0x00,0xF8,0x01,0xE0,0x87,0x3F,0x00,0xF8,0x01,0xE0,0x07,0x7F,0x00,0xF8,0x01,0xE0,0x07,0x7F,0x00,0xF8,0x01,0xE0,0x07,0xFE,0x00,0xF8,0x01,0xE0,0x07,0xFC,0x01,0xF8,0x01,0xE0,0x07,0xFC,0x01,0xF8,0x01,0xE0,0x07,0xF8,0x03,0xF8,0x01,0xE0,0x07,0xF0,0x07,0xF8,0x01,0xE0,0x07,0xF0,0x07,0xF8,0x01,0xE0,0x07,0xE0,0x0F,0xF8,0x01,0xE0,0x07,0xC0,0x1F,0xF8,0x01,0xE0,0x07,0xC0,0x1F,0xF8,0x01,0xE0,0x07,0x80,0x3F,0xF8,0x01,0xE0,0x07,0x00,0x7F,0xF8,0x01,0xE0,0x07,0x00,0x7F,0xF8,0x01,0xE0,0x07,0x00,0xFE,0xF8,0x01,0xE0,0x07,0x00,0xFC,0xF9,0x01,0xE0,0x07,0x00,0xFC,0xF9,0x01,0xE0,0x07,0x00,0xF8,0xFB,0x01,0xE0,0x07,0x00,0xF0,0xFF,0x01,0xE0,0x07,0x00,0xF0,0xFF,0x01,0xE0,0x07,0x00,0xE0,0xFF,0x01,0xE0,0x07,0x00,0xC0,0xFF,0x01,0xE0,0x07,0x00,0xC0,0xFF,0x01,0xE0,0x07,0x00,0x80,0xFF,0x01,0xE0,0x07,0x00,0x00,0xFF,0x01,0xE0,0x07,0x00,0x00,0xFF,0x01,0xE0,0x07,0x00,0x00,0xFE,0x01,0xE0,0x07,0x00,0x00,0xFC,0x01,0xE0,0x07,0x00,0x00,0xFC,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x4E 'N'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x0F,0x00,0x00,0x00,0x00,0xFC,0xFF,0x00,0x00,0x00,0x80,0xFF,0xFF,0x07,0x00,0x00,0xE0,0xFF,0xFF,0x1F,0x00,0x00,0xF0,0xFF,0xFF,0x3F,0x00,0x00,0xF8,0xFF,0xFF,0x7F,0x00,0x00,0xFC,0x0F,0xC0,0xFF,0x00,0x00,0xFE,0x01,0x00,0xFE,0x01,0x00,0xFF,0x00,0x00,0xFC,0x03,0x80,0x7F,0x00,0x00,0xF8,0x07,0xC0,0x3F,0x00,0x00,0xF0,0x0F,0xC0,0x1F,0x00,0x00,0xE0,0x0F,0xE0,0x0F,0x00,0x00,0xC0,0x1F,0xE0,0x07,0x00,0x00,0xC0,0x1F,0xE0,0x07,0x00,0x00,0x80,0x1F,0xF0,0x07,0x00,0x00,0x80,0x3F,0xF0,0x03,0x00,0x00,0x00,0x3F,0xF0,0x03,0x00,0x00,0x00,0x3F,0xF0,0x03,0x00,0x00,0x00,0x3F,0xF8,0x03,0x00,0x00,0x00,0x7F,0xF8,0x03,0x00,0x00,0x00,0x7F,0xF8,0x01,0x00,0x00,0x00,0x7E,0xF8,0x01,0x00,0x00,0x00,0x7E,0xF8,0x01,0x00,0x00,0x00,0x7E,0xF8,0x01,0x00,0x00,0x00,0x7E,0xF8,0x01,0x00,0x00,0x00,0x7E,0xF8,0x01,0x00,0x00,0x00,0x7E,0xF8,0x01,0x00,0x00,0x00,0x7F,0xF8,0x03,0x00,0x00,0x00,0x7F,0xF0,0x03,0x00,0x00,0x00,0x3F,0xF0,0x03,0x00,0x00,0x00,0x3F,0xF0,0x03,0x00,0x00,0x00,0x3F,0xF0,0x07,0x00,0x00,0x80,0x3F,0xE0,0x07,0x00,0x00,0x80,0x1F,0xE0,0x07,0x00,0x00,0x80,0x1F,0xE0,0x0F,0x00,0x00,0xC0,0x1F,0xC0,0x1F,0x00,0x00,0xE0,0x0F,0xC0,0x1F,0x00,0x00,0xF0,0x0F,0x80,0x3F,0x00,0x00,0xF0,0x07,0x00,0xFF,0x00,0x00,0xFC,0x03,0x00,0xFE,0x01,0x00,0xFE,0x03,0x00,0xFE,0x07,0x80,0xFF,0x01,0x00,0xF8,0x7F,0xF8,0xFF,0x00,0x00,0xF0,0xFF,0xFF,0x3F,0x00,0x00,0xE0,0xFF,0xFF,0x1F,0x00,0x00,0x80,0xFF,0xFF,0x07,0x00,0x00,0x00,0xFE,0xFF,0x01,0x00,0x00,0x00,0xE0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x4F 'O'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFF,0xFF,0x0F,0x00,0xE0,0xFF,0xFF,0xFF,0x00,0xE0,0xFF,0xFF,0xFF,0x03,0xE0,0xFF,0xFF,0xFF,0x0F,0xE0,0xFF,0xFF,0xFF,0x1F,0xE0,0xFF,0xFF,0xFF,0x3F,0xE0,0x07,0x00,0xC0,0x3F,0xE0,0x07,0x00,0x80,0x7F,0xE0,0x07,0x00,0x00,0x7F,0xE0,0x07,0x00,0x00,0x7E,0xE0,0x07,0x00,0x00,0xFE,0xE0,0x07,0x00,0x00,0xFE,0xE0,0x07,0x00,0x00,0xFC,0xE0,0x07,0x00,0x00,0xFC,0xE0,0x07,0x00,0x00,0xFC,0xE0,0x07,0x00,0x00,0xFC,0xE0,0x07,0x00,0x00,0xFE,0xE0,0x07,0x00,0x00,0x7E,0xE0,0x07,0x00,0x00,0x7F,0xE0,0x07,0x00,0x80,0x7F,0xE0,0x07,0x00,0xC0,0x3F,0xE0,0x07,0x00,0xF0,0x3F,0xE0,0xFF,0xFF,0xFF,0x1F,0xE0,0xFF,0xFF,0xFF,0x0F,0xE0,0xFF,0xFF,0xFF,0x07,0xE0,0xFF,0xFF,0xFF,0x01,0xE0,0xFF,0xFF,0x3F,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x50 'P'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x07,0x00,0x00,0x00,0x00,0xFE,0xFF,0x00,0x00,0x00,0x80,0xFF,0xFF,0x03,0x00,0x00,0xE0,0xFF,0xFF,0x0F,0x00,0x00,0xF8,0xFF,0xFF,0x3F,0x00,0x00,0xFC,0xFF,0xFF,0x7F,0x00,0x00,0xFE,0x07,0xC0,0xFF,0x00,0x00,0xFF,0x01,0x00,0xFF,0x01,0x80,0x7F,0x00,0x00,0xFC,0x03,0x80,0x3F,0x00,0x00,0xF8,0x07,0xC0,0x1F,0x00,0x00,0xF0,0x07,0xC0,0x0F,0x00,0x00,0xE0,0x0F,0xE0,0x0F,0x00,0x00,0xE0,0x0F,0xE0,0x07,0x00,0x00,0xC0,0x1F,0xF0,0x07,0x00,0x00,0xC0,0x1F,0xF0,0x03,0x00,0x00,0x80,0x1F,0xF0,0x03,0x00,0x00,0x80,0x3F,0xF8,0x03,0x00,0x00,0x00,0x3F,0xF8,0x01,0x00,0x00,0x00,0x3F,0xF8,0x01,0x00,0x00,0x00,0x3F,0xF8,0x01,0x00,0x00,0x00,0x3F,0xF8,0x01,0x00,0x00,0x00,0x3F,0xF8,0x01,0x00,0x00,0x00,0x7F,0xF8,0x01,0x00,0x00,0x00,0x7F,0xF8,0x01,0x00,0x00,0x00,0x7F,0xF8,0x01,0x00,0x00,0x00,0x7F,0xF8,0x01,0x00,0x00,0x00,0x3F,0xF8,0x01,0x00,0x00,0x00,0x3F,0xF8,0x01,0x00,0x00,0x00,0x3F,0xF8,0x01,0x00,0x00,0x00,0x3F,0xF8,0x03,0x00,0x00,0x00,0x3F,0xF0,0x03,0x00,0x00,0x80,0x3F,0xF0,0x03,0x00,0x00,0x80,0x1F,0xF0,0x07,0x00,0x00,0x80,0x1F,0xE0,0x07,0x00,0x04,0xC0,0x1F,0xE0,0x0F,0x00,0x3C,0xC0,0x0F,0xC0,0x0F,0x00,0xFC,0xE0,0x0F,0xC0,0x1F,0x00,0xFE,0xF1,0x07,0x80,0x3F,0x00,0xFE,0xFF,0x07,0x80,0x7F,0x00,0xF8,0xFF,0x03,0x00,0xFF,0x01,0xE0,0xFF,0x01,0x00,0xFE,0x07,0x80,0xFF,0x00,0x00,0xFC,0x7F,0xFC,0xFF,0x00,0x00,0xF8,0xFF,0xFF,0xFF,0x03,0x00,0xE0,0xFF,0xFF,0xFF,0x0F,0x00,0x80,0xFF,0xFF,0xE7,0x1F,0x00,0x00,0xFE,0xFF,0xC0,0x7F,0x00,0x00,0xE0,0x0F,0x80,0x7F,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x51 'Q'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFF,0xFF,0x7F,0x00,0x00,0xE0,0xFF,0xFF,0xFF,0x07,0x00,0xE0,0xFF,0xFF,0xFF,0x1F,0x00,0xE0,0xFF,0xFF,0xFF,0x3F,0x00,0xE0,0xFF,0xFF,0xFF,0x7F,0x00,0xE0,0x07,0x00,0xE0,0xFF,0x00,0xE0,0x07,0x00,0x00,0xFF,0x00,0xE0,0x07,0x00,0x00,0xFE,0x01,0xE0,0x07,0x00,0x00,0xFC,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x03,0xE0,0x07,0x00,0x00,0xF8,0x03,0xE0,0x07,0x00,0x00,0xF8,0x03,0xE0,0x07,0x00,0x00,0xF8,0x03,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xFC,0x01,0xE0,0x07,0x00,0x00,0xFC,0x01,0xE0,0x07,0x00,0x00,0xFE,0x00,0xE0,0x07,0x00,0x80,0xFF,0x00,0xE0,0xFF,0xFF,0xFF,0x7F,0x00,0xE0,0xFF,0xFF,0xFF,0x3F,0x00,0xE0,0xFF,0xFF,0xFF,0x1F,0x00,0xE0,0xFF,0xFF,0xFF,0x07,0x00,0xE0,0xFF,0xFF,0xFF,0x00,0x00,0xE0,0xFF,0xFF,0x1F,0x00,0x00,0xE0,0x07,0x80,0x7F,0x00,0x00,0xE0,0x07,0x00,0xFE,0x00,0x00,0xE0,0x07,0x00,0xFC,0x01,0x00,0xE0,0x07,0x00,0xF8,0x03,0x00,0xE0,0x07,0x00,0xF0,0x07,0x00,0xE0,0x07,0x00,0xF0,0x0F,0x00,0xE0,0x07,0x00,0xE0,0x1F,0x00,0xE0,0x07,0x00,0xC0,0x1F,0x00,0xE0,0x07,0x00,0xC0,0x3F,0x00,0xE0,0x07,0x00,0x80,0x7F,0x00,0xE0,0x07,0x00,0x00,0x7F,0x00,0xE0,0x07,0x00,0x00,0xFF,0x00,0xE0,0x07,0x00,0x00,0xFE,0x01,0xE0,0x07,0x00,0x00,0xFC,0x01,0xE0,0x07,0x00,0x00,0xFC,0x03,0xE0,0x07,0x00,0x00,0xF8,0x07,0xE0,0x07,0x00,0x00,0xF0,0x07,0xE0,0x07,0x00,0x00,0xF0,0x0F,0xE0,0x07,0x00,0x00,0xE0,0x0F,0xE0,0x07,0x00,0x00,0xE0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x52 'R'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0xC0,0xFF,0x0F,0x00,0x00,0xF8,0xFF,0x7F,0x00,0x00,0xFC,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0xFF,0x03,0x80,0xFF,0xFF,0xFF,0x07,0x80,0x7F,0x00,0xFC,0x07,0xC0,0x1F,0x00,0xF0,0x0F,0xC0,0x0F,0x00,0xC0,0x1F,0xE0,0x07,0x00,0xC0,0x1F,0xE0,0x07,0x00,0x80,0x1F,0xE0,0x07,0x00,0x80,0x3F,0xE0,0x03,0x00,0x00,0x3F,0xE0,0x07,0x00,0x00,0x3F,0xE0,0x07,0x00,0x00,0x01,0xE0,0x07,0x00,0x00,0x00,0xE0,0x0F,0x00,0x00,0x00,0xC0,0x1F,0x00,0x00,0x00,0xC0,0xFF,0x00,0x00,0x00,0x80,0xFF,0x07,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,0xFE,0xFF,0x0F,0x00,0x00,0xFC,0xFF,0x7F,0x00,0x00,0xF0,0xFF,0xFF,0x01,0x00,0x80,0xFF,0xFF,0x03,0x00,0x00,0xF8,0xFF,0x0F,0x00,0x00,0x80,0xFF,0x1F,0x00,0x00,0x00,0xFC,0x1F,0x00,0x00,0x00,0xE0,0x3F,0x00,0x00,0x00,0x80,0x3F,0x00,0x00,0x00,0x00,0x7F,0x00,0x00,0x00,0x00,0x7E,0xF8,0x01,0x00,0x00,0x7E,0xF8,0x01,0x00,0x00,0x7E,0xF8,0x01,0x00,0x00,0x7E,0xF8,0x01,0x00,0x00,0x7E,0xF0,0x03,0x00,0x00,0x7E,0xF0,0x07,0x00,0x00,0x7E,0xF0,0x07,0x00,0x00,0x7F,0xE0,0x0F,0x00,0x80,0x3F,0xE0,0x3F,0x00,0xC0,0x3F,0xC0,0xFF,0x00,0xF0,0x1F,0x80,0xFF,0xFF,0xFF,0x0F,0x00,0xFF,0xFF,0xFF,0x07,0x00,0xFE,0xFF,0xFF,0x03,0x00,0xF8,0xFF,0xFF,0x00,0x00,0xE0,0xFF,0x3F,0x00,0x00,0x00,0xFC,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x53 'S'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFF,0xFF,0xFF,0x3F,0xFE,0xFF,0xFF,0xFF,0x3F,0xFE,0xFF,0xFF,0xFF,0x3F,0xFE,0xFF,0xFF,0xFF,0x3F,0xFE,0xFF,0xFF,0xFF,0x3F,0xFE,0xFF,0xFF,0xFF,0x3F,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x54 'T'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xE0,0x07,0x00,0x00,0xF8,0x01,0xC0,0x0F,0x00,0x00,0xFC,0x01,0xC0,0x0F,0x00,0x00,0xFC,0x00,0xC0,0x0F,0x00,0x00,0xFC,0x00,0xC0,0x1F,0x00,0x00,0xFE,0x00,0x80,0x1F,0x00,0x00,0xFE,0x00,0x80,0x3F,0x00,0x00,0x7F,0x00,0x80,0xFF,0x00,0x80,0x7F,0x00,0x00,0xFF,0x03,0xE0,0x3F,0x00,0x00,0xFE,0xFF,0xFF,0x1F,0x00,0x00,0xFC,0xFF,0xFF,0x0F,0x00,0x00,0xF8,0xFF,0xFF,0x07,0x00,0x00,0xE0,0xFF,0xFF,0x01,0x00,0x00,0x80,0xFF,0x7F,0x00,0x00,0x00,0x00,0xF8,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x55 'U'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0x00,0x00,0xF0,0x03,0x7E,0x00,0x00,0x00,0xF0,0x03,0xFE,0x00,0x00,0x00,0xF8,0x01,0xFC,0x00,0x00,0x00,0xF8,0x01,0xFC,0x00,0x00,0x00,0xFC,0x00,0xFC,0x01,0x00,0x00,0xFC,0x00,0xF8,0x01,0x00,0x00,0xFC,0x00,0xF8,0x01,0x00,0x00,0x7E,0x00,0xF0,0x03,0x00,0x00,0x7E,0x00,0xF0,0x03,0x00,0x00,0x7E,0x00,0xF0,0x07,0x00,0x00,0x3F,0x00,0xE0,0x07,0x00,0x00,0x3F,0x00,0xE0,0x07,0x00,0x80,0x1F,0x00,0xE0,0x0F,0x00,0x80,0x1F,0x00,0xC0,0x0F,0x00,0x80,0x1F,0x00,0xC0,0x0F,0x00,0xC0,0x0F,0x00,0x80,0x1F,0x00,0xC0,0x0F,0x00,0x80,0x1F,0x00,0xC0,0x07,0x00,0x80,0x1F,0x00,0xE0,0x07,0x00,0x00,0x3F,0x00,0xE0,0x07,0x00,0x00,0x3F,0x00,0xF0,0x03,0x00,0x00,0x3E,0x00,0xF0,0x03,0x00,0x00,0x7E,0x00,0xF0,0x01,0x00,0x00,0x7E,0x00,0xF8,0x01,0x00,0x00,0xFC,0x00,0xF8,0x01,0x00,0x00,0xFC,0x00,0xF8,0x00,0x00,0x00,0xFC,0x00,0xFC,0x00,0x00,0x00,0xF8,0x01,0x7C,0x00,0x00,0x00,0xF8,0x01,0x7E,0x00,0x00,0x00,0xF0,0x01,0x7E,0x00,0x00,0x00,0xF0,0x03,0x3E,0x00,0x00,0x00,0xF0,0x03,0x3F,0x00,0x00,0x00,0xE0,0x03,0x3F,0x00,0x00,0x00,0xE0,0x07,0x1F,0x00,0x00,0x00,0xC0,0x87,0x1F,0x00,0x00,0x00,0xC0,0x87,0x0F,0x00,0x00,0x00,0xC0,0x8F,0x0F,0x00,0x00,0x00,0x80,0xCF,0x0F,0x00,0x00,0x00,0x80,0xCF,0x07,0x00,0x00,0x00,0x00,0xDF,0x07,0x00,0x00,0x00,0x00,0xFF,0x03,0x00,0x00,0x00,0x00,0xFF,0x03,0x00,0x00,0x00,0x00,0xFE,0x03,0x00,0x00,0x00,0x00,0xFE,0x01,0x00,0x00,0x00,0x00,0xFE,0x01,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x56 'V'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0xF8,0x03,0x00,0xC0,0x0F,0x7E,0x00,0x00,0xFC,0x03,0x00,0xE0,0x07,0xFE,0x00,0x00,0xFC,0x07,0x00,0xE0,0x07,0xFC,0x00,0x00,0xFC,0x07,0x00,0xE0,0x07,0xFC,0x00,0x00,0xFE,0x07,0x00,0xE0,0x07,0xFC,0x00,0x00,0xFE,0x0F,0x00,0xF0,0x03,0xFC,0x00,0x00,0xFE,0x0F,0x00,0xF0,0x03,0xF8,0x01,0x00,0xBE,0x0F,0x00,0xF0,0x03,0xF8,0x01,0x00,0xBF,0x0F,0x00,0xF0,0x01,0xF8,0x01,0x00,0x9F,0x1F,0x00,0xF8,0x01,0xF0,0x01,0x00,0x9F,0x1F,0x00,0xF8,0x01,0xF0,0x03,0x80,0x1F,0x1F,0x00,0xF8,0x01,0xF0,0x03,0x80,0x0F,0x1F,0x00,0xF8,0x00,0xF0,0x03,0x80,0x0F,0x3F,0x00,0xFC,0x00,0xE0,0x03,0x80,0x0F,0x3E,0x00,0xFC,0x00,0xE0,0x07,0xC0,0x0F,0x3E,0x00,0x7C,0x00,0xE0,0x07,0xC0,0x07,0x7E,0x00,0x7C,0x00,0xE0,0x07,0xC0,0x07,0x7E,0x00,0x7E,0x00,0xC0,0x07,0xC0,0x07,0x7C,0x00,0x7E,0x00,0xC0,0x07,0xE0,0x07,0x7C,0x00,0x3E,0x00,0xC0,0x0F,0xE0,0x03,0xFC,0x00,0x3E,0x00,0xC0,0x0F,0xE0,0x03,0xF8,0x00,0x3F,0x00,0x80,0x0F,0xF0,0x03,0xF8,0x00,0x3F,0x00,0x80,0x0F,0xF0,0x01,0xF8,0x01,0x1F,0x00,0x80,0x1F,0xF0,0x01,0xF8,0x01,0x1F,0x00,0x80,0x1F,0xF0,0x01,0xF0,0x81,0x1F,0x00,0x00,0x1F,0xF8,0x01,0xF0,0x81,0x0F,0x00,0x00,0x1F,0xF8,0x00,0xF0,0x83,0x0F,0x00,0x00,0x3F,0xF8,0x00,0xF0,0x83,0x0F,0x00,0x00,0x3E,0xFC,0x00,0xE0,0xC3,0x0F,0x00,0x00,0x3E,0x7C,0x00,0xE0,0xC3,0x07,0x00,0x00,0x3E,0x7C,0x00,0xE0,0xC7,0x07,0x00,0x00,0x3E,0x7C,0x00,0xC0,0xC7,0x07,0x00,0x00,0x7C,0x7E,0x00,0xC0,0xE7,0x07,0x00,0x00,0x7C,0x3E,0x00,0xC0,0xE7,0x03,0x00,0x00,0x7C,0x3E,0x00,0xC0,0xE7,0x03,0x00,0x00,0x7C,0x3E,0x00,0x80,0xEF,0x03,0x00,0x00,0xF8,0x1F,0x00,0x80,0xEF,0x01,0x00,0x00,0xF8,0x1F,0x00,0x80,0xFF,0x01,0x00,0x00,0xF8,0x1F,0x00,0x80,0xFF,0x01,0x00,0x00,0xF8,0x1F,0x00,0x00,0xFF,0x01,0x00,0x00,0xF0,0x0F,0x00,0x00,0xFF,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0xFF,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0xFE,0x00,0x00,0x00,0xE0,0x0F,0x00,0x00,0xFE,0x00,0x00,0x00,0xE0,0x07,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x57 'W'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x03,0x00,0x00,0xFC,0x01,0xF8,0x07,0x00,0x00,0xFE,0x00,0xF0,0x07,0x00,0x00,0x7E,0x00,0xE0,0x0F,0x00,0x00,0x7F,0x00,0xE0,0x1F,0x00,0x80,0x3F,0x00,0xC0,0x1F,0x00,0xC0,0x1F,0x00,0x80,0x3F,0x00,0xC0,0x0F,0x00,0x00,0x7F,0x00,0xE0,0x0F,0x00,0x00,0x7F,0x00,0xF0,0x07,0x00,0x00,0xFE,0x00,0xF8,0x03,0x00,0x00,0xFC,0x01,0xF8,0x01,0x00,0x00,0xFC,0x03,0xFC,0x01,0x00,0x00,0xF8,0x03,0xFE,0x00,0x00,0x00,0xF0,0x07,0x7F,0x00,0x00,0x00,0xE0,0x0F,0x3F,0x00,0x00,0x00,0xE0,0x8F,0x3F,0x00,0x00,0x00,0xC0,0xDF,0x1F,0x00,0x00,0x00,0x80,0xFF,0x0F,0x00,0x00,0x00,0x80,0xFF,0x07,0x00,0x00,0x00,0x00,0xFF,0x07,0x00,0x00,0x00,0x00,0xFE,0x03,0x00,0x00,0x00,0x00,0xFC,0x01,0x00,0x00,0x00,0x00,0xFC,0x01,0x00,0x00,0x00,0x00,0xFE,0x03,0x00,0x00,0x00,0x00,0xFF,0x07,0x00,0x00,0x00,0x80,0xFF,0x0F,0x00,0x00,0x00,0x80,0xFF,0x0F,0x00,0x00,0x00,0xC0,0xDF,0x1F,0x00,0x00,0x00,0xE0,0xCF,0x3F,0x00,0x00,0x00,0xE0,0x87,0x3F,0x00,0x00,0x00,0xF0,0x07,0x7F,0x00,0x00,0x00,0xF8,0x03,0xFE,0x00,0x00,0x00,0xFC,0x01,0xFE,0x01,0x00,0x00,0xFC,0x01,0xFC,0x01,0x00,0x00,0xFE,0x00,0xF8,0x03,0x00,0x00,0x7F,0x00,0xF8,0x07,0x00,0x80,0x3F,0x00,0xF0,0x07,0x00,0x80,0x3F,0x00,0xE0,0x0F,0x00,0xC0,0x1F,0x00,0xE0,0x1F,0x00,0xE0,0x0F,0x00,0xC0,0x3F,0x00,0xF0,0x0F,0x00,0x80,0x3F,0x00,0xF0,0x07,0x00,0x00,0x7F,0x00,0xF8,0x03,0x00,0x00,0xFF,0x00,0xFC,0x01,0x00,0x00,0xFE,0x00,0xFE,0x01,0x00,0x00,0xFC,0x01,0xFE,0x00,0x00,0x00,0xFC,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x58 'X'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xF8,0x03,0xFE,0x00,0x00,0x00,0xFC,0x01,0xFC,0x01,0x00,0x00,0xFC,0x01,0xFC,0x03,0x00,0x00,0xFE,0x00,0xF8,0x03,0x00,0x00,0x7F,0x00,0xF0,0x07,0x00,0x00,0x7F,0x00,0xF0,0x0F,0x00,0x80,0x3F,0x00,0xE0,0x0F,0x00,0xC0,0x1F,0x00,0xC0,0x1F,0x00,0xC0,0x0F,0x00,0xC0,0x3F,0x00,0xE0,0x0F,0x00,0x80,0x3F,0x00,0xF0,0x07,0x00,0x00,0x7F,0x00,0xF0,0x03,0x00,0x00,0xFF,0x00,0xF8,0x03,0x00,0x00,0xFE,0x00,0xFC,0x01,0x00,0x00,0xFC,0x01,0xFC,0x00,0x00,0x00,0xFC,0x03,0xFE,0x00,0x00,0x00,0xF8,0x03,0x7F,0x00,0x00,0x00,0xF0,0x07,0x3F,0x00,0x00,0x00,0xF0,0x87,0x3F,0x00,0x00,0x00,0xE0,0x8F,0x1F,0x00,0x00,0x00,0xC0,0xDF,0x0F,0x00,0x00,0x00,0xC0,0xFF,0x07,0x00,0x00,0x00,0x80,0xFF,0x07,0x00,0x00,0x00,0x00,0xFF,0x03,0x00,0x00,0x00,0x00,0xFF,0x01,0x00,0x00,0x00,0x00,0xFE,0x01,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x59 'Y'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0xFF,0xFF,0x1F,0xF0,0xFF,0xFF,0xFF,0x1F,0xF0,0xFF,0xFF,0xFF,0x1F,0xF0,0xFF,0xFF,0xFF,0x1F,0xF0,0xFF,0xFF,0xFF,0x1F,0xF0,0xFF,0xFF,0xFF,0x1F,0x00,0x00,0x00,0xE0,0x0F,0x00,0x00,0x00,0xF0,0x07,0x00,0x00,0x00,0xF8,0x03,0x00,0x00,0x00,0xFC,0x03,0x00,0x00,0x00,0xFE,0x01,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x7F,0x00,0x00,0x00,0x80,0x3F,0x00,0x00,0x00,0xC0,0x3F,0x00,0x00,0x00,0xE0,0x1F,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0x00,0xF0,0x07,0x00,0x00,0x00,0xF8,0x03,0x00,0x00,0x00,0xFC,0x01,0x00,0x00,0x00,0xFE,0x01,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x7F,0x00,0x00,0x00,0x80,0x3F,0x00,0x00,0x00,0xC0,0x1F,0x00,0x00,0x00,0xE0,0x1F,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0x00,0xF0,0x07,0x00,0x00,0x00,0xF8,0x03,0x00,0x00,0x00,0xFC,0x01,0x00,0x00,0x00,0xFE,0x01,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x7F,0x00,0x00,0x00,0x80,0x3F,0x00,0x00,0x00,0xC0,0x1F,0x00,0x00,0x00,0xE0,0x1F,0x00,0x00,0x00,0xF0,0x0F,0x00,0x00,0x00,0xF0,0x07,0x00,0x00,0x00,0xF8,0x03,0x00,0x00,0x00,0xFC,0x01,0x00,0x00,0x00,0xFE,0x00,0x00,0x00,0x00,0xFE,0xFF,0xFF,0xFF,0x3F,0xFE,0xFF,0xFF,0xFF,0x3F,0xFE,0xFF,0xFF,0xFF,0x3F,0xFE,0xFF,0xFF,0xFF,0x3F,0xFE,0xFF,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x5A 'Z'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0x01,0xF0,0xFF,0x01,0xF0,0xFF,0x01,0xF0,0xFF,0x01,0xF0,0xFF,0x01,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0xFF,0x01,0xF0,0xFF,0x01,0xF0,0xFF,0x01,0xF0,0xFF,0x01,0xF0,0xFF,0x01,  // 0x5B '['
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1E,0x00,0x00,0x1E,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x3C,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0xF8,0x00,0x00,0xF8,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x03,0x00,0xE0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x03,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0x80,0x07,0x00,0x80,0x0F,0x00,0x80,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1E,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x78,0x00,0x00,0x78,0x00,0x00,0xF8,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0xF0,0x01,0x00,0xF0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x01,0x00,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x5C '\\'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x3F,0xFE,0x3F,0xFE,0x3F,0xFE,0x3F,0xFE,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0x00,0x3F,0xFE,0x3F,0xFE,0x3F,0xFE,0x3F,0xFE,0x3F,0xFE,0x3F,  // 0x5D ']'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x01,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF8,0x07,0x00,0x00,0xF8,0x07,0x00,0x00,0xFC,0x0F,0x00,0x00,0xFC,0x0F,0x00,0x00,0xFC,0x0F,0x00,0x00,0x3E,0x1F,0x00,0x00,0x3E,0x1F,0x00,0x00,0x1F,0x3E,0x00,0x00,0x1F,0x3E,0x00,0x80,0x1F,0x7E,0x00,0x80,0x0F,0x7C,0x00,0x80,0x0F,0x7C,0x00,0xC0,0x07,0xF8,0x00,0xC0,0x07,0xF8,0x00,0xE0,0x07,0xF8,0x01,0xE0,0x03,0xF0,0x01,0xF0,0x03,0xF0,0x03,0xF0,0x01,0xE0,0x03,0xF8,0x01,0xE0,0x07,0xF8,0x01,0xE0,0x07,0xF8,0x00,0xC0,0x07,0xFC,0x00,0xC0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x5E '^'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x0F,0xFF,0xFF,0xFF,0xFF,0x0F,0xFF,0xFF,0xFF,0xFF,0x0F,0xFF,0xFF,0xFF,0xFF,0x0F,  // 0x5F '_'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x07,0xF0,0x07,0xE0,0x0F,0xC0,0x0F,0x80,0x1F,0x80,0x1F,0x00,0x1F,0x00,0x3E,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x60 '`'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x7F,0x00,0x00,0x00,0xFC,0xFF,0x03,0x00,0x00,0xFF,0xFF,0x0F,0x00,0x80,0xFF,0xFF,0x1F,0x00,0xC0,0xFF,0xFF,0x3F,0x00,0xE0,0x1F,0xC0,0x3F,0x00,0xE0,0x07,0x00,0x7F,0x00,0xF0,0x03,0x00,0x7E,0x00,0xF0,0x03,0x00,0x7E,0x00,0xF8,0x01,0x00,0x7E,0x00,0xE0,0x01,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x80,0x7F,0x00,0x00,0x00,0xFC,0x7F,0x00,0x00,0xF8,0xFF,0x7F,0x00,0x00,0xFF,0xFF,0x7F,0x00,0xC0,0xFF,0xFF,0x7F,0x00,0xE0,0xFF,0x3F,0x7E,0x00,0xF0,0xFF,0x00,0x7E,0x00,0xF0,0x0F,0x00,0x7E,0x00,0xF8,0x03,0x00,0x7E,0x00,0xF8,0x01,0x00,0x7E,0x00,0xFC,0x01,0x00,0x7E,0x00,0xFC,0x00,0x00,0x7E,0x00,0xFC,0x00,0x00,0x7F,0x00,0xFC,0x00,0x00,0x7F,0x00,0xF8,0x01,0x80,0x7F,0x00,0xF8,0x03,0xE0,0x7F,0x00,0xF8,0x07,0xF0,0x7F,0x00,0xF0,0xFF,0xFF,0xFD,0x00,0xE0,0xFF,0xFF,0xFC,0x00,0xC0,0xFF,0x3F,0xFC,0x00,0x80,0xFF,0x0F,0xF8,0x01,0x00,0xF8,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x61 'a'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF8,0x81,0x3F,0x00,0xF8,0xE1,0xFF,0x00,0xF8,0xF9,0xFF,0x03,0xF8,0xFD,0xFF,0x07,0xF8,0xFF,0xFF,0x0F,0xF8,0x3F,0xE0,0x1F,0xF8,0x1F,0x80,0x3F,0xF8,0x0F,0x00,0x3F,0xF8,0x07,0x00,0x7F,0xF8,0x03,0x00,0x7E,0xF8,0x03,0x00,0x7E,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0xFC,0xF8,0x01,0x00,0x7C,0xF8,0x03,0x00,0x7E,0xF8,0x03,0x00,0x7E,0xF8,0x07,0x00,0x3F,0xF8,0x0F,0x80,0x3F,0xF8,0x1F,0xC0,0x1F,0xF8,0x3F,0xE0,0x1F,0xF8,0xFF,0xFF,0x0F,0xF8,0xFD,0xFF,0x07,0xF8,0xF9,0xFF,0x01,0xF8,0xE1,0xFF,0x00,0x00,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x62 'b'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x3F,0x00,0x00,0xF8,0xFF,0x00,0x00,0xFE,0xFF,0x03,0x00,0xFF,0xFF,0x07,0x80,0xFF,0xFF,0x0F,0xC0,0x3F,0xE0,0x1F,0xE0,0x0F,0x80,0x3F,0xE0,0x07,0x00,0x3F,0xF0,0x03,0x00,0x3F,0xF0,0x03,0x00,0x7E,0xF8,0x01,0x00,0x7E,0xF8,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF8,0x01,0x00,0x00,0xF8,0x01,0x00,0x7C,0xF8,0x01,0x00,0x7C,0xF8,0x01,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x3F,0xE0,0x07,0x00,0x3F,0xE0,0x0F,0x80,0x1F,0xC0,0x3F,0xE0,0x1F,0x80,0xFF,0xFF,0x0F,0x00,0xFF,0xFF,0x07,0x00,0xFE,0xFF,0x01,0x00,0xF8,0xFF,0x00,0x00,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x63 'c'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x7E,0x00,0xE0,0x0F,0x7E,0x00,0xFC,0x3F,0x7E,0x00,0xFF,0x7F,0x7E,0x80,0xFF,0xFF,0x7E,0xC0,0xFF,0xFF,0x7F,0xE0,0x1F,0xF0,0x7F,0xE0,0x0F,0xC0,0x7F,0xF0,0x07,0x80,0x7F,0xF0,0x03,0x00,0x7F,0xF8,0x01,0x00,0x7F,0xF8,0x01,0x00,0x7E,0xF8,0x01,0x00,0x7E,0xF8,0x00,0x00,0x7E,0xFC,0x00,0x00,0x7C,0xFC,0x00,0x00,0x7C,0xFC,0x00,0x00,0x7C,0xFC,0x00,0x00,0x7C,0xFC,0x00,0x00,0x7C,0xFC,0x00,0x00,0x7C,0xFC,0x00,0x00,0x7C,0xFC,0x00,0x00,0x7C,0xF8,0x00,0x00,0x7C,0xF8,0x01,0x00,0x7E,0xF8,0x01,0x00,0x7E,0xF8,0x01,0x00,0x7E,0xF0,0x03,0x00,0x7F,0xF0,0x03,0x00,0x7F,0xE0,0x07,0x80,0x7F,0xE0,0x0F,0xC0,0x7F,0xC0,0x3F,0xF0,0x7F,0x80,0xFF,0xFF,0x7D,0x00,0xFF,0xFF,0x7C,0x00,0xFE,0x7F,0x7C,0x00,0xF8,0x3F,0x7C,0x00,0xC0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x64 'd'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x3F,0x00,0x00,0x00,0xF8,0xFF,0x01,0x00,0x00,0xFE,0xFF,0x03,0x00,0x00,0xFF,0xFF,0x0F,0x00,0x80,0xFF,0xFF,0x1F,0x00,0xC0,0x3F,0xC0,0x1F,0x00,0xE0,0x0F,0x80,0x3F,0x00,0xE0,0x07,0x00,0x7F,0x00,0xF0,0x03,0x00,0x7E,0x00,0xF0,0x03,0x00,0xFC,0x00,0xF8,0x01,0x00,0xFC,0x00,0xF8,0x01,0x00,0xF8,0x00,0xF8,0x01,0x00,0xF8,0x01,0xF8,0x01,0x00,0xF8,0x01,0xF8,0xFF,0xFF,0xFF,0x01,0xFC,0xFF,0xFF,0xFF,0x01,0xFC,0xFF,0xFF,0xFF,0x01,0xFC,0xFF,0xFF,0xFF,0x01,0xFC,0xFF,0xFF,0xFF,0x01,0xFC,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x00,0xF8,0x01,0x00,0x00,0x00,0xF8,0x01,0x00,0x08,0x00,0xF8,0x01,0x00,0xFC,0x01,0xF0,0x03,0x00,0xFC,0x00,0xF0,0x07,0x00,0xFE,0x00,0xE0,0x0F,0x00,0x7E,0x00,0xE0,0x1F,0x80,0x7F,0x00,0xC0,0x7F,0xC0,0x3F,0x00,0x80,0xFF,0xFF,0x1F,0x00,0x00,0xFF,0xFF,0x0F,0x00,0x00,0xFE,0xFF,0x07,0x00,0x00,0xF8,0xFF,0x01,0x00,0x00,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x65 'e'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x01,0x00,0xFE,0x0F,0x00,0xFF,0x0F,0x80,0xFF,0x0F,0x80,0xFF,0x07,0xC0,0xFF,0x07,0xC0,0x0F,0x00,0xC0,0x0F,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xFE,0xFF,0x03,0xFE,0xFF,0x03,0xFE,0xFF,0x03,0xFE,0xFF,0x03,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0xC0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x66 'f'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x0F,0x00,0x00,0xFC,0x3F,0x7C,0x00,0xFF,0xFF,0x7C,0x80,0xFF,0xFF,0x7D,0xC0,0xFF,0xFF,0x7F,0xE0,0x1F,0xF0,0x7F,0xE0,0x0F,0xC0,0x7F,0xF0,0x07,0x80,0x7F,0xF0,0x03,0x00,0x7F,0xF8,0x01,0x00,0x7E,0xF8,0x01,0x00,0x7E,0xF8,0x01,0x00,0x7E,0xF8,0x00,0x00,0x7C,0xFC,0x00,0x00,0x7C,0xFC,0x00,0x00,0x7C,0xFC,0x00,0x00,0x7C,0xFC,0x00,0x00,0x7C,0xFC,0x00,0x00,0x7C,0xFC,0x00,0x00,0x7C,0xFC,0x00,0x00,0x7C,0xFC,0x00,0x00,0x7C,0xFC,0x00,0x00,0x7C,0xF8,0x01,0x00,0x7E,0xF8,0x01,0x00,0x7E,0xF8,0x01,0x00,0x7E,0xF0,0x03,0x00,0x7F,0xF0,0x07,0x80,0x7F,0xE0,0x0F,0xC0,0x7F,0xE0,0x1F,0xE0,0x7F,0xC0,0xFF,0xFF,0x7F,0x80,0xFF,0xFF,0x7D,0x00,0xFF,0xFF,0x7C,0x00,0xFC,0x3F,0x7C,0x00,0xF0,0x0F,0x7C,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x7E,0xF8,0x00,0x00,0x7E,0xF8,0x01,0x00,0x3E,0xF8,0x01,0x00,0x3F,0xF0,0x03,0x80,0x3F,0xF0,0x07,0xC0,0x1F,0xE0,0x1F,0xF8,0x0F,0xE0,0xFF,0xFF,0x0F,0xC0,0xFF,0xFF,0x03,0x00,0xFF,0xFF,0x01,0x00,0xFC,0x7F,0x00,  // 0x67 'g'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0xFF,0x00,0xF0,0xC3,0xFF,0x03,0xF0,0xF3,0xFF,0x0F,0xF0,0xFB,0xFF,0x1F,0xF0,0xFF,0xFF,0x3F,0xF0,0x7F,0xC0,0x3F,0xF0,0x1F,0x80,0x3F,0xF0,0x0F,0x00,0x7F,0xF0,0x07,0x00,0x7E,0xF0,0x07,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x68 'h'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x69 'i'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF8,0x01,0xFE,0x01,0xFF,0x01,0xFF,0x00,0x7F,0x00,0x3F,0x00,  // 0x6A 'j'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x03,0x80,0x3F,0xF0,0x03,0xC0,0x1F,0xF0,0x03,0xE0,0x0F,0xF0,0x03,0xF0,0x07,0xF0,0x03,0xF8,0x03,0xF0,0x03,0xFC,0x01,0xF0,0x03,0xFE,0x00,0xF0,0x03,0x7F,0x00,0xF0,0x83,0x3F,0x00,0xF0,0xC3,0x0F,0x00,0xF0,0xE3,0x07,0x00,0xF0,0xF3,0x03,0x00,0xF0,0xFB,0x03,0x00,0xF0,0xFF,0x07,0x00,0xF0,0xFF,0x07,0x00,0xF0,0xFF,0x0F,0x00,0xF0,0xDF,0x1F,0x00,0xF0,0x8F,0x1F,0x00,0xF0,0x87,0x3F,0x00,0xF0,0x03,0x7F,0x00,0xF0,0x03,0x7E,0x00,0xF0,0x03,0xFE,0x00,0xF0,0x03,0xFC,0x01,0xF0,0x03,0xF8,0x01,0xF0,0x03,0xF8,0x03,0xF0,0x03,0xF0,0x07,0xF0,0x03,0xE0,0x07,0xF0,0x03,0xE0,0x0F,0xF0,0x03,0xC0,0x1F,0xF0,0x03,0x80,0x1F,0xF0,0x03,0x80,0x3F,0xF0,0x03,0x00,0x7F,0xF0,0x03,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x6B 'k'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x6C 'l'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0xF0,0x07,0x00,0xF0,0xE1,0xFF,0x01,0xFE,0x1F,0x00,0xF0,0xF1,0xFF,0x07,0xFF,0x3F,0x00,0xF0,0xF9,0xFF,0x87,0xFF,0x7F,0x00,0xF0,0xFD,0xFF,0xCF,0xFF,0xFF,0x00,0xF0,0x7F,0xE0,0xFF,0x07,0xFF,0x00,0xF0,0x1F,0xC0,0xFF,0x01,0xFC,0x01,0xF0,0x0F,0x80,0xFF,0x00,0xF8,0x01,0xF0,0x07,0x80,0x7F,0x00,0xF8,0x01,0xF0,0x07,0x00,0x3F,0x00,0xF8,0x01,0xF0,0x07,0x00,0x3F,0x00,0xF8,0x01,0xF0,0x03,0x00,0x3F,0x00,0xF0,0x01,0xF0,0x03,0x00,0x3F,0x00,0xF0,0x01,0xF0,0x03,0x00,0x3F,0x00,0xF0,0x01,0xF0,0x03,0x00,0x3F,0x00,0xF0,0x01,0xF0,0x03,0x00,0x3F,0x00,0xF0,0x01,0xF0,0x03,0x00,0x3F,0x00,0xF0,0x01,0xF0,0x03,0x00,0x3F,0x00,0xF0,0x01,0xF0,0x03,0x00,0x3F,0x00,0xF0,0x01,0xF0,0x03,0x00,0x3F,0x00,0xF0,0x01,0xF0,0x03,0x00,0x3F,0x00,0xF0,0x01,0xF0,0x03,0x00,0x3F,0x00,0xF0,0x01,0xF0,0x03,0x00,0x3F,0x00,0xF0,0x01,0xF0,0x03,0x00,0x3F,0x00,0xF0,0x01,0xF0,0x03,0x00,0x3F,0x00,0xF0,0x01,0xF0,0x03,0x00,0x3F,0x00,0xF0,0x01,0xF0,0x03,0x00,0x3F,0x00,0xF0,0x01,0xF0,0x03,0x00,0x3F,0x00,0xF0,0x01,0xF0,0x03,0x00,0x3F,0x00,0xF0,0x01,0xF0,0x03,0x00,0x3F,0x00,0xF0,0x01,0xF0,0x03,0x00,0x3F,0x00,0xF0,0x01,0xF0,0x03,0x00,0x3F,0x00,0xF0,0x01,0xF0,0x03,0x00,0x3F,0x00,0xF0,0x01,0xF0,0x03,0x00,0x3F,0x00,0xF0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x6D 'm'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0xF0,0xC1,0xFF,0x03,0xF0,0xF1,0xFF,0x0F,0xF0,0xF9,0xFF,0x1F,0xF0,0xFD,0xFF,0x1F,0xF0,0x7F,0xC0,0x3F,0xF0,0x1F,0x80,0x3F,0xF0,0x0F,0x00,0x7F,0xF0,0x07,0x00,0x7E,0xF0,0x07,0x00,0x7E,0xF0,0x07,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0xF0,0x03,0x00,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x6E 'n'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x3F,0x00,0x00,0x00,0xF8,0xFF,0x01,0x00,0x00,0xFE,0xFF,0x07,0x00,0x00,0xFF,0xFF,0x0F,0x00,0x80,0xFF,0xFF,0x1F,0x00,0xC0,0x3F,0xC0,0x3F,0x00,0xE0,0x1F,0x00,0x7F,0x00,0xE0,0x07,0x00,0x7E,0x00,0xF0,0x07,0x00,0xFC,0x00,0xF0,0x03,0x00,0xFC,0x00,0xF8,0x01,0x00,0xF8,0x01,0xF8,0x01,0x00,0xF8,0x01,0xF8,0x01,0x00,0xF8,0x01,0xF8,0x01,0x00,0xF0,0x01,0xF8,0x00,0x00,0xF0,0x01,0xF8,0x00,0x00,0xF0,0x03,0xF8,0x00,0x00,0xF0,0x03,0xF8,0x00,0x00,0xF0,0x03,0xF8,0x00,0x00,0xF0,0x03,0xF8,0x00,0x00,0xF0,0x03,0xF8,0x00,0x00,0xF0,0x01,0xF8,0x01,0x00,0xF8,0x01,0xF8,0x01,0x00,0xF8,0x01,0xF8,0x01,0x00,0xF8,0x01,0xF8,0x03,0x00,0xF8,0x01,0xF0,0x03,0x00,0xFC,0x00,0xF0,0x07,0x00,0xFE,0x00,0xE0,0x0F,0x00,0x7E,0x00,0xE0,0x1F,0x80,0x7F,0x00,0xC0,0x7F,0xE0,0x3F,0x00,0x80,0xFF,0xFF,0x1F,0x00,0x00,0xFF,0xFF,0x0F,0x00,0x00,0xFC,0xFF,0x03,0x00,0x00,0xF8,0xFF,0x00,0x00,0x00,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x6F 'o'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x1F,0x00,0xFC,0xF8,0x7F,0x00,0xFC,0xFC,0xFF,0x01,0xFC,0xFE,0xFF,0x03,0xFC,0xFF,0xFE,0x07,0xFC,0x1F,0xE0,0x0F,0xFC,0x0F,0xC0,0x1F,0xFC,0x07,0x80,0x1F,0xFC,0x03,0x00,0x3F,0xFC,0x01,0x00,0x3F,0xFC,0x01,0x00,0x3E,0xFC,0x00,0x00,0x7E,0xFC,0x00,0x00,0x7E,0xFC,0x00,0x00,0x7E,0xFC,0x00,0x00,0x7E,0xFC,0x00,0x00,0x7C,0xFC,0x00,0x00,0x7C,0xFC,0x00,0x00,0x7C,0xFC,0x00,0x00,0x7C,0xFC,0x00,0x00,0x7E,0xFC,0x00,0x00,0x7E,0xFC,0x00,0x00,0x7E,0xFC,0x00,0x00,0x7E,0xFC,0x00,0x00,0x3E,0xFC,0x01,0x00,0x3F,0xFC,0x01,0x00,0x3F,0xFC,0x03,0x80,0x1F,0xFC,0x07,0xC0,0x1F,0xFC,0x0F,0xE0,0x0F,0xFC,0x1F,0xF0,0x0F,0xFC,0xFF,0xFF,0x07,0xFC,0xFE,0xFF,0x03,0xFC,0xFC,0xFF,0x00,0xFC,0xF0,0x3F,0x00,0xFC,0xC0,0x07,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,  // 0x70 'p'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x0F,0x00,0x00,0xFC,0x3F,0x7C,0x00,0xFE,0xFF,0x7C,0x80,0xFF,0xFF,0x7D,0xC0,0xFF,0xFF,0x7F,0xC0,0x3F,0xF0,0x7F,0xE0,0x0F,0xC0,0x7F,0xE0,0x07,0x80,0x7F,0xF0,0x03,0x00,0x7F,0xF0,0x03,0x00,0x7E,0xF8,0x01,0x00,0x7E,0xF8,0x01,0x00,0x7E,0xF8,0x01,0x00,0x7C,0xF8,0x01,0x00,0x7C,0xF8,0x00,0x00,0x7C,0xF8,0x00,0x00,0x7C,0xF8,0x00,0x00,0x7C,0xF8,0x00,0x00,0x7C,0xF8,0x00,0x00,0x7C,0xF8,0x00,0x00,0x7C,0xF8,0x00,0x00,0x7C,0xF8,0x01,0x00,0x7C,0xF8,0x01,0x00,0x7C,0xF8,0x01,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x07,0x00,0x7F,0xE0,0x07,0x80,0x7F,0xC0,0x1F,0xC0,0x7F,0xC0,0x3F,0xF0,0x7F,0x80,0xFF,0xFF,0x7F,0x00,0xFF,0xFF,0x7D,0x00,0xFC,0xFF,0x7C,0x00,0xF8,0x3F,0x7C,0x00,0xC0,0x07,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7C,  // 0x71 'q'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x07,0xF0,0xF1,0x3F,0xF0,0xF9,0x3F,0xF0,0xF9,0x3F,0xF0,0xFD,0x1F,0xF0,0xFF,0x1F,0xF0,0x3F,0x08,0xF0,0x0F,0x00,0xF0,0x07,0x00,0xF0,0x07,0x00,0xF0,0x07,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0xF0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x72 'r'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x0F,0x00,0x00,0xFF,0x7F,0x00,0x80,0xFF,0xFF,0x01,0xE0,0xFF,0xFF,0x03,0xE0,0xFF,0xFF,0x07,0xF0,0x07,0xF0,0x07,0xF8,0x01,0xE0,0x0F,0xF8,0x01,0xC0,0x0F,0xF8,0x00,0xC0,0x0F,0xF8,0x00,0x80,0x07,0xF8,0x01,0x00,0x00,0xF8,0x03,0x00,0x00,0xF8,0x07,0x00,0x00,0xF0,0x7F,0x00,0x00,0xF0,0xFF,0x03,0x00,0xE0,0xFF,0x3F,0x00,0xC0,0xFF,0xFF,0x01,0x00,0xFF,0xFF,0x03,0x00,0xF8,0xFF,0x07,0x00,0x80,0xFF,0x0F,0x00,0x00,0xFC,0x1F,0x00,0x00,0xE0,0x1F,0x00,0x00,0x80,0x1F,0xC0,0x00,0x00,0x3F,0xFC,0x00,0x00,0x3F,0xFC,0x00,0x00,0x1F,0xF8,0x01,0x80,0x1F,0xF8,0x01,0x80,0x1F,0xF8,0x03,0xC0,0x1F,0xF0,0x0F,0xF0,0x0F,0xE0,0xFF,0xFF,0x07,0xC0,0xFF,0xFF,0x03,0x80,0xFF,0xFF,0x01,0x00,0xFE,0x7F,0x00,0x00,0xF0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x73 's'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x06,0x00,0x80,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xFE,0xFF,0x01,0xFE,0xFF,0x01,0xFE,0xFF,0x01,0xFE,0xFF,0x01,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x0F,0x00,0xC0,0xFF,0x01,0xC0,0xFF,0x01,0xC0,0xFF,0x01,0x80,0xFF,0x01,0x00,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x74 't'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7E,0xF0,0x03,0x00,0x7F,0xF0,0x07,0x00,0x7F,0xE0,0x07,0x80,0x7F,0xE0,0x0F,0xE0,0x7F,0xE0,0x3F,0xF8,0x7F,0xC0,0xFF,0xFF,0x7D,0x80,0xFF,0xFF,0x7C,0x00,0xFF,0x7F,0x7C,0x00,0xFC,0x1F,0x7C,0x00,0xE0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x75 'u'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x7E,0x7E,0x00,0x00,0x7E,0xFC,0x00,0x00,0x3F,0xFC,0x00,0x00,0x3F,0xF8,0x00,0x00,0x1F,0xF8,0x01,0x80,0x1F,0xF8,0x01,0x80,0x1F,0xF0,0x03,0x80,0x0F,0xF0,0x03,0xC0,0x0F,0xF0,0x03,0xC0,0x0F,0xE0,0x07,0xC0,0x07,0xE0,0x07,0xE0,0x07,0xC0,0x07,0xE0,0x03,0xC0,0x0F,0xF0,0x03,0xC0,0x0F,0xF0,0x03,0x80,0x0F,0xF0,0x01,0x80,0x1F,0xF8,0x01,0x00,0x1F,0xF8,0x01,0x00,0x1F,0xF8,0x00,0x00,0x3F,0xFC,0x00,0x00,0x3E,0x7C,0x00,0x00,0x7E,0x7C,0x00,0x00,0x7E,0x7E,0x00,0x00,0x7C,0x3E,0x00,0x00,0x7C,0x3E,0x00,0x00,0xF8,0x3F,0x00,0x00,0xF8,0x1F,0x00,0x00,0xF8,0x1F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x76 'v'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,0xF0,0x03,0x00,0x3F,0x3E,0x00,0xF0,0x03,0x00,0x1F,0x7E,0x00,0xF0,0x07,0x80,0x1F,0x7E,0x00,0xF8,0x07,0x80,0x1F,0x7C,0x00,0xF8,0x07,0x80,0x0F,0xFC,0x00,0xF8,0x07,0x80,0x0F,0xFC,0x00,0xFC,0x0F,0xC0,0x0F,0xF8,0x00,0xFC,0x0F,0xC0,0x07,0xF8,0x00,0xFC,0x0F,0xC0,0x07,0xF8,0x01,0xBC,0x1F,0xE0,0x07,0xF8,0x01,0x3E,0x1F,0xE0,0x03,0xF0,0x01,0x3E,0x1F,0xE0,0x03,0xF0,0x01,0x3E,0x1F,0xF0,0x03,0xF0,0x03,0x1E,0x3F,0xF0,0x01,0xE0,0x03,0x1F,0x3E,0xF0,0x01,0xE0,0x03,0x1F,0x3E,0xF0,0x01,0xE0,0x07,0x1F,0x3E,0xF8,0x01,0xC0,0x87,0x0F,0x7E,0xF8,0x00,0xC0,0x87,0x0F,0x7C,0xF8,0x00,0xC0,0x87,0x0F,0x7C,0xFC,0x00,0x80,0x8F,0x0F,0x7C,0x7C,0x00,0x80,0xCF,0x07,0xFC,0x7C,0x00,0x80,0xCF,0x07,0xF8,0x7C,0x00,0x80,0xDF,0x07,0xF8,0x3E,0x00,0x00,0xDF,0x03,0xF8,0x3E,0x00,0x00,0xFF,0x03,0xF0,0x3F,0x00,0x00,0xFF,0x03,0xF0,0x1F,0x00,0x00,0xFE,0x03,0xF0,0x1F,0x00,0x00,0xFE,0x01,0xF0,0x1F,0x00,0x00,0xFE,0x01,0xE0,0x0F,0x00,0x00,0xFC,0x01,0xE0,0x0F,0x00,0x00,0xFC,0x01,0xE0,0x0F,0x00,0x00,0xFC,0x00,0xE0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x77 'w'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x01,0x80,0x3F,0xF8,0x03,0x80,0x1F,0xF8,0x03,0xC0,0x1F,0xF0,0x07,0xE0,0x0F,0xE0,0x07,0xE0,0x07,0xE0,0x0F,0xF0,0x03,0xC0,0x1F,0xF8,0x03,0x80,0x1F,0xFC,0x01,0x80,0x3F,0xFC,0x00,0x00,0x7F,0xFE,0x00,0x00,0x7E,0x7F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xFC,0x1F,0x00,0x00,0xF8,0x1F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF0,0x07,0x00,0x00,0xF0,0x0F,0x00,0x00,0xF8,0x1F,0x00,0x00,0xF8,0x1F,0x00,0x00,0xFC,0x3F,0x00,0x00,0xFE,0x7F,0x00,0x00,0x7E,0x7E,0x00,0x00,0x3F,0xFC,0x00,0x80,0x3F,0xFC,0x01,0xC0,0x1F,0xF8,0x03,0xC0,0x0F,0xF0,0x03,0xE0,0x0F,0xF0,0x07,0xF0,0x07,0xE0,0x0F,0xF0,0x03,0xC0,0x0F,0xF8,0x03,0xC0,0x1F,0xFC,0x01,0x80,0x3F,0xFC,0x00,0x00,0x3F,0xFE,0x00,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x78 'x'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x7C,0xFC,0x00,0x00,0x7E,0xFC,0x00,0x00,0x3E,0xFC,0x00,0x00,0x3F,0xF8,0x01,0x00,0x3F,0xF8,0x01,0x00,0x1F,0xF0,0x01,0x80,0x1F,0xF0,0x03,0x80,0x1F,0xF0,0x03,0x80,0x0F,0xE0,0x07,0xC0,0x0F,0xE0,0x07,0xC0,0x07,0xE0,0x07,0xC0,0x07,0xC0,0x0F,0xE0,0x07,0xC0,0x0F,0xE0,0x03,0x80,0x0F,0xF0,0x03,0x80,0x1F,0xF0,0x03,0x80,0x1F,0xF0,0x01,0x00,0x1F,0xF8,0x01,0x00,0x3F,0xF8,0x00,0x00,0x3F,0xF8,0x00,0x00,0x7E,0xFC,0x00,0x00,0x7E,0x7C,0x00,0x00,0x7C,0x7C,0x00,0x00,0x7C,0x7E,0x00,0x00,0xFC,0x3E,0x00,0x00,0xF8,0x3E,0x00,0x00,0xF8,0x1F,0x00,0x00,0xF0,0x1F,0x00,0x00,0xF0,0x1F,0x00,0x00,0xF0,0x0F,0x00,0x00,0xE0,0x0F,0x00,0x00,0xE0,0x0F,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x03,0x00,0x00,0xE0,0x03,0x00,0x00,0xF0,0x03,0x00,0x00,0xF0,0x01,0x00,0x00,0xF8,0x01,0x00,0x00,0xF8,0x00,0x00,0x00,0xFE,0x00,0x00,0xF8,0x7F,0x00,0x00,0xF0,0x7F,0x00,0x00,0xF0,0x3F,0x00,0x00,0xF0,0x1F,0x00,0x00,0xF0,0x0F,0x00,0x00,  // 0x79 'y'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0xFC,0xFF,0xFF,0x3F,0x00,0x00,0xC0,0x1F,0x00,0x00,0xE0,0x0F,0x00,0x00,0xF0,0x07,0x00,0x00,0xF8,0x03,0x00,0x00,0xF8,0x01,0x00,0x00,0xFC,0x01,0x00,0x00,0xFE,0x00,0x00,0x00,0x7F,0x00,0x00,0x80,0x3F,0x00,0x00,0xC0,0x1F,0x00,0x00,0xE0,0x0F,0x00,0x00,0xE0,0x07,0x00,0x00,0xF0,0x07,0x00,0x00,0xF8,0x03,0x00,0x00,0xFC,0x01,0x00,0x00,0xFE,0x00,0x00,0x00,0x7F,0x00,0x00,0x80,0x3F,0x00,0x00,0xC0,0x1F,0x00,0x00,0xC0,0x1F,0x00,0x00,0xE0,0x0F,0x00,0x00,0xF0,0x07,0x00,0x00,0xF8,0x03,0x00,0x00,0xFC,0x01,0x00,0x00,0xFE,0xFF,0xFF,0x7F,0xFE,0xFF,0xFF,0x7F,0xFE,0xFF,0xFF,0x7F,0xFE,0xFF,0xFF,0x7F,0xFE,0xFF,0xFF,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x7A 'z'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0xF0,0x0F,0x00,0xF8,0x0F,0x00,0xFC,0x0F,0x00,0xFC,0x0F,0x00,0xFE,0x01,0x00,0x7E,0x00,0x00,0x3E,0x00,0x00,0x3F,0x00,0x00,0x3F,0x00,0x00,0x3F,0x00,0x00,0x3F,0x00,0x00,0x3F,0x00,0x00,0x3F,0x00,0x00,0x3F,0x00,0x00,0x3F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x80,0x1F,0x00,0x80,0x0F,0x00,0xC0,0x0F,0x00,0xF0,0x07,0x00,0xFC,0x03,0x00,0xFC,0x01,0x00,0x7C,0x00,0x00,0xFC,0x01,0x00,0xFC,0x03,0x00,0xF0,0x07,0x00,0xC0,0x0F,0x00,0x80,0x0F,0x00,0x80,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x3F,0x00,0x00,0x3F,0x00,0x00,0x3F,0x00,0x00,0x3F,0x00,0x00,0x3F,0x00,0x00,0x3F,0x00,0x00,0x3F,0x00,0x00,0x3F,0x00,0x00,0x3F,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x7E,0x00,0x00,0xFE,0x01,0x00,0xFC,0x0F,0x00,0xFC,0x0F,0x00,0xF8,0x0F,0x00,0xE0,0x0F,  // 0x7B '{'
    0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,  // 0x7C '|'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x00,0x00,0xFE,0x01,0x00,0xFE,0x03,0x00,0xFE,0x07,0x00,0xFE,0x0F,0x00,0xE0,0x0F,0x00,0x80,0x1F,0x00,0x80,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x3F,0x00,0x00,0x3E,0x00,0x00,0x7E,0x00,0x00,0xFC,0x00,0x00,0xFC,0x01,0x00,0xF8,0x0F,0x00,0xE0,0x0F,0x00,0xC0,0x0F,0x00,0xF0,0x0F,0x00,0xF8,0x0F,0x00,0xFC,0x01,0x00,0x7C,0x00,0x00,0x7E,0x00,0x00,0x3E,0x00,0x00,0x3F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x80,0x1F,0x00,0x80,0x0F,0x00,0xF0,0x0F,0x00,0xFE,0x0F,0x00,0xFE,0x07,0x00,0xFE,0x03,0x00,0xFE,0x01,0x00,  // 0x7D '}'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x00,0x00,0xC0,0xFF,0x01,0x00,0x04,0xE0,0xFF,0x0F,0x00,0x07,0xF8,0xFF,0x3F,0x80,0x07,0xF8,0xFF,0xFF,0xF1,0x07,0xF8,0xFF,0xFF,0xFF,0x07,0xF8,0xE1,0xFF,0xFF,0x07,0x78,0x00,0xFF,0xFF,0x03,0x18,0x00,0xFC,0xFF,0x01,0x08,0x00,0xE0,0x7F,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0x7E '~'
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFF,0xFE,0xFF,0xFE,0xFF,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0x1E,0xE0,0xFE,0xFF,0xFE,0xFF,0xFE,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00  // 0x7F '<non-printable>'
};
