 
#include "mlx90614.h"

MLX90614::MLX90614(I2C* i2c,int addr){

    this->i2caddress = addr;
    this->i2c = i2c; 
    
}


bool MLX90614::getTemp(float* temp_val){

    char p1,p2,p3;
    float temp_thermo;
    bool ch;

    i2c->stop();                            //stop i2c if not ack
    wait(0.010);
    i2c->start();                           //start I2C                   
    ch=i2c->write(i2caddress);              //device address with write condition
    
    if(!ch)return false;                    //No Ack, return False
    
    ch=i2c->write(0x07);                    //device ram address where Tobj value is present

    if(!ch)return false;                    //No Ack, return False


    i2c->start();                           //repeat start
    ch=i2c->write(i2caddress|0x01);         //device address with read condition 
    if(!ch)return false;                    //No Ack, return False

    p1=i2c->read(1);     //Tobj low byte
    p2=i2c->read(1);     //Tobj heigh byte
    p3=i2c->read(0);     //PEC
    
    i2c->stop();                            //stop condition
     
    
    temp_thermo=((((p2&0x007f)<<8)+p1)*0.02)-0.01;      //degree centigrate conversion
    *temp_val=temp_thermo-273;                          //Convert kelvin to degree Celsius
    
    return true;                            //load data successfully, return true 
}

float MLX90614::GetEmissivity(void) {
    char p1,p2,p3;
    float temp_thermo;
    bool ch;


    i2c->stop();                            //stop i2c if not ack
    wait(0.010);
    i2c->start();                           //start I2C                   
    ch = i2c->write(i2caddress);              //device address with write condition
    
    if(!ch)return -90.0f;                    //No Ack, return False
    
    ch = i2c->write(0x24);                    //device ram address where Tobj value is present

    if(!ch)return -91.0f;                    //No Ack, return False


    i2c->start();                           //repeat start
    ch = i2c->write(i2caddress | 0x01);         //device address with read condition 
    if(!ch)return -92.0f;                    //No Ack, return False

    p1 = i2c->read(1);     //Tobj low byte
    p2 = i2c->read(1);     //Tobj heigh byte
    p3 = i2c->read(0);     //PEC
    
    i2c->stop();                            //stop condition
    
    debug_if(debug_mlx90614==true,"p2: %02X, p1: %02X\r\n",p2,p1);
    
    return (((p2<<8) + p1)/65535.0f);                            //load data successfully, return true 
}

int MLX90614::BlankEEPROM(int em) {
    uint8_t p1[5];
    float temp_thermo;
    bool ch;

    p1[0]=i2caddress;
    p1[1]=0x24;
    p1[2]=0x00;
    p1[3]=0x00;

    i2c->stop();                            //stop i2c if not ack
    wait(0.010);
    i2c->start();                           //start I2C                   
    ch = i2c->write(p1[0]);              //device address with write condition    
    if(!ch)return -1;                    //No Ack, return False    

    ch = i2c->write(p1[1]);                    //device ram address where Tobj value is present
    if(!ch)return -2;                    //No Ack, return False
    
    ch = i2c->write(p1[3]);     //Tobj low byte
    if (!ch) return -3;

    ch = i2c->write(p1[2]);     //Tobj heigh byte
    if (!ch) return -4;
    


    ch = i2c->write(em);
    if (!ch) return -5;
    
    i2c->stop();                            //stop condition
     
    debug_if(debug_mlx90614==true,"Em: %1.3f\r\n",GetEmissivity());

    return 0;
}

int MLX90614::InternalSet(uint8_t *p, int idx) {
        uint8_t ch;

        i2c->stop();                            //stop i2c if not ack
        wait(0.010);
        i2c->start();                           //start I2C                   
        ch = i2c->write(p[0]);              //device address with write condition    
        if(!ch)return -1;                    //No Ack, return False    
        
        ch = i2c->write(p[1]);                    //device ram address where Tobj value is present
        if(!ch)return -2;                    //No Ack, return False
                
        ch = i2c->write(p[2]);     //Tobj low byte
        if (!ch) return -3;
        
        ch = i2c->write(p[3]);     //Tobj heigh byte
        if (!ch) return -4;
                
        ch = i2c->write(idx);
        if (!ch) return -5;

        i2c->stop();                            //stop condition

        return 0;
}

int MLX90614::SetEmissivity(float *em) {
    uint8_t p1[5];
    //float temp_thermo;
    bool ch;
    int result;
    uint8_t num[2];

    uint16_t res;

    *em = 65535.0f * (*em);

    num[0] = (int)(*em) & 0xff;
    num[1] = (int)(*em) >> 8;

    p1[0]=i2caddress;
    p1[1]=0x24;
    p1[2]=num[0];
    p1[3]=num[1];

    for (res=0;res<0xff;res++) {
        result = BlankEEPROM(res);
        if (result != -5) break;
    }
    debug_if(debug_mlx90614==true,"Blank EEPROM: %d, ",result);

    for (res=0;res<0xff;res++) {
 
        result = InternalSet(p1, res);

        if ((res > 0xff) || (result == 0) ){
            break;
        }
    }
    
    debug_if(debug_mlx90614==true,"Emissivity Set to: %1.3f\r\n",GetEmissivity());

    return 0;
}
