#include "mbed.h"
#include "C12832.h"
#include "Sht31.h"
#include <string>
#include "Timer.h"

C12832 lcd(SPI_MOSI, SPI_SCK, SPI_MISO, p8, p11);
Sht31 theo(I2C_SDA, I2C_SCL);
DigitalOut led(p5), bed(p6), wed(p7);
Serial device (p8,p9);
InterruptIn  btn(p10);
InterruptIn  swt(p11);

Timer timer;
time_t butnTimerStop, butnTimerStart, stopReading, stopTime, startTime, startReading;
Ticker backagain, resetted, topicTicker, t1, durationTime;
int current=0, state=0, mode=0, direction=0,butnDuration= 0, btnState=1;
int j, k, i, readingDuration, pushDuration;
bool forwards=true;

string str1 = " OUR SERVICE ";
string str2 = " HMS Clinic ";
string str3= " HMS COMPANY \n Client line:+250788312890";
string topics[]={"OUR SERVICE ", "1.Body Temperature", "2. Pulse Rate", "3.Respiration Rate OR \n Rate of Breathing",
"4. Blood pressure ", "5.Press swich for more info", };

string content[]={
"01.HMS is Smart watch clinic", "02.our clinic work 24h", "03.we have profectional,doctors,Nurce ", 
"22.we provide advice,for food, Training Sport", "33.This Excellent clinic service",
"44.it was inverted with Master's students", "55.From University of Rwanda in IOT" };

void display(string sms) { lcd.cls(); 
    lcd.locate(2,5);
    lcd.printf(sms.c_str());
}

void displaycontent() { mode=1;
    display(content[current]);
    //wait_ms(1000);
}
void whiteled() { wed=!wed;}
void scrol(){
        float temp = theo.readTemperature();
        time_t seconds = time(NULL);
        char buffer[32];
        strftime(buffer, 32, "%I:%M %p\n", localtime(&seconds));
        lcd.locate(5, 20); // get cursor to position x=3px and y=5px
        whiteled();
        wait(3);
        lcd.cls(); 
        lcd.set_auto_up(0);
        lcd.setmode(XOR);
    for (i = 0; i <5; i++) { // scrolling text
        lcd.locate(5, i);
        lcd.printf("Local Time: %s",buffer);
        lcd.locate(5, i + 12);
        lcd.printf("Temperature: %.2f C", temp);
        lcd.copy_to_lcd();
        lcd.locate(5, i);
        wait(1);
        lcd.printf("Local Time: %s",buffer);
        lcd.locate(5, i + 12);
        lcd.printf("Temperature: %.2f C", temp);
         i = i + 1;
       }  }
void riseSwt(){
    time(&startReading);
     display(content[current]);
    topicTicker.detach();
}
void function(){ j=0;
    while(j<6 && mode==0){
    whiteled();
    display(topics[j]);
    current=j;
    wait_ms(2000);
    j++;
    }}

void function2(){ k=5;
    while(k>=0 && mode==0){
    whiteled();
    display(topics[k]);
    current=k;
     wait_ms(2000);
    k--;
    }}
   
void changedirection(){
  wait_ms(3000);
  direction=0;
  bed=1;
  if(direction==0){
      bed=led;
      led=!bed;
  }
  if(forwards){
      forwards=!forwards;
      function();
      display(str3);
  }else{
      forwards=!forwards;
      function2();
      display(str3);
  } }
  void fallSwt(){
    topicTicker.detach();
    time(&stopReading);
    readingDuration=stopReading-startReading;
    printf("Reading time is:%d \n", readingDuration);
    if(readingDuration>5){
        printf("message sent,Item Id is:%d \n",current+1);
        function2();
    } }
  
  void mode1() { mode=0;
    display(str3);
}
 void StartButtonTimer(){
     time(&stopTime);
         pushDuration=stopTime-startTime;
            if(pushDuration>5) { display (" Reset to factory.....\n");
            durationTime.detach();
            topicTicker.detach();
            resetted.attach(callback(&function), 10.0f);
            direction=!direction;
            backagain.attach(callback(&mode1),15.0f);
            } else if(pushDuration>3 && state==0 ){ state =0;
            direction=!direction;
            function();
         }
 } 
  void riseBtn(){
     time(&startTime);
 }
void released() { direction=1; }

int main() {
    lcd.locate(5,5);
    display(str2);
    wait_ms(5000);
    scrol();
    btn.fall(callback(&released));
    btn.rise(callback(&StartButtonTimer));
    swt.rise(callback(&displaycontent));
    swt.fall(callback(&mode1));
    function();
    display(str3);
    swt.rise(callback(&riseSwt));
   swt.fall(callback(&fallSwt));
   durationTime.attach(callback(&StartButtonTimer), 0.5f);
    t1.attach(callback(&whiteled), 1.0f);
}