#include "mbed.h"
#include "C12832.h"
#include "Sht31.h"
#include <string>
#include "time.h"

C12832 lcd(SPI_MOSI, SPI_SCK, SPI_MISO, p8, p11);
Sht31 Sht31(I2C_SDA, I2C_SCL);
DigitalOut led(p5);
DigitalOut bed(p6);
DigitalOut wed(p7);
Serial device (p9,p10);
InterruptIn  btn(p10);
InterruptIn  swt(p11);

time_t startTime,startReading,  stopTime,stopReading;
Timeout t;
Ticker topicTicker,durationTime,resetted, backagain,  k;
int i=0, direction=0, pushDuration, current=0, state=0, readingDuration;
 
string str1 = " OUR SERVICE ";
string str2 = " HMS CLINIC";
string str3= " HMS COMPANY \n Client line:+250788312890";
string topics[]={"OUR SERVICE\n1.Body Temperature", "2. Pulse Rate", "3.Respiration Rate OR \n Rate of Breathing",
"4. Blood pressure", "5.Press swich for more info"};

string content[]={ "1A.this's Smartwatch clinic", "2A.our clinic work 24h","3A.we've provide training Sport\nwe profectional,doctors", 
"4A.Our Excellent service \nB. was inverted in UR-ACEIOT", "5A.HMS COMPANY \nB.Client line:+250788312890" };

void display(string sms){
    lcd.cls(); // change dane here
    lcd.locate(3,2);
    lcd.printf(sms.c_str());
}
 
void welcomeMsg(){
    display(str2);
}
void whiteled(){ wed=!wed;
}
void scrolState1(){ 
        float temp = Sht31.readTemperature();
        time_t seconds = time(NULL);
        char buffer[32];
        strftime(buffer, 32, "%I:%M %p\n", localtime(&seconds));
        lcd.locate(5, 20); // get cursor to position x=3px and y=5px
        whiteled();
        wait(3);
        lcd.set_auto_up(0);
        lcd.setmode(XOR);
    for (i = -12; i <12; i++) { // scrolling text
        lcd.locate(5, i);
        lcd.printf("Local Time: %s",buffer);
        lcd.locate(5, i + 12);
        lcd.printf("Temperature: %.2f C", temp);
        lcd.copy_to_lcd();
        lcd.locate(5, i);
        wait(1);
        lcd.printf("Local Time: %s",buffer);
        lcd.locate(5, i + 12);
        lcd.printf("Temperature: %.2f C", temp);
         i = i + 1;
       }  }

void forwards(){ lcd.cls();
   display(topics[i]);
   current=i;
   i+=1;
   if(i>4){
       i=0;
   }
}
void backwards(){
  display(topics[i]);
  current=i;
  i-=1;
  if(i<0){
      i=4;
  }
}
void scrolState2(){
     if(direction==0){
        i=0;
        bed=!led;
         bed=1; led=0;
         topicTicker.attach(callback(&forwards),2.0f);
     } else{ lcd.cls(); 
         i=4;
         led=!bed;
         led=1; bed=0;
         topicTicker.attach(callback(& backwards),2.0f);
     }
 }
 
  void fallBtn() {state = 0;
 }
 void mode1(){
    k.attach(callback(& whiteled),1.0f);
    lcd.cls();
     scrolState1();
     t.attach(callback(&scrolState2), 3.0f);
 }
  
void riseSwt(){
    time(&startReading);
     display(content[current]);
    topicTicker.detach();
}
void fallSwt(){
    topicTicker.detach();
    time(&stopReading);
    readingDuration=stopReading-startReading;
    printf("Reading time is:%d \n",readingDuration);
    if(readingDuration>5){
        printf("message sent,Item Id is:%d \n",current+1);
    }
   scrolState2();    //......................................
}
void countDuration(){
     time(&stopTime);
         pushDuration=stopTime-startTime;
            if(pushDuration>5){
            display("Reset to resetting..");
            durationTime.detach();
            topicTicker.detach();
            resetted.attach(callback(&welcomeMsg),10.0f);
            direction=!direction;
            backagain.attach(callback(&mode1),5.0f);
            lcd.cls();
            }
        else if(pushDuration>3 && state==0 ){
            lcd.cls();
            display("try again..");
            wait_ms(1000);
            state =0;
            direction=!direction;
            scrolState2();
         }
 }
 void riseBtn(){
     time(&startTime);
     durationTime.attach(callback(&countDuration),0.5f);
 }
 
int main() {
    lcd.cls(); 
    lcd.set_auto_up(0);
    welcomeMsg();
    t.attach(callback(&mode1),5.0f);
     btn.rise(callback(&riseBtn));
     btn.fall(callback(&fallBtn));
     swt.rise(callback(&riseSwt));
   swt.fall(callback(&fallSwt));
}