/**
@file main.h
@brief Header file containing functions prototypes, defines and global variables.
@brief Revision 1.0.
@author Laith N. Alnashashibi
@date   May 2015
*/



#include "mbed.h"
#include "BMP180.h"
#include "N5110.h"
#include "beep.h"
 

N5110 lcd(p7,p8,p9,p10,p11,p13,p26);
BMP180 bmp180(p28,p27);   // SDA, SCL
Serial serial(USBTX,USBRX);
Measurement measurement;
/**  
@namespace beep
@output for status beep
*/
Beep buzzer(p21); ///@see
/**  
@namespace myled
@output for status LED
*/
PwmOut myled(p25);
/**  
@namespace myled2
@output for status LED2
*/
PwmOut myled2(p24);
/**  
@namespace mypotentiometer
@output for status potentiometer
*/
AnalogIn mypotentiometer(p20);
/**  
@namespace button
@output for status button
*/
DigitalIn button(p19);


int temp; /*!< temp set in ISR */
float V;
float array[85];
float ave;
float sum=0;
int counter=0; /*!< counter set in ISR */




#endif

