/**
@file main.cpp

@brief Program implementation

*/

#include "main.h"


int main()
{

    /// initiliase barometer

    bmp180.init();
    lcd.init(); /// intialise display
    
    buzzer.beep(1000,0.5);
    lcd.printString("Welcome to",0,1);  /// display splash screen
    lcd.printString("My Temperature",0,2);
    lcd.printString("and Pressure",0,3);
    lcd.printString("Sensor",0,5);
    wait(3);

    lcd.clear();
    lcd.refresh();
    
    
    
    
        while(1) {

            if(button == 1) {
                
                lcd.clear();
                lcd.refresh();
                char buffer[14];
                Measurement measurement;  /// measurement structure declared in BMP180 class
                measurement = bmp180.readValues();
                wait(0.1);
                
                int length = sprintf(buffer, "T = %.2f F", measurement.temperature*9/5+32); ///temp unit changed to F using the formula
                if (length <= 14)
                    lcd.printString(buffer,0,1);
                wait(0.1);

                length = sprintf(buffer, "P =%.2f b ", measurement.pressure/1000); /// pressure unit changed using /1000 to b
                if (length <=14)
                    lcd.printString(buffer,0,2);
                wait(0.1);
                
            } 
            else{
                char buffer[14];
                Measurement measurement;  /// measurement structure declared in BMP180 class
                measurement = bmp180.readValues();
                wait(0.1);

                int length = sprintf(buffer, "T = %.2f C", measurement.temperature); /// temp unit in Celsius
                if (length <= 14)
                    lcd.printString(buffer,0,1);
                wait(0.1);

                length = sprintf(buffer, "P =%.2f mb ", measurement.pressure); /// pressure unit in mb
                if (length <=14)
                    lcd.printString(buffer,0,2);
                wait(0.1);
                ///lcd.refresh();
            }
            Measurement measurement;  /// measurement structure declared in BMP180 class
            measurement = bmp180.readValues();
            wait(0.1);
            temp=measurement.temperature;
            
        
            
            if (measurement.temperature > 30) {
                myled= 0.0; /// LED off
                myled2=1.0; /// LED on
                buzzer.beep(1000,0.5); /// Buzzer on when temp is > 30

            }


            else if (measurement.temperature < 25) { 
                myled=1.0; /// led on 
                myled2=0.0; /// led off
            }

            else {
                myled=0.0; /// both leds are off when temp is between 25-30
                myled2=0.0;
            }


            lcd.setBrightness(1.0); /// put LED backlight on full
            V= mypotentiometer; /// potentiometer controls brightness of the screen
            lcd.setBrightness(V);

            wait(0.01);

        }

    }




