#include "mbed.h"

//indikacija rgb
#define OFF         0
#define ON          1

DigitalOut myled_blue(p16);
DigitalOut myled_green(p30);
DigitalOut myled_red(p15);

DigitalIn start1(p11); 
DigitalIn start2(p12); 
DigitalIn start3(p13); 
DigitalIn start4(p10); 

//nastavitev pwm signalov
PwmOut pwm1 (p21);            
PwmOut pwm2(p22);

//dodano za merjenje toka in napetosti
//def analogno merjenje nap in toka
AnalogIn measVol (p17);
AnalogIn measCurrG (p18);
AnalogIn measCurrH(p19);
float voltageMeas = 0.0;
float voltageCalc = 0.0;
float currentMeasG = 0.0;
float currentCalcG = 0.0;
float currentMeasH = 0.0;
float currentCalcH = 0.0;

float PWM1 = 0.2f; //20% duty cycle
float PWM2 = 0.6f; //60% duty cycle

//funkcija za nastavljanje baudrate pri serijski komunikaciji na PC
void baud(int baudrate)
{
    Serial s(USBTX, USBRX);
    s.baud(baudrate);
}

void merjenjeTokaInNapetosti() {
    
    printf ("\r\n");
    printf ("<------- \r\n");
    printf ("Measurement: \r\n");
    DigitalOut pwmGD (p21);
    pwmGD = 1;
    //pwmHD = 1;
    
    wait(0.1); 

    voltageMeas = measVol.read();
    voltageMeas *= 3.3;
    voltageCalc = voltageMeas * 9.15; //8.2

    currentMeasG = measCurrG.read();
    currentMeasG *= 3.3;
    currentCalcG = currentMeasG * 1.259;

    currentMeasH = measCurrH.read();
    currentMeasH *= 3.3;
    currentCalcH = currentMeasH * 1.279;  
    wait(3);   

    printf("Voltage: %f V\r\n", voltageCalc);
    printf("Current1: %f A\r\n", currentCalcG);
    //printf("Current2: %f A\r\n", currentCalcH);
    printf ("-------> \r\n");

    pwmGD = 0;

    }

int main() 
{   
    //hitrost serijske komunikacije
    baud(9600);
    
    while(1)
    {
        myled_blue  = OFF;
        myled_green  = OFF;
        myled_red  = OFF;
        
        if(start1 == 0)
        {
            myled_blue  = ON;
            merjenjeTokaInNapetosti();
            wait(2);          
        }
        
        else if(start2 == 0)
        {
            //---------------SET
            //signal duration
            float t1 = 0.1;
            float t2 = 0.2;
            //duty cycle
            //float PWM1 = 0.2f; //20% duty cycle
            //float PWM2 = 0.6f; //60% duty cycle
            //---------------SET
            
            myled_green  = ON;
            PwmOut pwm1 (p21);            
            PwmOut pwm2(p22);
            printf ("\r\n");
            printf ("<------- \r\n");
            
            //nastavitev pwm period
            pwm1.period(0.001f);
            pwm2.period(0.001f);
            
            pwm1=0;
            pwm2=0;
            
            printf ("Start \r\n");
            printf("pwm1 read: %f\n\r",pwm1.read()); 
            //printf("pwm2 read: %f\n\r",pwm2.read()); 
            
            //printf ("\r\n");
            
            //printf("pwm1 read: %f\n\r",pwm1.read()*100); 
            
            //izvajanje krmilja
            printf ("PWM set \r\n");
            
            pwm1.write(PWM1);
            
            printf("pwm1 read: %f\n\r",pwm1.read()); 
            //printf("pwm2 read: %f\n\r",pwm2.read()); 
            wait(t1);
            
            printf ("PWM set \r\n");
            pwm1.write(PWM2);
            
            printf("pwm2 read: %f\n\r",pwm1.read()); 
            //printf("pwm2 read: %f\n\r",pwm2.read()); 
            wait(t2);
            printf ("PWM off \r\n");
            pwm1 = 0;
            pwm2 = 0;
            
            
            printf("pwm1 read: %f\n\r",pwm1.read()); 
            //printf("pwm2 read: %f\n\r",pwm2.read()); 
            printf ("End \r\n");
            printf ("-------> \r\n");
            wait(2);
            myled_green  = OFF;   
        }
                
        else if(start3 == 0)
        {
        
            if(PWM1 >= 1.0f)
            {
                PWM1 = 0.0f;
            }
                
            else
            {
                PWM1 = PWM1 + 0.1f;
            }
            
            printf("\n\r");
            printf("PWM1: %f\n\r",PWM1); 
            
            myled_red  = ON;
            wait(0.2);           
        }
        
        else if(start4 == 0)
        {
            if(PWM2 >= 1.0f)
            {
                PWM2 = 0.0f;
            }
                
            else
            {
                PWM2 = PWM2 + 0.1f;
            }
            
            printf("\n\r");
            printf("PWM2: %f\n\r",PWM2);
            
            myled_blue  = ON; 
            myled_red  = ON;  
            myled_green  = ON;
            wait(0.2);         
        }
        
    }
}
