/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */
/*
#define _Sclk PC_10
#define _Dout PC_12
#define _Pwd PC_11
#define _Temp PD_2
#define _A0 PA_0
*/
#include "mbed.h"
#include "constante.h"
#include "ADS1231.h"


// Blinking rate in milliseconds
#define BLINKING_RATE_MS 500

// Pin Ads1232

DigitalOut AdsA0(_A0);
DigitalOut AdsPwd(_Pwd);
DigitalOut AdsTemp(_Temp);

ADS1231  Ads1232  ( _Sclk, _Dout );
Serial pc  ( USBTX, USBRX );
    
ADS1231::ADS1231_status_t      aux;
ADS1231::Vector_count_t        myData;
ADS1231::Vector_mass_t         myCalculatedMass;
ADS1231::Vector_voltage_t      myCalculatedVoltage;

DigitalOut led(LED1);
// Ticker newReading;
/*
void readDATA ( void )
{
    led    =  1;

    /*    aux                 =    Ads1232.ADS1231_ReadRawData       ( &myData, 4 );
        myCalculatedMass    =    Ads1232.ADS1231_CalculateMass     ( &myData, 1.0, ADS1231::ADS1231_SCALE_kg );
        myCalculatedVoltage =    Ads1232.ADS1231_CalculateVoltage  ( &myData, 5.0 );

        pc.printf( "Raw Data: %ld  Mass: %0.5f kg Voltage: %0.5f mV\r\n", (uint32_t)myData.myRawValue, myCalculatedMass.myMass, 1000*myCalculatedVoltage.myVoltage );
    */
/*   led    =  0;
}
*/
int main()
{
    // Initialise the digital pin LED1 as an output

    AdsA0.write(1);    // chanel 1 selectionne
    AdsTemp.write(0);  // entree temp selectionne
    AdsPwd.write(1);   // ADC On

    pc.printf("Bonjour\r\n");

// Reset and wake the device up
    aux = Ads1232.ADS1231_PowerDown    ();
    aux = Ads1232.ADS1231_Reset        ();
    
    pc.printf("PLACEpasdeTRUC\r\n");
    wait(5);

    // CALIBRATION time start!
    // 1. REMOVE THE MASS ON THE LOAD CELL ( ALL LEDs OFF ). Read data without any mass on the load cell
    aux = Ads1232.ADS1231_ReadData_WithoutMass ( &myData, 4 );
    pc.printf("PLACEunTRUC\r\n");

    wait(5);

    // 2. PUT A KNOWN MASS ON THE LOAD CELL ( JUST LED1 ON ). Read data with an user-specified calibration mass
    aux = Ads1232.ADS1231_ReadData_WithCalibratedMass ( &myData, 4 );
    // CALIBRATION time end!


    // [ OPTIONAL ] REMOVE THE MASS ON THE LOAD CELL ( JUST LED2 ON ). Read the device without any mass to calculate the tare weight for 5 seconds

    wait(3);


    // Calculating the tare weight ( JUST LED3 ON )

   // aux = Ads1232.ADS1231_SetAutoTare ( ADS1231::ADS1231_SCALE_kg, &myData, 5 );

 //   newReading.attach( &readDATA, 0.5 );                                        // the address of the function to be attached ( readDATA ) and the interval ( 0.5s ) ( JUST LED4 BLINKING )

    // Let the callbacks take care of everything

    while (true) {
  //      sleep();
    wait(1);
        
        //pc.printf("AdsA0");
    
        led = 0;
        aux                 =    Ads1232.ADS1231_ReadRawData       ( &myData, 4 );
        myCalculatedMass    =    Ads1232.ADS1231_CalculateMass     ( &myData, 1.0, ADS1231::ADS1231_SCALE_kg );
        myCalculatedVoltage =    Ads1232.ADS1231_CalculateVoltage  ( &myData, 5.0 );
        pc.printf( "Raw Data: %ld  Mass: %0.5f kg Voltage: %0.5f mV\r\n", (uint32_t)myData.myRawValue, myCalculatedMass.myMass, 1000*myCalculatedVoltage.myVoltage );
        led = 1;
    }
}

