/***********************************
Name:   BERTL16 Incrementgeber TEST
Author: Jakob Ladner 
description:
         Test des lichtabhängigen Widerstandes RX2 (LDR)
         Rote LED & weiße LED leuchten
***********************************/
#include "mbed.h"
AnalogIn LDR (P0_14);

//rote Led:
DigitalOut LedD10 (P1_18);   // Led D10
DigitalOut LedD11 (P2_16);   // Led D11
DigitalOut LedD13 (P1_21);   // Led D13
DigitalOut LedD12 (P1_20);   // Led D12

//weiße Led:
DigitalOut LedD1 (P1_10);   // Led D1
DigitalOut LedD4 (P1_12);   // Led D4

int main() 
{
    /*
    LedD1.period_ms(1); //Periodendauer auf 1 ms setzen...
    LedD4.period_ms(1); //standard sind 20 ms
    LedD10.period_ms(1);
    LedD11.period_ms(1);
    LedD12.period_ms(1);
    LedD13.period_ms(1);
    */
    
    LedD1=0;
    LedD4=0;
    LedD10=0;
    LedD11=0;
    LedD12=0;
    LedD13=0;
    
    wait(1);
    
    LedD1=1;
    LedD4=1;
    LedD10=1;
    LedD11=1;
    LedD12=1;
    LedD13=1;
    
    wait(1);
    
    while(1)
    { //Auswertung:
        //rote LED leuchten (relativ) zur gemessenen Hellichkeit
        LedD10 = (0.8<LDR);
        LedD11 = (0.6<LDR);
        LedD13 = (0.4<LDR);
        LedD12 = (0.2<LDR);
        
        //weise Led leuchten, um "Licht ins Dunkel" zu bringen...
        LedD1 = LedD4 = (0.6>LDR);
    }
}
