#include "mbed.h"
#include "EthernetInterface.h"
#include <string>

#define ECHO_SERVER_PORT   7

int main (void) {
    
    EthernetInterface eth;
    //1)Inicjalizacja interfejsu (DHCP)
    
    eth.connect();
    //2)
    printf("\nServer IP Address is %s\n", *** );
    
    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();
    
    while (true) {
        printf("\nWait for new connection...\n");
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 20000); // Timeout after 20s
        
        printf("Connection from: %s\n", client.get_address());
        char buffer[256];

        while (true) {
            
            int n = client.receive(buffer, sizeof(buffer));
            
            printf("Received message from Client :'%s'\n",buffer);
            
            client.send_all(buffer, n);
            buffer[n] = '\0';
            
            printf("Variable n is: %d\n", n);
            
            //3
            if(n>0){
                if(strcmp(buffer, "red") == 0){
                    printf("REDled\n");
                    //TODO
                }else if(strcmp(buffer, "green") == 0){
                    printf("GREENled\n");
                    //TODO
                }else if(strcmp(buffer, "blue") == 0){
                    printf("BLUEled\n");
                    //TODO
                }else if(strcmp(buffer, "clear") == 0){
                    printf("CLEAR\n");
                    //TODO
                }else if(strcmp(buffer, "close") == 0){
                    printf("CLOSE\n");
                    break;
                }
            }
            
            printf("Received message from Client :'%s'\n",buffer);
            
            n=0;
 
        }
        client.close();
    }
}
