/* 

2645_I2C_TMP102_Library

Sample code from ELEC2645 Week 17 Lab

Demonstrates how to re-factor the TMP102 code into a library

(c) Craig A. Evans, University of Leeds, Feb 2016

*/ 

#include "mbed.h"
// include the library header, ensure the library has been imported into the project
#include "TMP102.h"

// Create TMP102 object
TMP102 tmp102(I2C_SDA,I2C_SCL);  
// UART connection for PC
Serial pc(USBTX,USBRX);

// K64F on-board LEDs 
//DigitalOut r_led(LED_RED);


// error function hangs flashing an LED
void error();
// setup serial port
void init_serial();
// set-up the on-board LEDs and switches
//void init_K64F();

int main()
{
    // initialise the board and serial port
    //init_K64F();
    init_serial(); 
    // call the sensor init method using dot syntax
    tmp102.init();
    
    while (1) {
        
        // read temperature and print over serial port
        float T = tmp102.get_temperature();
        pc.printf("T = %f C",T);
        // small delay - 1s to match the update rate of the sensor (1 Hz)
        //wait(1);
        
    }

}

void init_serial() {
    // set to highest baud - ensure terminal software matches
    pc.baud(115000); 
}


