#ifndef Serial_Receive_h
#define Serial_Receive_h

#include "mbed.h"
#include <string>

//vars for Serial packet recieve
int receivePacket();
#define SOP '<'
#define EOP '>'
bool started = false;
bool ended = false;
char inData[80];
unsigned char index;

//Vars to process packet
int newData[7] = {0};
char * val;
char * tissue_type_name;
int count = 0;
std::string inString;

int receivePacket(Serial &serialObject){
 //receive data packet
  while(serialObject.readable() > 0)
  {
    char inChar = serialObject.getc();
    
    if(inChar == SOP)
    {
      index = 0;
      inData[index] = '\0';
      started = true;
      ended = false;
    }
    else if(inChar == EOP)
    {
      ended = true;
      break;
    }
    else
    {
      if(index < 79)
      {
        inData[index] = inChar;
        index++;
        inData[index] = '\0';
      }
    }
  }
  // We are here either because all pending serial
  // data has been read OR because an end of
  // packet marker arrived. Which is it?
  if(started && ended)
  {
    inString=std::string(inData);
    tissue_type_name = strtok (inData,",");
        
    //newData[count] = atoi(val);
        
    while ((val = strtok (NULL, ",")) != NULL)
    {
      newData[++count] = atoi(val);
    }
        
    // Reset for the next packet
    started = false;
    ended = false;
    index = 0;
    inData[index] = '\0';
    count = 0;
    
    // Flush any remaining characters from the buffer
    while(serialObject.readable() > 0)
    {
      serialObject.getc();
    }
    
    return 1;
  }
  return 0;
}


#endif