#ifndef SSPI_H
#define SSPI_H

#include "mbed.h"

/* var=target variable, pos=bit number to act upon 0-n */
#define CHECK_BIT(var,pos) ((var) & (1<<(pos)))
#define BIT_SET(var,pos) ((var) |= (1<<(pos)))
#define BIT_CLEAR(var,pos) ((var) &= ~(1<<(pos)))
#define BIT_FLIP(var,pos) ((var) ^= (1<<(pos)))

#define SCLK_DELAY_US 1


class SSPI {

public:
    SSPI(PinName mosi, PinName miso, PinName sclk);
    unsigned char write(unsigned char data);
    
private:
    DigitalOut MOSI;
    DigitalIn MISO;
    DigitalOut SCLK;
};


#endif //SSPI_H