#include "SSPI.h"


SSPI::SSPI(PinName mosi, PinName miso, PinName sclk)
        : MOSI(mosi),
          MISO(miso),
          SCLK(sclk) {
   
}


unsigned char SSPI::write(unsigned char data)
{
  unsigned char i;
  unsigned char out_data=0;
  wait_us(SCLK_DELAY_US);
  SCLK=0;
  for(i=0; i<8; i++)
  {
     wait_us(SCLK_DELAY_US);
     SCLK=1;
     wait_us(SCLK_DELAY_US);
     if(CHECK_BIT(data,7-i))
     {
         MOSI=1;
     }
     else
     {
         MOSI=0;
     }
     out_data= ( out_data << 1 ) | MISO.read();
     SCLK=0;
  }
  return out_data;
}