#include "mbed.h"
#include "ws2801.h"

#define STRIP_LENGTH 40

ws2801 mystrip(p9, p10, STRIP_LENGTH);

int dir=1, level=10;
int rainbow[] = {0xff00ff,0xff00cc,0xff0099,0xff0066,0xff0033,0xff0000,0xff3300,0xff6600,
                 0xff9900,0xffcc00,0xffff00,0xccff00,0x99ff00,0x66ff00,0x33ff00,0x00ff00,
                 0x00ff33,0x00ff66,0x00ff99,0x00ffcc,0x00ffff,0x00ccff,0x0099ff,0x0066ff,
                 0x0033ff,0x0000ff,0x3300ff,0x6600ff,0x9900ff,0xcc00ff,0x9900ff,0x6600ff
                };
              
void move(void){
    int temp = rainbow[31];
    for (int x = (STRIP_LENGTH - 1) ; x > 0 ; x--) rainbow[x] = rainbow[x - 1];
    rainbow[0] = temp;
}    

void pulse(void){
    if(dir)
      {
      mystrip.level(level+=2);
      if(level >= 100)dir = 0;
      }
    else if(!dir)
    {
    mystrip.level(level--);
    if(level <= 5)dir = 1;    
    }
}
       
int main() {
    mystrip.level(level);
    while(1)
      {
      move();
      pulse();
      mystrip.post(rainbow);
      wait_ms(100);
      }
}