// This mbed code starts up a server on the esp8266 and then updates it according to inputs from the controller
// The car will host the server, the controller will send commands to the server

#include "mbed.h"
#include "Motor.h"
#include "Servo.h"

// Construt serial objects
Serial pc(USBTX, USBRX);
Serial esp(p28, p27); // tx, rx
// Construct motor objects
Motor left_motor(p25, p6, p5);      // pwm, fwd, rev
Motor right_motor(p26, p11, p10);    //pwm, fwd, rev
// Construct servo objects
Servo servo_x(p22);
Servo servo_y(p23);

// Standard Mbed LED definitions
DigitalOut  led1(LED1);
DigitalOut  led2(LED2);

// things for sending/receiving data over serial
volatile int tx_in=0;
volatile int tx_out=0;
volatile int rx_in=0;
volatile int rx_out=0;
const int buffer_size = 4095;
char tx_buffer[buffer_size+1];
char rx_buffer[buffer_size+1];
void Tx_interrupt();
void Rx_interrupt();
void read_line();

int DataRX;
char cmdbuff[1024];
char replybuff[4096];
char webdata[4096]; // This may need to be bigger depending on WEB browser used
char webbuff[4096];     // Currently using 1986 characters, Increase this if more web page data added
void SendCMD(),getreply(),getcmd(),startserver();
char rx_line[1024];

// buffers used for taking float values from string commands
char lm_buff[8];
char rm_buff[8];
char xsv_buff[8];
char ysv_buff[8];
char* lm;
char* rm;
char* xsv;

int main()
{
    // Change huzzah baud rate, wait for x amout of time, then set pc/esp.baud
    pc.baud(9600);
    esp.baud(9600);
    led1=0,led2=0;
    left_motor.speed(0);
    right_motor.speed(0);
    servo_x = 0;
    servo_y = 0;
    // Setup a serial interrupt function to receive data
    esp.attach(&Rx_interrupt, Serial::RxIrq);
    // Setup a serial interrupt function to transmit data
    esp.attach(&Tx_interrupt, Serial::TxIrq);
    // Start up the server
    startserver();
    // Indicates the server is set up
    led1 = 1;

    // Everything is interrupt driven, infinite loop
    while(1) {
        // Read data if its available
        if(DataRX==1) {
            led2=!led2;
            getcmd();
            esp.attach(&Rx_interrupt, Serial::RxIrq);
        }
    }
}

// Reads and processes GET and POST web data
void getcmd()
{
    //wait_ms(100);
    esp.attach(NULL,Serial::RxIrq);
    DataRX=0;
    memset(webdata, '\0', sizeof(webdata));
    strcpy(webdata, rx_buffer);
    memset(rx_buffer, '\0', sizeof(rx_buffer));
    rx_in = 0;
    rx_out = 0;
    
    //Print command for debug
    pc.printf(webdata);
    // Modify this to check for our commands
    // check web data for form information
     lm = strstr(webdata, "l=");
     rm =  strstr(webdata, "r=");
     xsv = strstr(webdata, "x=");
    
    if(lm != NULL ) {
        lm = lm + 2;
        for (int i = 0; i < 8; ++i){
            lm_buff[i] = lm[i];
        }
        // Convert the lm_buff to a float value and clear buffer
        left_motor.speed(atof(lm_buff));
        memset(lm_buff, '\0', sizeof(lm_buff));
    }
    if( rm != NULL) {
        rm = rm + 2;
        for (int i = 0; i < 8; ++i) {
            rm_buff[i] = rm[i];
        }
        // Convert the rm_buff to a float value and clear buffer
        right_motor.speed(atof(rm_buff));
        memset(rm_buff, '\0', sizeof(rm_buff));
    }
    
    if(xsv != NULL ) {
        xsv = xsv + 2;
        for (int i = 0; i < 8; ++i){
            xsv_buff[i] = xsv[i];
        }
        // Convert the lm_buff to a float value and clear buffer
        servo_x = atof(xsv_buff);
        memset(xsv_buff, '\0', sizeof(xsv_buff));
    }
    
}
// Starts webserver
void startserver()
{
    // Reset the ESP8266
    pc.printf("++++++++++ Resetting ESP ++++++++++\r\n");
    strcpy(cmdbuff,"node.restart()\r\n");
    SendCMD();
    wait(1);
    
    // Set up WiFi connection
    pc.printf("++++++++++ Connecting to WiFi ++++++++++\r\n");
    
    strcpy(cmdbuff,"wifi.setmode(wifi.STATIONAP)\r\n");
    SendCMD();
    wait(1);
    
    strcpy(cmdbuff,"wifi.ap.config({ssid=\"Marlon's iPhone\",pwd=\"feelsbadman\"})\r\n");
    SendCMD();
    wait(1);    
    
    strcpy(cmdbuff,"print(\"Server IP Address: \", wifi.ap.getip())\r\n");
    SendCMD();
    wait(1);
    
    // Start up the server
    pc.printf("\n++++++++++ Starting Server ++++++++++\r\n> ");

    //create server
    strcpy(cmdbuff, "srv=net.createServer(net.TCP)\r\n");
    SendCMD();
    wait(1);
    // Set the sever to listen (named conn)
    strcpy(cmdbuff,"srv:listen(80,function(conn)\r\n");
    SendCMD();
    wait(1);
        // Define receive function
        strcpy(cmdbuff,"conn:on(\"receive\", function(conn, receivedData)\r\n");
        SendCMD();
        wait(1);
        
        //print data to mbed
        strcpy(cmdbuff,"print(\"Received Data: \" .. receivedData)\r\n");
        SendCMD();
        wait(1);
        
        // End receive function
        strcpy(cmdbuff,"end)\r\n");
        SendCMD();
        wait(1);
        
        // Define sent function
        strcpy(cmdbuff,"conn:on(\"sent\",function(conn)\r\n");
        SendCMD();
        wait(1);
        
        //print data to mbed
        strcpy(cmdbuff,"collectgarbage()\r\n");
        SendCMD();
        wait(1);
        
        // End sent function
        strcpy(cmdbuff,"end)\r\n");
        SendCMD();
        wait(1);
        
    // End server listening    
    strcpy(cmdbuff,"end)\r\n");
    SendCMD();
    wait(2);
}


// ESP Command data send
void SendCMD()
{
    int i;
    char temp_char;
    bool empty;
    i = 0;
// Start Critical Section - don't interrupt while changing global buffer variables
    NVIC_DisableIRQ(UART1_IRQn);
    empty = (tx_in == tx_out);
    while ((i==0) || (cmdbuff[i-1] != '\n')) {
// Wait if buffer full
        if (((tx_in + 1) % buffer_size) == tx_out) {
// End Critical Section - need to let interrupt routine empty buffer by sending
            NVIC_EnableIRQ(UART1_IRQn);
            while (((tx_in + 1) % buffer_size) == tx_out) {
            }
// Start Critical Section - don't interrupt while changing global buffer variables
            NVIC_DisableIRQ(UART1_IRQn);
        }
        tx_buffer[tx_in] = cmdbuff[i];
        i++;
        tx_in = (tx_in + 1) % buffer_size;
    }
    if (esp.writeable() && (empty)) {
        temp_char = tx_buffer[tx_out];
        tx_out = (tx_out + 1) % buffer_size;
// Send first character to start tx interrupts, if stopped
        esp.putc(temp_char);
    }
// End Critical Section
    NVIC_EnableIRQ(UART1_IRQn);
    return;
}


// Get Command and ESP status replies
void getreply()
{
    read_line();
    sscanf(rx_line,replybuff);
}

// FUNCTIONS BELOW ARE FOR RX AND TX INTERUPTS (NOT WEB STUFF)
 
// Read a line from the large rx buffer from rx interrupt routine
void read_line() {
    int i;
    i = 0;
// Start Critical Section - don't interrupt while changing global buffer variables
    NVIC_DisableIRQ(UART1_IRQn);
// Loop reading rx buffer characters until end of line character
    while ((i==0) || (rx_line[i-1] != '\r')) {
// Wait if buffer empty
        if (rx_in == rx_out) {
// End Critical Section - need to allow rx interrupt to get new characters for buffer
            NVIC_EnableIRQ(UART1_IRQn);
            while (rx_in == rx_out) {
            }
// Start Critical Section - don't interrupt while changing global buffer variables
            NVIC_DisableIRQ(UART1_IRQn);
        }
        rx_line[i] = rx_buffer[rx_out];
        i++;
        rx_out = (rx_out + 1) % buffer_size;
    }
// End Critical Section
    NVIC_EnableIRQ(UART1_IRQn);
    rx_line[i-1] = 0;
    return;
}
 
 
// Interupt Routine to read in data from serial port
void Rx_interrupt() {
    DataRX=1;
    //led3=1;
// Loop just in case more than one character is in UART's receive FIFO buffer
// Stop if buffer full
    while ((esp.readable()) && (((rx_in + 1) % buffer_size) != rx_out)) {
        rx_buffer[rx_in] = esp.getc();
// Uncomment to Echo to USB serial to watch data flow
        pc.putc(rx_buffer[rx_in]);
        rx_in = (rx_in + 1) % buffer_size;
    }
    //led3=0;
    return;
}
 
 
// Interupt Routine to write out data to serial port
void Tx_interrupt() {
    //led2=1;
// Loop to fill more than one character in UART's transmit FIFO buffer
// Stop if buffer empty
    while ((esp.writeable()) && (tx_in != tx_out)) {
        esp.putc(tx_buffer[tx_out]);
        tx_out = (tx_out + 1) % buffer_size;
    }
    //led2=0;
    return;
}
