#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include "wave_player.h"
#include "SDFileSystem.h"

uLCD_4DGL lcd(p28,p27,p29);        // LCD (serial tx, serial rx, reset pin;)
//leds using PwmOut
PwmOut red(p26);
PwmOut green(p25);
PwmOut blue(p24);
//Serial out for changing led color using ble
RawSerial bluemod(p9,p10);
//Analog out for speaker, and waveplayer linked to this pin
AnalogOut DACout(p18);
//Wave player and sd system for playing sound clips
wave_player waver(&DACout);
SDFileSystem sd(p5, p6, p7, p8, "sd");
// mutex to make the lcd lib thread safe
Mutex lcd_mutex;
// Global color values used for lighting the led
float ble_red;
float ble_green;
float ble_blue;

// Thread 1
// Read in the color input from ble
void thread1(void const *args)
{   
    char bred=0;
    char bgreen=0;
    char bblue=0;
    
    while(1) {
        //lcd_mutex.lock();
        if (bluemod.getc()=='!') {
            if (bluemod.getc()=='C') { //color data packet
                bred = bluemod.getc(); // RGB color values
                bgreen = bluemod.getc();
                bblue = bluemod.getc();
                if (bluemod.getc()==char(~('!' + 'C' + bred + bgreen + bblue))) { //checksum OK?
                    ble_red = bred/255.0; //send new color to RGB LED PWM outputs
                    ble_green = bgreen/255.0;
                    ble_blue = bblue/255.0;
                }
            }
        }
        //lcd_mutex.unlock();
    }
}
// Thread 2
// Update the lcd with the current rgb values
void thread2(void const *args)
{
    while(true) {       // thread loop
        lcd_mutex.lock();
        lcd.color(WHITE);
        lcd.locate(1,1);
        lcd.printf("R: %f", (float)red);
        lcd.locate(1,3);
        lcd.printf("B: %f", (float)blue);
        lcd.locate(1,5);
        lcd.printf("G: %f", (float)green);
        lcd_mutex.unlock();
        Thread::wait(150);
    }
}
// Thread 3
// Display the current program time
void thread3(void const *args)
{
    int t = 0;
    while(1) {
        lcd_mutex.lock();
        lcd.locate(1,9);
        lcd.color(RED);
        lcd.printf("Time: %d seconds", t);
        lcd_mutex.unlock();
        
        t++;
        Thread::wait(1000);
    }
}
// Thread 4
// Take the color input from ble and ramp it up on the leds
void thread4(void const *args)
{   
    while(1) {
        red = green = blue = 0;
        for (int i = 5; i >= 1; --i) {
            red = ble_red/i;
            green = ble_green/i;
            blue = ble_blue/i;
            Thread::wait(300);
        }
    }   
}

int main()
{
    //Get a file pointer for playing audio
    FILE *wave_file;
    //Jack up the lcds baud rate
    lcd.baudrate(3000000);
    
    Thread t1(thread1); //start thread1
    Thread t2(thread2); //start thread2
    Thread t3(thread3); //start thread3
    Thread t4(thread4); //start thread4

    while(1) {
        wave_file=fopen("/sd/mydir/siren.wav","r");
        if(wave_file==NULL) printf("file open error!\n\n\r");
        waver.play(wave_file);
        fclose(wave_file);
        Thread::wait(1000);
    }
}
