#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include "wave_player.h"
#include "SDFileSystem.h"

uLCD_4DGL lcd(p28,p27,p29);        // LCD (serial tx, serial rx, reset pin;)
//Init leds using PwmOut
PwmOut red(p26);
PwmOut green(p25);
PwmOut blue(p24);
//Analog out for speaker, and waveplayer linked to this pin
AnalogOut DACout(p18);
wave_player waver(&DACout);
//SDFileSystem sd(p5, p6, p7, p8, "sd");
// mutex to make the lcd lib thread safe
Mutex lcd_mutex;

Semaphore lcd_sem(1);
 

// Thread 1, led fire effect
void thread1(void const *args)
{
    while(1) {
        //ramp up brightness level
        for(double x = 0.0; x <= 1.0; x = x+0.2) {
            red = x*x;
            Thread::wait(300);
        }
        red=0;
        //ramp up brightness level
        for(double x = 0.0; x <= 1.0; x = x+0.2) {
            blue = x*x;
            Thread::wait(300);
        }
        blue=0;
    }
}

// Thread 2 update the lcd with the current rgb values
void thread2(void const *args)
{
    while(true) {       // thread loop
        //lcd_mutex.lock();
        lcd_sem.wait();
        lcd.color(WHITE);
        lcd.locate(1,1);
        lcd.printf("R: %f", (float)red);
        lcd.locate(1,3);
        lcd.printf("B: %f", (float)blue);
        //lcd_mutex.unlock();
        lcd_sem.release();
        Thread::wait(150);
    }
}

// Thread 3
// print a sin function in a small window
// the value of DACout pin  changes the speed of the sine wave
void thread3(void const *args)
{
    int t = 0;
    
    while(1) {
        //lcd_mutex.lock();
        lcd_sem.wait();
        lcd.locate(1,9);
        lcd.color(RED);
        lcd.printf("Time: %d seconds", t);
        //lcd_mutex.unlock();
        lcd_sem.release();
        
        t++;
        Thread::wait(1000);
    }
}

int main()
{
    //Get a file pointer for playing audio
    FILE *wave_file;
    //Jack up the lcds baud rate
    lcd.baudrate(3000000);
    green = 0;
    
    Thread t1(thread1); //start thread1
    Thread t2(thread2); //start thread2
    Thread t3(thread3); //start thread3

    while(1) {
        wave_file=fopen("/sd/mydir/siren.wav","r");
        if(wave_file==NULL) printf("file open error!\n\n\r");
        waver.play(wave_file);
        fclose(wave_file);
    }
}
